#include "exportfuncs.h"
#include <stdio.h>
#include <vector>
#include "fscanf.h"

using namespace std;

// int num, ...(num)
int hsp_fscanf_main(FILE *fp, const char *format){
	// 1: num
	int num = code_geti();
	// 2: 0..num-1
	vector< boost::shared_ptr<ScanfBuffer> > args;
	for(int i=0; i<num; i++){
		PVal *pval;
		APTR aptr = code_getva(&pval);
		ScanfBuffer *p = NULL;
		switch(pval->flag){
		// int
		case HSPVAR_FLAG_INT:
			p = new IntBuffer(*pval, aptr);
			break;
		// double
		case HSPVAR_FLAG_DOUBLE:
			p = new DoubleBuffer(*pval, aptr);
			break;
		// str
		case HSPVAR_FLAG_STR:
			p = new StringBuffer(*pval, aptr);
			break;
		default:
			puterror(HSPERR_INVALID_FUNCPARAM);
		}
		args.push_back(boost::shared_ptr<ScanfBuffer>(p));
	}
	// save esp
	int tesp;
	_asm{
		mov tesp, esp;
	}
	// push args
	// fscanf_s(FILE *fp, const char *format, ...);
	for(int i=(int)args.size()-1; i>=0; i--){
		int addition = args[i]->GetAdditionalPush();
		if(addition != 0){
			_asm{
				mov eax, addition;
				push eax
			}
		}
		void * param = args[i]->GetBufferPointer();
		_asm{
			mov eax, param;
			push eax;
		}
	}
	// push rest args, call, get return value
	int retval;
	_asm{
		mov eax, format;
		push eax;
		mov eax, fp;
		push eax;
		call fscanf_s;
		mov retval, eax;
	}
	// restore esp
	_asm{
		mov esp, tesp;
	}
	for(int i=0; i<(int)args.size(); i++){
		args[i]->SetToParameter();
	}
	return retval;
}

int hsp_sscanf_main(const char *src, const char *format){
	// 1: num
	int num = code_geti();
	// 2: 0..num-1
	vector< boost::shared_ptr<ScanfBuffer> > args;
	for(int i=0; i<num; i++){
		PVal *pval;
		APTR aptr = code_getva(&pval);
		ScanfBuffer *p = NULL;
		switch(pval->flag){
		// int
		case HSPVAR_FLAG_INT:
			p = new IntBuffer(*pval, aptr);
			break;
		// double
		case HSPVAR_FLAG_DOUBLE:
			p = new DoubleBuffer(*pval, aptr);
			break;
		// str
		case HSPVAR_FLAG_STR:
			p = new StringBuffer(*pval, aptr);
			break;
		default:
			puterror(HSPERR_INVALID_FUNCPARAM);
		}
		args.push_back(boost::shared_ptr<ScanfBuffer>(p));
	}
	// save esp
	int tesp;
	_asm{
		mov tesp, esp;
	}
	// push args
	// fscanf_s(FILE *fp, const char *format, ...);
	for(int i=(int)args.size()-1; i>=0; i--){
		int addition = args[i]->GetAdditionalPush();
		if(addition != 0){
			_asm{
				mov eax, addition;
				push eax
			}
		}
		void * param = args[i]->GetBufferPointer();
		_asm{
			mov eax, param;
			push eax;
		}
	}
	// push rest args, call, get return value
	int retval;
	_asm{
		mov eax, format;
		push eax;
		mov eax, src;
		push eax;
		call sscanf_s;
		mov retval, eax;
	}
	// restore esp
	_asm{
		mov esp, tesp;
	}
	for(int i=0; i<(int)args.size(); i++){
		args[i]->SetToParameter();
	}
	return retval;
}

