#pragma once

#include <windows.h>
#include "hsp3plugin.h"

class ScanfBuffer{
protected:
	PVal pval;
	APTR aptr;
public:
	ScanfBuffer(PVal &_pval, APTR _aptr) : aptr(_aptr), pval(_pval) { }
	virtual int GetHSPVarType() = 0;
	virtual UINT GetAdditionalPush() = 0;
	virtual void *GetBufferPointer() = 0;
	void SetToParameter(){
		code_setva(&pval, aptr, GetHSPVarType(), GetBufferPointer());
	}
};

class IntBuffer : public ScanfBuffer{
private:
	int ival;
public:
	IntBuffer(PVal &_pval, APTR _aptr) : ScanfBuffer(_pval, _aptr), ival(0) { }
	int GetHSPVarType(){
		return HSPVAR_FLAG_INT;
	}
	UINT GetAdditionalPush(){
		return 0;
	}
	void *GetBufferPointer(){
		return &ival;
	}
};

class DoubleBuffer : public ScanfBuffer{
private:
	double dval;
public:
	DoubleBuffer(PVal &_pval, APTR _aptr) : ScanfBuffer(_pval, _aptr), dval(0) { }
	int GetHSPVarType(){
		return HSPVAR_FLAG_DOUBLE;
	}
	UINT GetAdditionalPush(){
		return 0;
	}
	void *GetBufferPointer(){
		return &dval;
	}
};

class StringBuffer : public ScanfBuffer{
private:
	char sval[1024];
public:
	StringBuffer(PVal &_pval, APTR _aptr) : ScanfBuffer(_pval, _aptr) {
		ZeroMemory(sval, sizeof(sval));
	}
	int GetHSPVarType(){
		return HSPVAR_FLAG_STR;
	}
	UINT GetAdditionalPush(){
		return sizeof(sval) / sizeof(sval[0]) - 1;
	}
	void *GetBufferPointer(){
		return sval;
	}
};

int hsp_fscanf_main(FILE *fp, const char *format);
int hsp_sscanf_main(const char *src, const char *format);
