#include "exportfuncs.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <math.h>
#include "hsp3plugin.h"


void hsp_hugevalfunc(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = HUGE_VAL;
}

// double acos(double x)
void hsp_acos(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = acos(code_getd());
}

// double asin(double x)
void hsp_asin(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = asin(code_getd());
}

// double atan(double x)
void hsp_atan(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = atan(code_getd());
}

// double acos(double y, double x)
void hsp_atan2(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = atan2(code_getd(), code_getd());
}

// double cosh(double x)
void hsp_cosh(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = cosh(code_getd());
}

// double sinh(double x)
void hsp_sinh(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = sinh(code_getd());
}

// double tanh(double x)
void hsp_tanh(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = tanh(code_getd());
}

// double frexp(double value, int *exponent);
void hsp_frexp(FUNC_RESULT *result){
	double value = code_getd();
	PVal *pval;
	APTR aptr = code_getva(&pval);
	int out;
	double ret = frexp(value, &out);
	code_setva(pval, aptr, HSPVAR_FLAG_INT, &out);
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = ret;
}

// double ldexp(double x, int exponent);
void hsp_ldexp(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = ldexp(code_getd(), code_geti());
}

// double log10(double x);
void hsp_log10(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = log10(code_getd());
}

// double modf(double value, double *iptr);
void hsp_modf(FUNC_RESULT *result){
	double value = code_getd();
	PVal *pval;
	APTR aptr = code_getva(&pval);
	double out;
	double ret = modf(value, &out);
	code_setva(pval, aptr, HSPVAR_FLAG_DOUBLE, &out);
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = ret;
}

// double pow(double x, double y);
void hsp_pow(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = pow(code_getd(), code_getd());
}

// double ceil(double x);
void hsp_ceil(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = ceil(code_getd());
}

// double floor(double x);
void hsp_floor(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = floor(code_getd());
}

// double fmod(double x, double y);
void hsp_fmod(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_DOUBLE;
	result->ref_dval = fmod(code_getd(), code_getd());
}
