#include "exportfuncs.h"
#include <stdio.h>
#include <vector>
#include "sprintf.h"

using namespace std;

static const size_t SPRINTF_BUFFER_MAX = 1024;
static char sprintf_buffer[SPRINTF_BUFFER_MAX];

// Returns result of sprintf
// Use all rest hsp parameters to "..."
int hsp_sprintf_main(char **outres, const char *format){
	// ... args
	vector<unsigned int> args3;
	while(code_getprm() >= PARAM_SPLIT){
		switch(mpval->flag){
		// int(4): use directly
		case HSPVAR_FLAG_INT:
			args3.push_back(*(unsigned int *)mpval->pt);
			break;
		// str(4): alloc memory at stack and use its pointer
		case HSPVAR_FLAG_STR:
			{
				char *stack = (char *)_malloca(strlen(mpval->pt));
				strcpy(stack, mpval->pt);
				args3.push_back((unsigned int)stack);
			}
			break;
		// double(8): 4 * 2
		case HSPVAR_FLAG_DOUBLE:
			{
				double dval = *(double *)mpval->pt;
				unsigned int *pval = (unsigned int *)&dval;
				unsigned int high, low;
				high = *pval;
				low = *(pval + 1);
				args3.push_back(high);
				args3.push_back(low);
			}
			break;
		default:
			puterror(HSPERR_INVALID_FUNCPARAM);
		}
	}
	// main
	// _snprintf(char *_Dest, size_t _Count, const char *_Format, ...) 
	// push varargs
	for(int i=(int)args3.size()-1; i>=0; i--){
		unsigned int param = args3[i];
		_asm{
			mov eax, param;
			push eax;
		}
	}
	// push other args, call function, get return value
	int retval;
	char *dest = sprintf_buffer;
	_asm{
		mov eax, format;
		push eax;
		mov eax, SPRINTF_BUFFER_MAX;
		push eax;
		mov eax, dest;
		push eax;
		call _snprintf;
		mov retval, eax;
	}
	sprintf_buffer[SPRINTF_BUFFER_MAX - 1] = '\0';
	// pop args
	for(int i=0; i<(int)args3.size()+3; i++){
		_asm{
			pop eax;
		}
	}
	*outres = sprintf_buffer;
	return retval;
}
