#include "exportfuncs.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <vector>
#include "hsp3plugin.h"
#include "sprintf.h"
#include "fscanf.h"

// Special FILE*
const int HSP_STDIN		= 1;
const int HSP_STDOUT	= 2;
const int HSP_STDERR	= 3;
inline FILE *getfp(int arg){
	FILE *fp = NULL;
	switch(arg){
	case HSP_STDIN:
		fp = stdin;
		break;
	case HSP_STDOUT:
		fp = stdout;
		break;
	case HSP_STDERR:
		fp = stderr;
		break;
	default:
		fp = (FILE *)arg;
	}
	return fp;
}



//
// Important Functions
//

void hsp_fopen(FUNC_RESULT *result){
	boost::shared_array<char> filename = copystr(code_gets());
	boost::shared_array<char> mode = copystr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)fopen(filename.get(), mode.get());
}

void hsp_fclose(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fclose(fp);
}

void hsp_sprintf(FUNC_RESULT *result){
	// 1: char *out
	PVal *pval1;
	APTR aptr1 = code_getva(&pval1);
	// 2: const char *format
	boost::shared_array<char> format = copystr_nocr(code_gets());
	char *res;
	int retval = hsp_sprintf_main(&res, format.get());
	// set to arg1
	code_setva(pval1, aptr1, HSPVAR_FLAG_STR, res);
	// return int
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = retval;
}

// int fprintf(FILE *stream, const char *format, ...);
void hsp_fprintf(FUNC_RESULT *result){
	// 1: FILE *fp
	FILE *fp = getfp(code_geti());
	// 2: const char *format
	boost::shared_array<char> format = copystr_nocr(code_gets());
	char *res;
	int retval = hsp_sprintf_main(&res, format.get());
	fputs(res, fp);
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = retval;
}

// int printf(const char *format, ...);
void hsp_printf(FUNC_RESULT *result){
	// 1: const char *format
	boost::shared_array<char> format = copystr_nocr(code_gets());
	char *res;
	int retval = hsp_sprintf_main(&res, format.get());
	fputs(res, stdout);
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = retval;
}

// int fputc(int c, FILE *stream);
void hsp_fputc(FUNC_RESULT *result){
	int c = code_geti();
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fputc(c, fp);
}

// int putchar(int c);
void hsp_putchar(FUNC_RESULT *result){
	int c = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = putchar(c);
}

// int fputs(const char *s, FILE *stream);
void hsp_fputs(FUNC_RESULT *result){
	boost::shared_array<char> str = copystr_nocr(code_gets());
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fputs(str.get(), fp);
}

// int fputs(const char *s);
void hsp_puts(FUNC_RESULT *result){
	boost::shared_array<char> str = copystr_nocr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = puts(str.get());
}

// int sscanf(const char *src, const char *format, ...); 
void hsp_sscanf(FUNC_RESULT *result){
	boost::shared_array<char> src = copystr_nocr(code_gets());
	boost::shared_array<char> format = copystr_nocr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = hsp_sscanf_main(src.get(), format.get());
}

// int fscanf(FILE *stream, const char *format, ...);
void hsp_fscanf(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	boost::shared_array<char> format = copystr_nocr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = hsp_fscanf_main(fp, format.get());
}

// int scanf(const char *format, ...);
void hsp_scanf(FUNC_RESULT *result){
	boost::shared_array<char> format = copystr_nocr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = hsp_fscanf_main(stdin, format.get());
}

// int fgetc(FILE *fp);
void hsp_fgetc(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fgetc(fp);
}

// int getchar(void);
void hsp_getchar(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = getchar();
}

// char *fgets(char *s, int n, FILE *stream);
void hsp_fgets(FUNC_RESULT *result){
	PVal *pval;
	APTR aptr = code_getva(&pval);
	int n = code_geti();
	FILE *fp = getfp(code_geti());
	boost::shared_array<char> buffer(new char[n]);
	char *res = fgets(buffer.get(), n, fp);
	code_setva(pval, aptr, HSPVAR_FLAG_STR, buffer.get());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)res;
}

// char *gets(char *s);
static char gets_buffer[1024];
void hsp_gets(FUNC_RESULT *result){
	PVal *pval;
	APTR aptr = code_getva(&pval);
	char *res = gets_s(gets_buffer, sizeof(gets_buffer));
	code_setva(pval, aptr, HSPVAR_FLAG_STR, gets_buffer);
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)res;
}

// FILE *freopen(const char *filename, const char *mode, FILE *stream);
void hsp_freopen(FUNC_RESULT *result){
	boost::shared_array<char> filename = copystr_nocr(code_gets());
	boost::shared_array<char> mode = copystr_nocr(code_gets());
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)freopen(filename.get(), mode.get(), fp);
}

//
// Binary I/O
//
// size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
void hsp_fread(FUNC_RESULT *result){
	void *ptr = (void *)code_geti();
	int size = code_geti();
	int nmemb = code_geti();
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)fread(ptr, size, nmemb, fp);
}

// size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
void hsp_fwrite(FUNC_RESULT *result){
	const void *ptr = (const void *)code_geti();
	int size = code_geti();
	int nmemb = code_geti();
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)fwrite(ptr, size, nmemb, fp);
}

//
// Other Functions
//
// void clearerr(FILE *stream);
void hsp_clearerr(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	clearerr_s(fp);
	result->ref_type = 0;
}

// int feof(FILE *stream);
void hsp_feof(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = feof(fp);
}

// int ferror(FILE *stream);
void hsp_ferror(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = ferror(fp);
}

// int fflush(FILE *stream);
void hsp_fflush(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fflush(fp);
}

// int fgetpos(FILE *stream, fpos_t *pos);
void hsp_fgetpos(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	PVal *pval;
	APTR aptr = code_getva(&pval);
	fpos_t pos;
	int res = fgetpos(fp, &pos);
	int ipos = (int)pos;
	code_setva(pval, aptr, HSPVAR_FLAG_INT, &ipos);
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = res;
}

// int fseek(FILE *stream, long int offset, int whence);
void hsp_fseek(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	int offset = code_geti();
	int whence = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fseek(fp, offset, whence);
}

// int fsetpos(FILE *stream, const fpos_t *pos);
void hsp_fsetpos(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	fpos_t pos = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = fsetpos(fp, &pos);
}

// long int ftell(FILE *stream);
void hsp_ftell(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = ftell(fp);
}

// int perror(const char *s);
void hsp_perror(FUNC_RESULT *result){
	perror(code_gets());
	result->ref_type = 0;
}

// int remove(const char *filename);
void hsp_remove(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = remove(code_gets());
}

// int rename(const char *oldpath, const char *newpath);
void hsp_rename(FUNC_RESULT *result){
	boost::shared_array<char> oldpath = copystr(code_gets());
	boost::shared_array<char> newpath = copystr(code_gets());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = rename(oldpath.get(), newpath.get());
}

// void rewind(FILE *stream)
void hsp_rewind(FUNC_RESULT *result){
	FILE *fp = getfp(code_geti());
	rewind(fp);
	result->ref_type = 0;
}

/*
// void setbuf(FILE *stream, char *buf)
void hsp_setbuf(FUNC_RESULT *result){}

// int setvbuf(FILE *stream, char *buf, int mode, size_t size);
void hsp_setvbuf(FUNC_RESULT *result);
*/

// FILE *tmpfile(void);
void hsp_tmpfile(FUNC_RESULT *result){
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)tmpfile();
}

// char *tmpnam(char *s);
void hsp_tmpnam(FUNC_RESULT *result){
	char *ret = tmpnam(code_gets());
	result->ref_type = HSPVAR_FLAG_STR;
	strcpy_s(result->ref_sval, ret);
}

// int ungetc(int c, FILE *stream)
void hsp_ungetc(FUNC_RESULT *result){
	int c = code_geti();
	FILE *fp = getfp(code_geti());
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = ungetc(c, fp);
}

/*
void hsp_vfprintf(FUNC_RESULT *result);
void hsp_vprintf(FUNC_RESULT *result);
void hsp_vsprintf(FUNC_RESULT *result);
*/
