#include "exportfuncs.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <string.h>
#include "hsp3plugin.h"

// void *memcpy(void *dest, const void *src, size_t n);
void hsp_memcpy(FUNC_RESULT *result){
	void *dest = (void *)code_geti();
	void *src = (void *)code_geti();
	int n = code_geti();
	memcpy(dest, src, n);
	result->ref_type = 0;
}

// void *memmove(void *dest, const void *src, size_t n);
void hsp_memmove(FUNC_RESULT *result){
	void *dest = (void *)code_geti();
	void *src = (void *)code_geti();
	int n = code_geti();
	memmove(dest, src, n);
	result->ref_type = 0;
}

// char *strcpy(char *dest, const char *src)
void hsp_strcpy(FUNC_RESULT *result){
	char *dest = (char *)code_geti();
	char *src = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strcpy(dest, src);
}

// char *strncpy(char *dest, const char *src, size_t n)
void hsp_strncpy(FUNC_RESULT *result){
	char *dest = (char *)code_geti();
	char *src = (char *)code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strncpy(dest, src, n);
}

// char *strcat(char *s1, const char *s2)
void hsp_strcat(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strcat(s1, s2);
}

// char *strncat(char *s1, const char *s2, size_t n)
void hsp_strncat(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strncat(s1, s2, n);
}

// int memcmp(const void *s1, const void *s2, size_t n)  
void hsp_memcmp(FUNC_RESULT *result){
	void *s1 = (void *)code_geti();
	void *s2 = (void *)code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = memcmp(s1, s2, n);
}

// int strcmp(const char *s1, const char *s2);
void hsp_strcmp(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = strcmp(s1, s2);
}

// int strcoll(const char *s1, const char *s2)
void hsp_strcoll(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = strcoll(s1, s2);
}

// int strncmp(const char *s1, const char *s2, size_t n)
void hsp_strncomp(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = strncmp(s1, s2, n);
}

// size_t strxfrm(char *s1, const char *s2, size_t n)
void hsp_strxfrm(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strxfrm(s1, s2, n);
}

// void *memchr(const void *s, int c, size_t n)
void hsp_memchr(FUNC_RESULT *result){
	char *s = (char *)code_geti();
	int c = code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)memchr(s, c, n);
}

// char *strchr(const char *s, int c);
void hsp_strchr(FUNC_RESULT *result){
	char *s = (char *)code_geti();
	int c = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strchr(s, c);
}

// size_t strcspn(const char *s1, const char *s2)
void hsp_strcspn(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strcspn(s1, s2);
}

// char *strpbrk(const char *s1, const char *s2)
void hsp_strpbrk(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strpbrk(s1, s2);
}

// char *strrchr(const char *s, int c)
void hsp_strrchr(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	int c = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strrchr(s1, c);
}

// size_t strspn(const char *s1, const char *s2)
void hsp_strspn(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strspn(s1, s2);
}

// char *strstr(const char *s1, const char *s2)
void hsp_strstr(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strspn(s1, s2);
}

// char *strtok(char *s1, const char *s2)
void hsp_strtok(FUNC_RESULT *result){
	char *s1 = (char *)code_geti();
	char *s2 = (char *)code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)strtok(s1, s2);
}

// void *memset(void *s, int c, size_t n)
void hsp_memset(FUNC_RESULT *result){
	void *s = (void *)code_geti();
	int c = code_geti();
	int n = code_geti();
	result->ref_type = HSPVAR_FLAG_INT;
	result->ref_ival = (int)memset(s, c, n);
}

// char *strerror(int errnum)  
void hsp_strerror(FUNC_RESULT *result){
	int errnum = code_geti();
	char *ret = strerror(errnum);
	result->ref_type = HSPVAR_FLAG_STR;
	strcpy_s(result->ref_sval, ret);
}
