#ifndef _HtLib_h
#define _HtLib_h

#include "htlib2.h"

BOOL
M(HTLIB,Init)(HTLIB_HANDLE o,
			  char* send_buffer, HTLIB_USHORT send_len,
			  char* rec_buffer, HTLIB_USHORT rec_len,
			  HTLIB_ERROR* err);

void
M(HTLIB,Uninit)(HTLIB* o);

BOOL
M(HTLIB,Open)(HTLIB_HANDLE o,
			  int timeout_millis,
		   const struct sockaddr* addr,
		   socklen_t addr_len,
		   HTLIB_ERROR* err);

void
M(HTLIB,Attach)(HTLIB_HANDLE o, int socket);

void
M(HTLIB,Reset)(HTLIB_HANDLE o);

void
M(HTLIB,Close)(HTLIB_HANDLE o);


void
M(HTLIB,Cancel)(HTLIB* o, BOOL trueIfCancel);

void
M(HTLIB, CancelAll)(BOOL cancel_or_not);

BOOL
M(HTLIB,CheckCanceled)(HTLIB* o, HTLIB_ERROR* err);

void
M(HTLIB,SetLogHandler)(HTLIB_LOG_HANDLER handler);

void
M(HTLIB,SetLogLevel)(HTLIB_LOGLEVEL levelAndHigher);

const char*
G(GetErrorMessage)(HTLIB_ERROR err);

#endif
