#include "test.h"
#include "cmisc.h"

#define HHMAX 30

static HTLIB_ERROR err;
static HTLIB_Header hh[HHMAX];
static HTLIB_USHORT hhlen;
static int status;

static const char* id = NULL;

static BOOL
chkNoHeader(HTLIB_HANDLE h, const char* name)
{
	return checkNoHeader(h, hh, hhlen, id, name);
}
static BOOL
chkHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkHeader(h, hh, hhlen, id, name, value);
}
static BOOL
chkNotHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkNotHeader(h, hh, hhlen, id, name, value);
}
static char body[10000];

static int
recvBody(HTLIB_HANDLE h)
{
	return receiveBody(h, body, sizeof(body), id);
}

static BOOL
Send(int s, const void* buf, int len)
{
	if (len ==-1) {
		len = strlen(buf);
	}
	while (len>0) {
		int l = send(s, buf, len, MSG_NOSIGNAL);
		if (l==-1) {
			return FALSE;
		}
		len -= l;
		buf = ((char*)buf) + l;
	}
	return TRUE;
}

static void
test1(HTLIB_HANDLE h, const char* path)
{
	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(8000);
	addr.sin_addr.s_addr = htonl(0x7f000001);
	if (HTLIB_Open(h, -1, (struct sockaddr*)&addr, sizeof(addr), &err)
		==FALSE) {
		FAIL(id, "Open");
		return;
	}

	/* "\r" "\n" "\r\n" */
	if (Send(h->soc,
			 "GET /misc/ HTTP/1.1\n"
			 "User-Agent: tcp/1.0\n"
			 "X-Data0:\n"
			 "X-Data1: ver=1.0; tag=1111;\n"
			 " ext1;\n"
			 "\text2=\"a\"\r\n"
			 "X-Data2: ;;;;\n"
			 "Host: localhost:8000\n"
			 "\n", -1)==FALSE) {
		FAIL(id, "Send");
		return;
	}

	h->_flags &= ~0x00013002;

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 100, hh, &hhlen, NULL, &err))!=-1||
		err!=HTLIB_E_TIMEOUT) {
		FAIL(id, "err=%d", err);
		return;
	}
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=999) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (memcmp(body, "index", len)!=0) {
		FAIL(id, "index != %.*s", len, body);
		return;
	}
	SUCCEED(id);
}	


void
testMisc(HTLIB_HANDLE h)
{
	static struct {
		const char* id;
		const char* path;
		void(*func)(HTLIB_HANDLE, const char* path);
	} ff[] = {
		{ "MISC-1(C)", "/misc/", test1 },
	};
	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		id = ff[i].id;
		printf("Test %s...\n", id);
		ff[i].func(h, ff[i].path);
	}
}

