#include "server.h"
#include "spost.h"

static const char* id = NULL;

static BOOL
checkCommon(HTLIB_HANDLE h,
			HTLIB_Header* hh, short hlen, const char* ua)
{
	HTLIB_ERROR err = 0;
	
	if (ua == NULL) {
		ua = "testc/1.0";
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "User-Agent"))==-1) {
		FAIL(id, "no User-Agent");
		return FALSE;
	}
	if (strcmp(hh[i].value, ua)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, ua);
		return FALSE;
	}
	return TRUE;
}
static BOOL
checkHost(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, const char* host)
{
	int i;
	HTLIB_ERROR err = 0;
	
	if (host == NULL) {
		host = "localhost:8000";
	}
	if ((i=HTLIB_Find(hh, hlen, "Host"))==-1) {
		FAIL(id, "no Host");
		return FALSE;
	}
	if (strcmp(hh[i].value, host)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, host);
		return FALSE;
	}
	return TRUE;
}

static BOOL
test1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Length", "5")==FALSE) {
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=5) {
		FAIL(id, "%d must be 5", len);
		return FALSE;
	}
	if (memcmp(body, "12345", len)!=0) {
		FAIL(id, "%.*s must be 12345", len, body);
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 6,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "postok", 6, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "application/octet-stream")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Length", "5")==FALSE) {
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=5) {
		FAIL(id, "%d must be 5", len);
		return FALSE;
	}
	if (memcmp(body, "12\00045", len)!=0) {
		FAIL(id, "%.*s must be 12\\00045", len, body);
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 404, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 6,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "postng", 6, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test3(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Transfer-Encoding", "chunked")==FALSE) {
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=10) {
		FAIL(id, "%d must be 10", len);
		return FALSE;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "chunk end");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test4(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Transfer-Encoding", "chunked")==FALSE) {
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=10) {
		FAIL(id, "%d must be 10", len);
		return FALSE;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
		{ "Connection", "close", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "chunk end");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test5(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Transfer-Encoding", "chunked")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Connection", "close")==FALSE) {
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=10) {
		FAIL(id, "%d must be 10", len);
		return FALSE;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "chunk end");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

BOOL
testPost(HTLIB_HANDLE h, const char* uri, const char* method,
		HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	static struct {
		const char* id;
		const char* path;
		BOOL(*func)(HTLIB_HANDLE, HTLIB_Header*, short hlen, int seq);
	} ff[] = {
		{ "POST-1(S)", "/post/200", test1 },
		{ "POST-2(S)", "/post/404", test2 },
		{ "POST-3(S)", "/post/chunk", test3 },
		{ "POST-4(S)", "/post/endbyclose1", test4 },
		{ "POST-5(S)", "/post/endbyclose2", test5 },
	};

	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		if (strcmp(uri, ff[i].path)==0) {
			id = ff[i].id;
			if (strcmp(method, "POST")!=0) {
				FAIL(id, "%s must be POST", method);
				return FALSE;
			}
			return ff[i].func(h, hh, hlen, seq);
		}
	}

	FAIL("GET-X", "not implemented for %s", uri);
	return FALSE;
}

