package jp.sourceforge.htmlconv;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;

/**
 *
 */
public class Sentence {

	/**
	 *
	 */
	public Sentence(String text) {
		addText(text);
	}

	/**
	 *
	 */
	public void addText(String text) {
		vect.addElement(text);
	}

	/**
	 *
	 */
	public String getHTMLString() {
		StringBuffer strbuf = new StringBuffer();
		Iterator ite = vect.iterator();
		boolean firstf = true;
		while (ite.hasNext()) {
			// 2sȏ゠ꍇ͉s
			if (firstf == false) strbuf.append("<br>");
			Object obj = ite.next();
			if (obj instanceof String) {
				strbuf.append(convertString((String)obj));
			}
			firstf = false;
		}
		return new String(strbuf);
	}

	/**
	 *
	 */
	public String toString() {
		StringBuffer strbuf = new StringBuffer();
		Iterator ite = vect.iterator();
		while (ite.hasNext()) {
			Object obj = ite.next();
			if (obj instanceof String) {
				strbuf.append((String)obj);
			}
		}
		return new String(strbuf);
	}

	/**
	 * str ϊ܂B
	 */
	public static String convertString(String str) {
		return convertString(str, true);
	}

	/**
	 * str ϊ܂B
	 */
	public static String convertString(String str, boolean expand) {
		int len = str.length();
		StringBuffer strbuf = new StringBuffer(len);
		StringBuffer workbuf = new StringBuffer();
		StringBuffer urlbuf = new StringBuffer();
		int mode = 0;
		for (int j = 0; j <= len; j++) {
			char c = ' ';
			if (j == len) {
				if (mode != 2) break;
			}
			else {
				c = str.charAt(j);
			}
			if (mode == 0) {
				// ʏ탂[h
				if (c == '\\') {
					// GXP[v[hɈڍs
					mode = 1;
				}
				else if (c == '@') {
					// N[hɈڍs
					mode = 2;
				}
				else if (c == ' ') {
					strbuf.append(new String(workbuf));
					workbuf = new StringBuffer();
					workbuf.append(c);
				}
				else {
					workbuf.append(c);
				}
			}
			else if (mode == 1) {
				// GXP[v[h
				workbuf.append(c);
				// ʏ탂[hɈڍs
				mode = 0;
			}
			else {
				// N[h
				if (c == ' ' || c == '\t') {
					// ʏ탂[hɈڍs
					mode = 0;
					String name = new String(workbuf);
					if (name.startsWith(" ")) {
						if (name.length() == 1) {
							name = new String(urlbuf);
						}
						else {
							// 󔒂Ŏn܂ꍇ͏Ȃ
							name = name.substring(1);
						}
					}
					if (name.length() == 0) {
						name = new String(urlbuf);
					}
					String urlstr = new String(urlbuf);
					if (expand == false) {
						// HTMLwb_[̃^Cgɂ͉摜܂߂Ȃ
					}
					//else if (isImage(urlstr)) {
					else if (urlstr.startsWith("@")) {
						// 摜̏ꍇ
						urlstr = urlstr.substring(1);
						strbuf.append("<img src=\"");
						strbuf.append(urlstr);
						strbuf.append("\" alt=\"");
						strbuf.append(name);
						strbuf.append("\"");
						if (!urlstr.startsWith("http://")) {
							ImageSizeChecker sizeChecker
								= new ImageSizeChecker();
							sizeChecker.loadFile(urlstr);
							if (sizeChecker.getWidth() > 0) {
								strbuf.append(" width=\"");
								strbuf.append(Integer.toString(
										sizeChecker.getWidth()));
								strbuf.append("\" height=\"");
								strbuf.append(Integer.toString(
										sizeChecker.getHeight()));
								strbuf.append("\"");
							}
						}
						strbuf.append(">");
					}
					else {
						// 摜ȊȌꍇ
						strbuf.append("<a href=\"");
						strbuf.append(urlbuf);
						strbuf.append("\">");
						strbuf.append(name);
						strbuf.append("</a>");
					}
					workbuf = new StringBuffer();
					urlbuf = new StringBuffer();
				}
				else {
					// URL
					urlbuf.append(c);
				}
			}
		}
		strbuf.append(new String(workbuf));
		return new String(strbuf);
	}

	/**
	 *
	 */
/*
	public static boolean isImage(String url) {
		boolean rv = false;
		int pos = url.lastIndexOf(".");
		if (pos >= 0) {
			String ext = url.substring(pos + 1);
			if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")
					|| ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("gif")) {
				rv = true;
			}
		}
		return rv;
	}
*/

	/**
	 *
	 */
	private Vector vect = new Vector();

}

class ImageSizeChecker implements ImageObserver {

	/**
	 *
	 */
	public void loadFile(String fname) {
	end:
		try {
			if (!new File(fname).exists()) break end;
			Toolkit tk = Toolkit.getDefaultToolkit();
			Image image = tk.getImage(fname);
			synchronized (this) {
				width = image.getWidth(this);
				if (width == -1) {
					// ߂ă[hƂ
					wait();
				}
				else {
					// 2ڈȍ~̃[h
					height = image.getHeight(this);
				}
			}
			image.flush();
		}
		catch (Exception x) {
			x.printStackTrace();
		}
	}

	public boolean imageUpdate(Image image, int infoflag, int x, int y
			, int width, int height) {
		if ((infoflag & (WIDTH | HEIGHT)) == (WIDTH | HEIGHT)) {
			this.width = width;
			this.height = height;
			synchronized (this) {
				notify();
			}
			return false;
		}
		return true;
	}

	public int getWidth() {
		return width;
	}

	public int getHeight() {
		return height;
	}

	private int width;

	private int height;

}
