/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.flow.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.arefgard.container.aop.MethodInvocation;
import org.arefgard.container.flow.WorkflowExecutor;
import org.arefgard.container.flow.service.Interface;
import org.arefgard.container.flow.service.Invoke;
import org.arefgard.container.flow.service.Receive;
import org.arefgard.container.flow.service.Reply;
import org.arefgard.container.flow.service.Sequence;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceWorkflowExecutor
implements WorkflowExecutor {
    private static String SEQUENCE_NODE_RECEIVE = "flow:receive";
    private static String SEQUENCE_NODE_INVOKE = "flow:invoke";
    private static String SEQUENCE_NODE_REPLY = "flow:reply";
    private static String XPATH_NODE_INTERFACE = "/workflow/interfaces/interface";
    private static String XPATH_NODE_SEQUENCE = "/workflow/sequence/child::*";
    private static String XPATH_NODE_PARAMETER = "parameter";
    private static String XPATH_NODE_NAVIGATION = "navigation";
    private static String XPATH_ATTR_NAME = "string(@name)";
    private static String XPATH_ATTR_TYPE = "string(@type)";
    private static String XPATH_ATTR_METHOD = "string(@method)";
    private static String XPATH_ATTR_CONDITION = "string(@condition)";
    private static String XPATH_ATTR_TEXT = "text()";
    private XPathExpression XPATH_INTERFACE;
    private XPathExpression XPATH_SEQUENCE;
    private XPathExpression XPATH_PARAMETER;
    private XPathExpression XPATH_NAVIGATION;
    private XPathExpression XPATH_NAME;
    private XPathExpression XPATH_TYPE;
    private XPathExpression XPATH_METHOD;
    private XPathExpression XPATH_CONDITION;
    private XPathExpression XPATH_TEXT;
    private Map<String, Interface> input = null;
    private Map<String, Sequence> sequence = null;
    private Map<String, Object> output = null;
    private String flowPath = null;
    private String statringPoint = null;

    public ServiceWorkflowExecutor(String flowPath) {
        this.flowPath = flowPath;
        this.input = new HashMap<String, Interface>();
        this.sequence = new HashMap<String, Sequence>();
        this.output = new HashMap<String, Object>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            this.XPATH_INTERFACE = xpath.compile(XPATH_NODE_INTERFACE);
            this.XPATH_SEQUENCE = xpath.compile(XPATH_NODE_SEQUENCE);
            this.XPATH_PARAMETER = xpath.compile(XPATH_NODE_PARAMETER);
            this.XPATH_NAVIGATION = xpath.compile(XPATH_NODE_NAVIGATION);
            this.XPATH_NAME = xpath.compile(XPATH_ATTR_NAME);
            this.XPATH_TYPE = xpath.compile(XPATH_ATTR_TYPE);
            this.XPATH_METHOD = xpath.compile(XPATH_ATTR_METHOD);
            this.XPATH_CONDITION = xpath.compile(XPATH_ATTR_CONDITION);
            this.XPATH_TEXT = xpath.compile(XPATH_ATTR_TEXT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parseWorkflow();
    }

    public void execute() throws Exception {
        Sequence sequenceDef;
        Receive start = (Receive)this.sequence.get(this.statringPoint);
        int i = 0;
        while (i < start.getParameterLength()) {
            start.getParameter(i);
            ++i;
        }
        String navi = start.getNavigation("@default");
        while (true) {
            if ((sequenceDef = this.sequence.get(navi)) instanceof Invoke) {
                Invoke invokeDef = (Invoke)sequenceDef;
                Object obj = this.input.get(invokeDef.getType()).getValue();
                String method = invokeDef.getMethod();
                ArrayList<Object> paramList = new ArrayList<Object>();
                int i2 = 0;
                while (i2 < invokeDef.getParameterLength()) {
                    paramList.add(this.input.get(invokeDef.getParameter(i2)).getValue());
                    ++i2;
                }
                MethodInvocation invokeMethod = new MethodInvocation(obj);
                Object result = invokeMethod.execute(method, paramList);
                Interface interfaceDef = this.input.get(method);
                navi = invokeDef.getNavigation("@default");
                continue;
            }
            if (sequenceDef instanceof Reply) break;
        }
        Reply replyDef = (Reply)sequenceDef;
        int i3 = 0;
        while (i3 < replyDef.getParameterLength()) {
            String param = replyDef.getParameter(i3);
            this.output.put(param, this.input.get(param).getValue());
            ++i3;
        }
    }

    public Object getOutput(String key) {
        return this.output.get(key);
    }

    public void setInput(String key, Object obj) {
        Interface interfaceDef = this.input.get(key);
        interfaceDef.setValue(obj);
        this.input.put(key, interfaceDef);
    }

    private void parseWorkflow() {
        int i;
        InputStream is = ClassLoader.getSystemResourceAsStream(this.flowPath);
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception builder) {
            // empty catch block
        }
        try {
            NodeList interfaces = (NodeList)this.XPATH_INTERFACE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < interfaces.getLength()) {
                Node interfaceNode = interfaces.item(i);
                String name = this.getName(interfaceNode);
                String type = this.getType(interfaceNode);
                Interface interfaceDef = new Interface(name, type);
                this.input.put(name, interfaceDef);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NodeList sequences = (NodeList)this.XPATH_SEQUENCE.evaluate(doc, XPathConstants.NODESET);
            i = 0;
            while (i < sequences.getLength()) {
                String nextTo;
                String condition;
                Node naviNode;
                String param;
                NodeList parameters;
                String name;
                Node sequenceNode = sequences.item(i);
                String nodeName = sequenceNode.getNodeName();
                if (nodeName.equals(SEQUENCE_NODE_RECEIVE)) {
                    name = this.getName(sequenceNode);
                    Receive receiveDef = new Receive(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        receiveDef.addParameter(param);
                        ++j;
                    }
                    NodeList navigations = (NodeList)this.XPATH_NAVIGATION.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j2 = 0;
                    while (j2 < navigations.getLength()) {
                        naviNode = navigations.item(j2);
                        condition = this.getCondition(naviNode);
                        nextTo = this.getText(naviNode);
                        receiveDef.addNavigation(condition, nextTo);
                        ++j2;
                    }
                    this.sequence.put(name, receiveDef);
                    this.statringPoint = name;
                } else if (nodeName.equals(SEQUENCE_NODE_INVOKE)) {
                    name = this.getName(sequenceNode);
                    String type = this.getType(sequenceNode);
                    String method = this.getMethod(sequenceNode);
                    Invoke invokeDef = new Invoke(name, type, method);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        invokeDef.addParameter(param);
                        ++j;
                    }
                    NodeList navigations = (NodeList)this.XPATH_NAVIGATION.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j3 = 0;
                    while (j3 < navigations.getLength()) {
                        naviNode = navigations.item(j3);
                        condition = this.getCondition(naviNode);
                        nextTo = this.getText(naviNode);
                        invokeDef.addNavigation(condition, nextTo);
                        ++j3;
                    }
                    this.sequence.put(name, invokeDef);
                } else if (nodeName.equals(SEQUENCE_NODE_REPLY)) {
                    name = this.getName(sequenceNode);
                    Reply replyDef = new Reply(name);
                    parameters = (NodeList)this.XPATH_PARAMETER.evaluate(sequenceNode, XPathConstants.NODESET);
                    int j = 0;
                    while (j < parameters.getLength()) {
                        Node parameterNode = parameters.item(j);
                        param = this.getName(parameterNode);
                        replyDef.addParameter(param);
                        ++j;
                    }
                    this.sequence.put(name, replyDef);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getName(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_NAME.evaluate(obj, XPathConstants.STRING);
    }

    private String getType(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_TYPE.evaluate(obj, XPathConstants.STRING);
    }

    private String getMethod(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_METHOD.evaluate(obj, XPathConstants.STRING);
    }

    private String getCondition(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_CONDITION.evaluate(obj, XPathConstants.STRING);
    }

    private String getText(Object obj) throws XPathExpressionException {
        return (String)this.XPATH_TEXT.evaluate(obj, XPathConstants.STRING);
    }
}

