/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.container.aop;

import java.util.Map;
import java.util.Set;
import org.arefgard.container.aop.ClassStructure;
import org.arefgard.container.aop.ConstructorStructure;
import org.arefgard.container.aop.MethodStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGenerator {
    public static Object generate(String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException("", e);
        }
    }

    public static Object generate(String className, String[] typelist, Object[] objlist) throws ClassNotFoundException {
        try {
            int typesize = typelist.length;
            int objsize = objlist.length;
            int length = 0;
            length = typesize > objsize ? objsize : typesize;
            Class<?> clazz = Class.forName(className);
            ClassStructure structure = ClassStructure.parse(clazz);
            ConstructorStructure construct = structure.getConstructor(objlist);
            if (construct != null) {
                return construct.getConstructor().newInstance(objlist);
            }
            Object obj = clazz.newInstance();
            int i = 0;
            while (i < length) {
                MethodStructure method = structure.getSetter(typelist[i], objlist[i].getClass());
                method.getMethod().invoke(obj, objlist[i]);
                ++i;
            }
            return obj;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("", e);
        }
    }

    public static Object generate(String className, Map<String, Object> property) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(className);
            ClassStructure structure = ClassStructure.parse(clazz);
            Object result = clazz.newInstance();
            if (property != null || property.size() != 0) {
                Set<String> keys = property.keySet();
                for (String key : keys) {
                    Object value = property.get(key);
                    structure.getSetter(key, value.getClass()).getMethod().invoke(result, value);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("", e);
        }
    }
}

