package org.arefgard.container.aop;

import java.lang.reflect.Constructor;
import java.util.List;

public class ConstructorStructure {

	private Constructor constructor;
	private List<String> paramTypes = new java.util.ArrayList<String>();

	public void addParameterType(String name) {
		this.paramTypes .add(name);	
	}
	
	public String getParameterType(int index) {
		return this.paramTypes.get(index);
	}
	
	public int length() {
		return this.paramTypes.size();
	}

	public Constructor getConstructor() {
		return constructor;
	}

	public void setConstructor(Constructor constructor) {
		this.constructor = constructor;
	}
	
	public static ConstructorStructure[] parse(Class cls) {
		Constructor[] constructors = cls.getDeclaredConstructors();
		ConstructorStructure[] structure = new ConstructorStructure[constructors.length];
		int size = constructors.length;
		for(int i = 0; i < size; i++) {
			constructors[i].setAccessible(true);
			Class[] paramClass = constructors[i].getParameterTypes();
			ConstructorStructure constructor = new ConstructorStructure();
			int paramSize = paramClass.length;
			for(int j = 0; j < paramSize; j++) {
				constructor.addParameterType(getType(paramClass[j].getName()));
			}
			constructor.setConstructor(constructors[i]);
			structure[i] = constructor;
		}
		return structure;
	}
	
	private static String getType(String typeName) {
		if(typeName == null || typeName.equals("")) {
			return null;
		}
		if(typeName.equals("boolean")) {
			return "java.lang.Boolean";
		}else if(typeName.equals("byte")) {
			return "java.lang.Byte";
		}else if(typeName.equals("char")) {
			return "java.lang.Character";
		}else if(typeName.equals("double")) {
			return "java.lang.Double";
		}else if(typeName.equals("float")) {
			return "java.lang.Float";
		}else if(typeName.equals("int")) {
			return "java.lang.Integer";
		}else if(typeName.equals("long")) {
			return "java.lang.Long";
		}else if(typeName.equals("short")) {
			return "java.lang.Short";
		}else if(typeName.equals("void")) {
			return "java.lang.Void";
		}else {
			return typeName;
		}
	}
}
