package org.arefgard.container.aop;

import java.lang.reflect.Field;

public class FieldStructure {
	
	private String fieldType;
	private String fieldName;
	private Field field;

	public Field getField() {
		return field;
	}

	public void setField(Field field) {
		this.field = field;
	}

	public FieldStructure(String fieldType, String fieldName) {
		this.fieldType = fieldType;
		this.fieldName = fieldName;
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public String getFieldType() {
		return fieldType;
	}

	public void setFieldType(String fieldType) {
		this.fieldType = fieldType;
	}
	
	public static FieldStructure[] parse(Class cls) {
		Field[] fields = cls.getDeclaredFields();
		FieldStructure[] structure = new FieldStructure[fields.length];
		int size = fields.length;
		for(int i = 0; i < size; i++) {
			fields[i].setAccessible(true);
			String fieldType = getType(fields[i].getType().getName());
			String fieldName = fields[i].getName();
			FieldStructure fs = new FieldStructure(fieldType, fieldName);
			fs.setField(fields[i]);
			structure[i] = fs;
		}
		
		return structure;
	}
	
	private static String getType(String typeName) {
		if(typeName == null || typeName.equals("")) {
			return null;
		}
		if(typeName.equals("boolean")) {
			return "java.lang.Boolean";
		}else if(typeName.equals("byte")) {
			return "java.lang.Byte";
		}else if(typeName.equals("char")) {
			return "java.lang.Character";
		}else if(typeName.equals("double")) {
			return "java.lang.Double";
		}else if(typeName.equals("float")) {
			return "java.lang.Float";
		}else if(typeName.equals("int")) {
			return "java.lang.Integer";
		}else if(typeName.equals("long")) {
			return "java.lang.Long";
		}else if(typeName.equals("short")) {
			return "java.lang.Short";
		}else if(typeName.equals("void")) {
			return "java.lang.Void";
		}else {
			return typeName;
		}
	}
	
}
