/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.flow.core;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsecaseExpression {
    private String expr;
    private Map<String, Object> args = new HashMap<String, Object>();

    public UsecaseExpression(String expr) {
        this.expr = expr;
    }

    public void addArg(String arg, Object value) {
        this.args.put(arg, value);
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public boolean evaluateBoolean() {
        String token = null;
        Object left = null;
        Object right = null;
        boolean isEqual = false;
        boolean isNotEqual = false;
        boolean isLessThan = false;
        boolean isLessThanEqual = false;
        boolean isGreaterThan = false;
        boolean isGreaterThanEqual = false;
        boolean isString = false;
        boolean result = false;
        boolean isLeft = true;
        ConcurrentLinkedQueue<String> tokens = new ConcurrentLinkedQueue<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.expr, ".!=<>\"", true);
        while (tokenizer.hasMoreTokens()) {
            tokens.offer(tokenizer.nextToken());
        }
        while ((token = (String)tokens.peek()) != null) {
            if (this.args.containsKey(token) && isLeft) {
                left = this.args.get(token);
                tokens.remove();
                continue;
            }
            if (token.equals("=")) {
                isEqual = true;
                isLeft = false;
                tokens.remove();
                continue;
            }
            if (token.equals("<")) {
                tokens.remove();
                if (((String)tokens.peek()).equals("=")) {
                    isLessThanEqual = true;
                    tokens.remove();
                } else {
                    isLessThan = true;
                }
                isLeft = false;
                continue;
            }
            if (token.equals(">")) {
                tokens.remove();
                if (((String)tokens.peek()).equals("=")) {
                    isGreaterThanEqual = true;
                    tokens.remove();
                } else {
                    isGreaterThan = true;
                }
                isLeft = false;
                continue;
            }
            if (token.equals("!")) {
                tokens.remove();
                if (!((String)tokens.peek()).equals("=")) continue;
                isNotEqual = true;
                isLeft = false;
                tokens.remove();
                continue;
            }
            if (token.equals("\"")) {
                isString = !isString;
                tokens.remove();
                continue;
            }
            right = isString ? token : (this.args.containsKey(token) ? this.args.get(token) : token);
            tokens.remove();
        }
        if (left instanceof Integer) {
            Integer leftInt = (Integer)left;
            Integer rightInt = null;
            rightInt = right instanceof Integer ? (Integer)right : Integer.valueOf(Integer.parseInt((String)right));
            if (isEqual) {
                result = leftInt.compareTo(rightInt) == 0;
            } else if (isNotEqual) {
                result = leftInt.compareTo(rightInt) != 0;
            } else if (isLessThan) {
                result = leftInt.compareTo(rightInt) < 0;
            } else if (isLessThanEqual) {
                result = leftInt.compareTo(rightInt) <= 0;
            } else if (isGreaterThan) {
                result = leftInt.compareTo(rightInt) > 0;
            } else if (isGreaterThanEqual) {
                result = leftInt.compareTo(rightInt) >= 0;
            }
        } else if (left instanceof Long) {
            Long leftLong = (Long)left;
            Long rightLong = null;
            rightLong = right instanceof Long ? (Long)right : Long.valueOf(Long.parseLong((String)right));
            if (isEqual) {
                result = leftLong.compareTo(rightLong) == 0;
            } else if (isNotEqual) {
                result = leftLong.compareTo(rightLong) != 0;
            } else if (isLessThan) {
                result = leftLong.compareTo(rightLong) < 0;
            } else if (isLessThanEqual) {
                result = leftLong.compareTo(rightLong) <= 0;
            } else if (isGreaterThan) {
                result = leftLong.compareTo(rightLong) > 0;
            } else if (isGreaterThanEqual) {
                result = leftLong.compareTo(rightLong) >= 0;
            }
        } else if (right.equals("null")) {
            if (isEqual) {
                result = left == null;
            } else if (isNotEqual) {
                result = left != null;
            }
        } else if (isEqual) {
            result = left.equals(right);
        } else if (isNotEqual) {
            result = !left.equals(right);
        }
        return result;
    }

    public Object evaluateObject() {
        return null;
    }
}

