/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.intertype;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.exception.CannotCompileRuntimeException;
import org.seasar.framework.exception.NotFoundRuntimeException;
import org.seasar.framework.util.ClassPoolUtil;

public abstract class AbstractInterType
implements InterType {
    public static final String COMPONENT = "instance = prototype";
    protected Class targetClass;
    protected CtClass enhancedClass;
    protected ClassPool classPool;

    public void introduce(Class targetClass, CtClass enhancedClass) {
        this.targetClass = targetClass;
        this.enhancedClass = enhancedClass;
        this.classPool = enhancedClass.getClassPool();
        try {
            this.introduce();
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected abstract void introduce() throws CannotCompileException, NotFoundException;

    protected Class getTargetClass() {
        return this.targetClass;
    }

    protected CtClass getEnhancedClass() {
        return this.enhancedClass;
    }

    protected ClassPool getClassPool() {
        return this.classPool;
    }

    protected void addInterface(Class clazz) {
        this.enhancedClass.addInterface(this.toCtClass(clazz));
    }

    protected void addField(Class type, String name) {
        this.addField(2, type, name);
    }

    protected void addField(Class type, String name, String init) {
        this.addField(2, type, name, init);
    }

    protected void addStaticField(Class type, String name) {
        this.addStaticField(2, type, name);
    }

    protected void addStaticField(Class type, String name, String init) {
        this.addStaticField(2, type, name, init);
    }

    protected void addConstant(Class type, String name, String init) {
        this.addStaticField(17, type, name, init);
    }

    protected void addStaticField(int modifiers, Class type, String name) {
        this.addField(8 | modifiers, type, name);
    }

    protected void addStaticField(int modifiers, Class type, String name, String init) {
        this.addField(8 | modifiers, type, name, init);
    }

    protected void addStaticField(int modifiers, Class type, String name, CtField.Initializer init) {
        this.addField(8 | modifiers, type, name, init);
    }

    protected void addField(int modifiers, Class type, String name) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void addField(String src) {
        try {
            this.enhancedClass.addField(CtField.make((String)src, (CtClass)this.enhancedClass));
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void addField(int modifiers, Class type, String name, String init) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field, init);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void addField(int modifiers, Class type, String name, CtField.Initializer init) {
        try {
            CtField field = new CtField(this.toCtClass(type), name, this.enhancedClass);
            field.setModifiers(modifiers);
            this.enhancedClass.addField(field, init);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void addMethod(String name, String src) {
        this.addMethod(1, Void.TYPE, name, null, null, src);
    }

    protected void addMethod(String name, Class[] paramTypes, String src) {
        this.addMethod(1, Void.TYPE, name, paramTypes, null, src);
    }

    protected void addMethod(String name, Class[] paramTypes, Class[] exceptionTypes, String src) {
        this.addMethod(1, Void.TYPE, name, paramTypes, exceptionTypes, src);
    }

    protected void addMethod(Class returnType, String name, String src) {
        this.addMethod(1, returnType, name, null, null, src);
    }

    protected void addMethod(Class returnType, String name, Class[] paramTypes, String src) {
        this.addMethod(1, returnType, name, paramTypes, null, src);
    }

    protected void addMethod(Class returnType, String name, Class[] paramTypes, Class[] exceptionTypes, String src) {
        this.addMethod(1, returnType, name, paramTypes, exceptionTypes, src);
    }

    protected void addStaticMethod(String name, String src) {
        this.addMethod(9, Void.TYPE, name, null, null, src);
    }

    protected void addStaticMethod(String name, Class[] paramTypes, String src) {
        this.addMethod(9, Void.TYPE, name, paramTypes, null, src);
    }

    protected void addStaticMethod(String name, Class[] paramTypes, Class[] exceptionTypes, String src) {
        this.addMethod(9, Void.TYPE, name, paramTypes, exceptionTypes, src);
    }

    protected void addStaticMethod(Class returnType, String name, String src) {
        this.addMethod(9, returnType, name, null, null, src);
    }

    protected void addStaticMethod(Class returnType, String name, Class[] paramTypes, String src) {
        this.addMethod(9, returnType, name, paramTypes, null, src);
    }

    protected void addStaticMethod(Class returnType, String name, Class[] paramTypes, Class[] exceptionTypes, String src) {
        this.addMethod(9, returnType, name, paramTypes, exceptionTypes, src);
    }

    protected void addMethod(int modifiers, Class returnType, String name, Class[] paramTypes, Class[] exceptionTypes, String src) {
        try {
            CtMethod ctMethod = CtNewMethod.make((int)modifiers, (CtClass)this.toCtClass(returnType), (String)name, (CtClass[])this.toCtClassArray(paramTypes), (CtClass[])this.toCtClassArray(exceptionTypes), (String)src, (CtClass)this.enhancedClass);
            this.enhancedClass.addMethod(ctMethod);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void addMethod(String src) {
        try {
            this.enhancedClass.addMethod(CtNewMethod.make((String)src, (CtClass)this.enhancedClass));
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtClass toCtClass(Class clazz) {
        return ClassPoolUtil.toCtClass(this.classPool, clazz);
    }

    protected CtClass[] toCtClassArray(Class[] classes) {
        return ClassPoolUtil.toCtClassArray(this.classPool, classes);
    }
}

