/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.util;

import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class BeanUtil {
    protected BeanUtil() {
    }

    public static void copyProperties(Map src, Object dest) {
        if (src == null || dest == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        Iterator i = src.keySet().iterator();
        while (i.hasNext()) {
            PropertyDesc pd;
            String key = (String)i.next();
            if (!beanDesc.hasPropertyDesc(key) || !(pd = beanDesc.getPropertyDesc(key)).hasWriteMethod()) continue;
            pd.setValue(dest, src.get(key));
        }
    }

    public static void copyProperties(Object src, Map dest) {
        if (src == null || dest == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        int size = beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasReadMethod() || !pd.hasWriteMethod()) continue;
            Object value = pd.getValue(src);
            dest.put(pd.getPropertyName(), value);
        }
    }

    public static void copyProperties(Object src, Object dest) {
        BeanUtil.copyProperties(src, dest, true);
    }

    public static void copyProperties(Object src, Object dest, boolean includeNull) {
        BeanDesc srcBeanDesc = BeanDescFactory.getBeanDesc(src.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        int propertyDescSize = destBeanDesc.getPropertyDescSize();
        for (int i = 0; i < propertyDescSize; ++i) {
            PropertyDesc destPropertyDesc = destBeanDesc.getPropertyDesc(i);
            String propertyName = destPropertyDesc.getPropertyName();
            if (!srcBeanDesc.hasPropertyDesc(propertyName)) continue;
            PropertyDesc srcPropertyDesc = srcBeanDesc.getPropertyDesc(propertyName);
            if (!destPropertyDesc.hasWriteMethod() || !srcPropertyDesc.hasReadMethod()) continue;
            Object value = srcPropertyDesc.getValue(src);
            if (!includeNull && value == null) continue;
            destPropertyDesc.setValue(dest, srcPropertyDesc.getValue(src));
        }
    }
}

