/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.seasar.framework.container.ExtensionNotFoundRuntimeException;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AssemblerFactory;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.factory.AbstractS2ContainerBuilder;
import org.seasar.framework.container.factory.CircularIncludeRuntimeException;
import org.seasar.framework.container.factory.PathResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.SimplePathResolver;
import org.seasar.framework.container.factory.XmlS2ContainerBuilder;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.ResourceUtil;

public final class S2ContainerFactory {
    public static final String FACTORY_CONFIG_KEY = "org.seasar.framework.container.factory.config";
    public static final String FACTORY_CONFIG_PATH = "s2container.dicon";
    public static final String DEFAULT_BUILDER_NAME = "defaultBuilder";
    protected static boolean initialized;
    protected static boolean configuring;
    protected static S2Container configurationContainer;
    protected static Provider provider;
    protected static S2ContainerBuilder defaultBuilder;
    protected static ThreadLocal processingPaths;
    private static final Logger logger;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$S2ContainerFactory$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$PathResolver;
    static /* synthetic */ Class class$org$seasar$framework$container$ExternalContext;
    static /* synthetic */ Class class$org$seasar$framework$container$ExternalContextComponentDefRegister;
    static /* synthetic */ Class class$org$seasar$framework$container$factory$ResourceResolver;
    static /* synthetic */ Class class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider;
    static /* synthetic */ Class class$org$seasar$framework$container$assembler$AssemblerFactory$Provider;

    public static synchronized S2Container create(String path) {
        if (!initialized) {
            S2ContainerFactory.configure();
        }
        return S2ContainerFactory.getProvider().create(path);
    }

    public static synchronized S2Container create(String path, ClassLoader classLoader) {
        if (!initialized) {
            S2ContainerFactory.configure();
        }
        return S2ContainerFactory.getProvider().create(path, classLoader);
    }

    public static S2Container include(S2Container parent, String path) {
        if (!initialized) {
            S2ContainerFactory.configure();
        }
        return S2ContainerFactory.getProvider().include(parent, path);
    }

    public static void configure() {
        String configFile = System.getProperty(FACTORY_CONFIG_KEY, FACTORY_CONFIG_PATH);
        S2ContainerFactory.configure(configFile);
    }

    public static synchronized void configure(String configFile) {
        if (configuring) {
            return;
        }
        configuring = true;
        if (provider == null) {
            provider = new DefaultProvider();
        }
        if (defaultBuilder == null) {
            defaultBuilder = new XmlS2ContainerBuilder();
        }
        if (ResourceUtil.isExist(configFile)) {
            XmlS2ContainerBuilder builder = new XmlS2ContainerBuilder();
            configurationContainer = builder.build(configFile);
            configurationContainer.init();
            Configurator configurator = configurationContainer.hasComponentDef(Configurator.class) ? (Configurator)configurationContainer.getComponent(Configurator.class) : new DefaultConfigurator();
            configurator.configure(configurationContainer);
        }
        DisposableUtil.add(new Disposable(){

            public void dispose() {
                S2ContainerFactory.destroy();
            }
        });
        configuring = false;
        initialized = true;
    }

    public static synchronized void destroy() {
        defaultBuilder = null;
        provider = null;
        if (configurationContainer != null) {
            configurationContainer.destroy();
        }
        configurationContainer = null;
        initialized = false;
    }

    public static synchronized S2Container getConfigurationContainer() {
        return configurationContainer;
    }

    protected static Provider getProvider() {
        return provider;
    }

    protected static void setProvider(Provider p) {
        provider = p;
    }

    protected static S2ContainerBuilder getDefaultBuilder() {
        return defaultBuilder;
    }

    protected static void setDefaultBuilder(S2ContainerBuilder builder) {
        defaultBuilder = builder;
    }

    protected static void enter(String path) {
        Set paths = (Set)processingPaths.get();
        if (paths.contains(path)) {
            throw new CircularIncludeRuntimeException(path, paths);
        }
        paths.add(path);
    }

    protected static void leave(String path) {
        Set paths = (Set)processingPaths.get();
        paths.remove(path);
    }

    protected static void assertCircularInclude(S2Container container, String path) {
        S2ContainerFactory.assertCircularInclude(container, path, new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertCircularInclude(S2Container container, String path, LinkedList paths) {
        paths.addFirst(container.getPath());
        try {
            if (path.equals(container.getPath())) {
                throw new CircularIncludeRuntimeException(path, new ArrayList(paths));
            }
            for (int i = 0; i < container.getParentSize(); ++i) {
                S2ContainerFactory.assertCircularInclude(container.getParent(i), path, paths);
            }
        }
        finally {
            paths.removeFirst();
        }
    }

    static {
        configuring = false;
        processingPaths = new ThreadLocal(){

            protected Object initialValue() {
                return new LinkedHashSet();
            }
        };
        logger = Logger.getLogger(S2ContainerFactory.class);
        S2ContainerFactory.configure();
    }

    public static class DefaultConfigurator
    implements Configurator {
        public void configure(S2Container configurationContainer) {
            if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$factory$S2ContainerFactory$Provider == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Provider")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Provider)) {
                provider = (Provider)configurationContainer.getComponent(class$org$seasar$framework$container$factory$S2ContainerFactory$Provider == null ? (class$org$seasar$framework$container$factory$S2ContainerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.factory.S2ContainerFactory$Provider")) : class$org$seasar$framework$container$factory$S2ContainerFactory$Provider);
            } else if (provider instanceof DefaultProvider) {
                DefaultProvider dp = (DefaultProvider)provider;
                if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$factory$PathResolver == null ? (class$org$seasar$framework$container$factory$PathResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.PathResolver")) : class$org$seasar$framework$container$factory$PathResolver)) {
                    dp.setPathResolver((PathResolver)configurationContainer.getComponent(class$org$seasar$framework$container$factory$PathResolver == null ? (class$org$seasar$framework$container$factory$PathResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.PathResolver")) : class$org$seasar$framework$container$factory$PathResolver));
                }
                if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$ExternalContext == null ? (class$org$seasar$framework$container$ExternalContext = S2ContainerFactory.class$("org.seasar.framework.container.ExternalContext")) : class$org$seasar$framework$container$ExternalContext)) {
                    dp.setExternalContext((ExternalContext)configurationContainer.getComponent(class$org$seasar$framework$container$ExternalContext == null ? (class$org$seasar$framework$container$ExternalContext = S2ContainerFactory.class$("org.seasar.framework.container.ExternalContext")) : class$org$seasar$framework$container$ExternalContext));
                }
                if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$ExternalContextComponentDefRegister == null ? (class$org$seasar$framework$container$ExternalContextComponentDefRegister = S2ContainerFactory.class$("org.seasar.framework.container.ExternalContextComponentDefRegister")) : class$org$seasar$framework$container$ExternalContextComponentDefRegister)) {
                    dp.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)configurationContainer.getComponent(class$org$seasar$framework$container$ExternalContextComponentDefRegister == null ? (class$org$seasar$framework$container$ExternalContextComponentDefRegister = S2ContainerFactory.class$("org.seasar.framework.container.ExternalContextComponentDefRegister")) : class$org$seasar$framework$container$ExternalContextComponentDefRegister));
                }
            }
            if (configurationContainer.hasComponentDef(S2ContainerFactory.DEFAULT_BUILDER_NAME)) {
                defaultBuilder = (S2ContainerBuilder)configurationContainer.getComponent(S2ContainerFactory.DEFAULT_BUILDER_NAME);
            } else if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$factory$ResourceResolver == null ? (class$org$seasar$framework$container$factory$ResourceResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.ResourceResolver")) : class$org$seasar$framework$container$factory$ResourceResolver) && defaultBuilder instanceof AbstractS2ContainerBuilder) {
                ((AbstractS2ContainerBuilder)defaultBuilder).setResourceResolver((ResourceResolver)configurationContainer.getComponent(class$org$seasar$framework$container$factory$ResourceResolver == null ? (class$org$seasar$framework$container$factory$ResourceResolver = S2ContainerFactory.class$("org.seasar.framework.container.factory.ResourceResolver")) : class$org$seasar$framework$container$factory$ResourceResolver));
            }
            if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider == null ? (class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider = S2ContainerFactory.class$("org.seasar.framework.container.impl.S2ContainerBehavior$Provider")) : class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider)) {
                S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)configurationContainer.getComponent(class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider == null ? (class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider = S2ContainerFactory.class$("org.seasar.framework.container.impl.S2ContainerBehavior$Provider")) : class$org$seasar$framework$container$impl$S2ContainerBehavior$Provider));
            }
            if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider == null ? (class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider")) : class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider)) {
                ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)configurationContainer.getComponent(class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider == null ? (class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider")) : class$org$seasar$framework$container$deployer$ComponentDeployerFactory$Provider));
            }
            if (configurationContainer.hasComponentDef(class$org$seasar$framework$container$assembler$AssemblerFactory$Provider == null ? (class$org$seasar$framework$container$assembler$AssemblerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.assembler.AssemblerFactory$Provider")) : class$org$seasar$framework$container$assembler$AssemblerFactory$Provider)) {
                AssemblerFactory.setProvider((AssemblerFactory.Provider)configurationContainer.getComponent(class$org$seasar$framework$container$assembler$AssemblerFactory$Provider == null ? (class$org$seasar$framework$container$assembler$AssemblerFactory$Provider = S2ContainerFactory.class$("org.seasar.framework.container.assembler.AssemblerFactory$Provider")) : class$org$seasar$framework$container$assembler$AssemblerFactory$Provider));
            }
        }
    }

    public static interface Configurator {
        public void configure(S2Container var1);
    }

    public static class DefaultProvider
    implements Provider {
        public static final String pathResolver_BINDING = "bindingType=may";
        public static final String externalContext_BINDING = "bindingType=may";
        public static final String externalContextComponentDefRegister_BINDING = "bindingType=may";
        protected PathResolver pathResolver = new SimplePathResolver();
        protected ExternalContext externalContext;
        protected ExternalContextComponentDefRegister externalContextComponentDefRegister;

        public PathResolver getPathResolver() {
            return this.pathResolver;
        }

        public void setPathResolver(PathResolver pathResolver) {
            this.pathResolver = pathResolver;
        }

        public ExternalContext getExternalContext() {
            return this.externalContext;
        }

        public void setExternalContext(ExternalContext externalContext) {
            this.externalContext = externalContext;
        }

        public ExternalContextComponentDefRegister getExternalContextComponentDefRegister() {
            return this.externalContextComponentDefRegister;
        }

        public void setExternalContextComponentDefRegister(ExternalContextComponentDefRegister externalContextComponentDefRegister) {
            this.externalContextComponentDefRegister = externalContextComponentDefRegister;
        }

        public S2Container create(String path) {
            ClassLoader classLoader = configurationContainer != null && configurationContainer.hasComponentDef(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = S2ContainerFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader) ? (ClassLoader)configurationContainer.getComponent(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = S2ContainerFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader) : Thread.currentThread().getContextClassLoader();
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0106", new Object[]{path});
            }
            S2Container container = this.build(path, classLoader);
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0107", new Object[]{path});
            }
            return container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S2Container create(String path, ClassLoader classLoader) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                S2Container s2Container = this.create(path);
                return s2Container;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public S2Container include(S2Container parent, String path) {
            String realPath = this.pathResolver.resolvePath(parent.getPath(), path);
            S2ContainerFactory.assertCircularInclude(parent, realPath);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container root = parent.getRoot();
                S2Container child = null;
                S2Container s2Container = root;
                synchronized (s2Container) {
                    if (root.hasDescendant(realPath)) {
                        child = root.getDescendant(realPath);
                        parent.include(child);
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.log("DSSR0106", new Object[]{path});
                        }
                        String ext = this.getExtension(realPath);
                        S2ContainerBuilder builder = this.getBuilder(ext);
                        child = builder.include(parent, realPath);
                        root.registerDescendant(child);
                        if (logger.isDebugEnabled()) {
                            logger.log("DSSR0107", new Object[]{path});
                        }
                    }
                }
                s2Container = child;
                return s2Container;
            }
            finally {
                S2ContainerFactory.leave(realPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected S2Container build(String path, ClassLoader classLoader) {
            String realPath = this.pathResolver.resolvePath(null, path);
            S2ContainerFactory.enter(realPath);
            try {
                String ext = this.getExtension(realPath);
                S2Container container = this.getBuilder(ext).build(realPath, classLoader);
                container.setExternalContext(this.externalContext);
                container.setExternalContextComponentDefRegister(this.externalContextComponentDefRegister);
                S2Container s2Container = container;
                return s2Container;
            }
            finally {
                S2ContainerFactory.leave(realPath);
            }
        }

        protected String getExtension(String path) {
            String ext = ResourceUtil.getExtension(path);
            if (ext == null) {
                throw new ExtensionNotFoundRuntimeException(path);
            }
            return ext;
        }

        protected S2ContainerBuilder getBuilder(String ext) {
            if (configurationContainer != null && configurationContainer.hasComponentDef(ext)) {
                return (S2ContainerBuilder)configurationContainer.getComponent(ext);
            }
            return defaultBuilder;
        }
    }

    public static interface Provider {
        public S2Container create(String var1);

        public S2Container create(String var1, ClassLoader var2);

        public S2Container include(S2Container var1, String var2);
    }
}

