/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.InterTypeDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.util.AopProxyUtil;
import org.seasar.framework.container.util.ArgDefSupport;
import org.seasar.framework.container.util.AspectDefSupport;
import org.seasar.framework.container.util.DestroyMethodDefSupport;
import org.seasar.framework.container.util.InitMethodDefSupport;
import org.seasar.framework.container.util.InterTypeDefSupport;
import org.seasar.framework.container.util.MetaDefSupport;
import org.seasar.framework.container.util.PropertyDefSupport;

public class ComponentDefImpl
implements ComponentDef,
ContainerConstants {
    private Class componentClass;
    private String componentName;
    private Class concreteClass;
    private S2Container container;
    private Expression expression;
    private ArgDefSupport argDefSupport = new ArgDefSupport();
    private PropertyDefSupport propertyDefSupport = new PropertyDefSupport();
    private InitMethodDefSupport initMethodDefSupport = new InitMethodDefSupport();
    private DestroyMethodDefSupport destroyMethodDefSupport = new DestroyMethodDefSupport();
    private AspectDefSupport aspectDefSupport = new AspectDefSupport();
    private InterTypeDefSupport interTypeDefSupport = new InterTypeDefSupport();
    private MetaDefSupport metaDefSupport = new MetaDefSupport();
    private InstanceDef instanceDef = InstanceDefFactory.SINGLETON;
    private AutoBindingDef autoBindingDef = AutoBindingDefFactory.AUTO;
    private ComponentDeployer componentDeployer;
    private boolean externalBinding = false;

    public ComponentDefImpl() {
    }

    public ComponentDefImpl(Class componentClass) {
        this(componentClass, null);
    }

    public ComponentDefImpl(Class componentClass, String componentName) {
        this.componentClass = componentClass;
        this.setComponentName(componentName);
    }

    public Object getComponent() {
        return this.getComponentDeployer().deploy();
    }

    public void injectDependency(Object outerComponent) {
        this.getComponentDeployer().injectDependency(outerComponent);
    }

    public final Class getComponentClass() {
        return this.componentClass;
    }

    public final String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Class getConcreteClass() {
        if (this.concreteClass == null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader loader;
                ClassLoader classLoader = loader = this.container != null ? this.container.getClassLoader() : null;
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                this.concreteClass = AopProxyUtil.getConcreteClass(this);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return this.concreteClass;
    }

    public final S2Container getContainer() {
        return this.container;
    }

    public final void setContainer(S2Container container) {
        this.container = container;
        this.argDefSupport.setContainer(container);
        this.metaDefSupport.setContainer(container);
        this.propertyDefSupport.setContainer(container);
        this.initMethodDefSupport.setContainer(container);
        this.destroyMethodDefSupport.setContainer(container);
        this.aspectDefSupport.setContainer(container);
        this.interTypeDefSupport.setContainer(container);
    }

    public void addArgDef(ArgDef argDef) {
        this.argDefSupport.addArgDef(argDef);
    }

    public void addPropertyDef(PropertyDef propertyDef) {
        this.propertyDefSupport.addPropertyDef(propertyDef);
    }

    public void addInitMethodDef(InitMethodDef methodDef) {
        this.initMethodDefSupport.addInitMethodDef(methodDef);
    }

    public void addDestroyMethodDef(DestroyMethodDef methodDef) {
        this.destroyMethodDefSupport.addDestroyMethodDef(methodDef);
    }

    public synchronized void addAspectDef(AspectDef aspectDef) {
        this.aspectDefSupport.addAspectDef(aspectDef);
        this.concreteClass = null;
    }

    public synchronized void addAspectDef(int index, AspectDef aspectDef) {
        this.aspectDefSupport.addAspectDef(index, aspectDef);
        this.concreteClass = null;
    }

    public void addInterTypeDef(InterTypeDef interTypeDef) {
        this.interTypeDefSupport.addInterTypeDef(interTypeDef);
        this.concreteClass = null;
    }

    public int getArgDefSize() {
        return this.argDefSupport.getArgDefSize();
    }

    public int getPropertyDefSize() {
        return this.propertyDefSupport.getPropertyDefSize();
    }

    public int getInitMethodDefSize() {
        return this.initMethodDefSupport.getInitMethodDefSize();
    }

    public int getDestroyMethodDefSize() {
        return this.destroyMethodDefSupport.getDestroyMethodDefSize();
    }

    public int getAspectDefSize() {
        return this.aspectDefSupport.getAspectDefSize();
    }

    public int getInterTypeDefSize() {
        return this.interTypeDefSupport.getInterTypeDefSize();
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public void init() {
        this.getConcreteClass();
        this.getComponentDeployer().init();
    }

    public void destroy() {
        this.getComponentDeployer().destroy();
        this.componentClass = null;
        this.componentName = null;
        this.concreteClass = null;
        this.container = null;
        this.expression = null;
        this.argDefSupport = null;
        this.propertyDefSupport = null;
        this.initMethodDefSupport = null;
        this.destroyMethodDefSupport = null;
        this.aspectDefSupport = null;
        this.interTypeDefSupport = null;
        this.metaDefSupport = null;
        this.instanceDef = null;
        this.autoBindingDef = null;
        this.componentDeployer = null;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ArgDef getArgDef(int index) {
        return this.argDefSupport.getArgDef(index);
    }

    public PropertyDef getPropertyDef(int index) {
        return this.propertyDefSupport.getPropertyDef(index);
    }

    public PropertyDef getPropertyDef(String propertyName) {
        if (this.hasPropertyDef(propertyName)) {
            return this.propertyDefSupport.getPropertyDef(propertyName);
        }
        throw new PropertyNotFoundRuntimeException(this.componentClass, propertyName);
    }

    public boolean hasPropertyDef(String propertyName) {
        return this.propertyDefSupport.hasPropertyDef(propertyName);
    }

    public InitMethodDef getInitMethodDef(int index) {
        return this.initMethodDefSupport.getInitMethodDef(index);
    }

    public DestroyMethodDef getDestroyMethodDef(int index) {
        return this.destroyMethodDefSupport.getDestroyMethodDef(index);
    }

    public AspectDef getAspectDef(int index) {
        return this.aspectDefSupport.getAspectDef(index);
    }

    public InterTypeDef getInterTypeDef(int index) {
        return this.interTypeDefSupport.getInterTypeDef(index);
    }

    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }

    public synchronized ComponentDeployer getComponentDeployer() {
        if (this.componentDeployer == null) {
            this.componentDeployer = this.instanceDef.createComponentDeployer(this);
        }
        return this.componentDeployer;
    }

    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }
}

