package org.arefgard.icerya.flow.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.arefgard.icerya.flow.exception.IllegalVariableException;
import org.arefgard.icerya.flow.exception.UsecaseFlowException;
import org.arefgard.icerya.flow.node.Flow;
import org.arefgard.icerya.flow.node.ReceiveNode;
import org.arefgard.icerya.flow.node.ReplyNode;

/**
 * [XP[Xt[B
 * <br/><br/>
 * [XP[XÎ҂Čʂ𓾂u[XP[Xt[v
 * [XP[XÎ҂ɁA㌋ʂ𓾂u񓯊[XP[Xt[v
 * T|[gB<br/>
 * 쐬[XP[Xt[̏ԂrIAŌʂm΂悢ꍇ
 * u񓯊[XP[Xt[vgpBʂ悤ȏꍇɂ́Au
 * [Xt[gpB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class UsecaseFlow {
	
	/** [XP[Xt[̃C **/
	private static final String MAIN_FLOW = "_main";
	
	/** [XP[Xt[`t@C̃pX(NXpX) */
	private String path;
	/** p[XP[X̃pX(NXpX) */
	private String superUsecase;
	
	/** ϐێ`}bv */
	private Map<String, String> variables = new java.util.HashMap<String, String>();
	/** V[PXێ}bv */
	private Map<String, Flow> flows = new java.util.HashMap<String, Flow>();

	/** O */
	private Exception throwable = null;
	
	private boolean finished = false;
	
	/**
	 * O擾B
	 * 
	 * @return [XP[Xt[ŔO
	 */
	public Exception getTrowable() {
		return this.throwable;
	}
	
	/**
	 * Oݒ肷B
	 * 
	 * @param throwable [XP[Xt[ŔO
	 */
	public void setThrowable(Exception throwable) {
		this.throwable = throwable;
	}
	
	public String getContainerPath() {
		return this.path;
	}
	
	void setContainerPath(String path) {
		this.path = path;
	}
	
	String getSuperUsecase() {
		return this.superUsecase;
	}
	
	void setSuperUsecase(String superUsecase) {
		this.superUsecase = superUsecase;
	}
	
	void addVar(String name, String className) {
		this.variables.put(name, className);
	}
	
	String getVar(String name) {
		return this.variables.get(name);
	}
	
	public void addFlow(String name, Flow flow) {
		this.flows.put(name, flow);
	}
	
	public Flow getFlow(String name) {
		return this.flows.get(name);
	}

	/**
	 * ͒lǉB
	 * 
	 * @param name
	 * @param obj
	 * @throws UsecaseFlowException
	 */
	public void addInput(String name, Object obj) throws UsecaseFlowException {
		ReceiveNode node = (ReceiveNode)this.flows.get(MAIN_FLOW).getStartNode();
		if(node.containsProperty(name)) {
			this.flows.get(MAIN_FLOW).addInput(name, obj);
		}else {
			throw new IllegalVariableException(name + "is illeagal input.");
		}
	}
	
	/**
	 * ͒l}bvݒ肷B
	 * 
	 * @param inputs
	 * @throws UsecaseFlowException
	 */
	public void setInputs(Map<String, Object> inputs) throws UsecaseFlowException {
		Set<String> keys = this.flows.get(MAIN_FLOW).getInputs().keySet();
		for(Iterator<String> itr = keys.iterator(); itr.hasNext();) {
			String key = itr.next();
			if(!this.flows.get(MAIN_FLOW).getInputs().containsKey(key)) {
				  throw new IllegalVariableException(key + " is illeagal input.");
			}
		}
		this.flows.get(MAIN_FLOW).setInputs(inputs);
	}
	
	/**
	 * 
	 * @param name
	 * @return
	 */
	public Object getOutput(String name) throws UsecaseFlowException {
		ReplyNode node = (ReplyNode)this.flows.get(MAIN_FLOW).getEndNode();
		if(node.containsProperty(name)) {
			return this.flows.get(MAIN_FLOW).getOutputs().get(name);
		}else {
			throw new IllegalVariableException(name + " is illeagal output.");
		}
	}
	
	/**
	 * 
	 * @return
	 * @throws UsecaseFlowException
	 */
	public Map<String, Object> getOutputs() throws UsecaseFlowException {
		return this.flows.get(MAIN_FLOW).getOutputs();
	}
	
	
	/**
	 * [XP[Xt[񓯊sB
	 * 
	 * @throws UsecaseFlowException [XP[Xt[̎sɎsꍇ
	 * @throws Exception throwm[hOthrowꍇ
	 */
	public void executeAsync() throws UsecaseFlowException, Exception {
		Flow flow = this.getFlow(MAIN_FLOW);
		Thread thread = new Thread(flow);
		thread.start();
	}
	
	/**
	 * [XP[Xt[𓯊sB
	 * 
	 * @return ߂l
	 * @throws UsecaseFlowException
	 * @throws Exception
	 */
	public Map<String, Object> executeSync() throws UsecaseFlowException, Exception {
		Flow flow = this.getFlow(MAIN_FLOW);
		flow.execute();
		if(this.throwable != null) {
			throw this.throwable;
		}
		return this.flows.get(MAIN_FLOW).getOutputs();
	}
	
	/**
	 * o̓IuWFNgNAB
	 * <br/>
	 * <br/>
	 * [XP[Xt[ėpꍇ́Ã\bhĂяoƂŃp[X̏Ԃ
	 * ߂B
	 */
	public void clear() {
		this.flows.get(MAIN_FLOW).clear();
	}

	public boolean isFinished() {
		return finished;
	}
	
	public void setFinished(boolean finished) {
		this.finished = finished;
	}
}
