/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import org.apache.oro.text.perl.Perl5Util;
import org.arefgard.icerya.aop.AdviceDef;
import org.arefgard.icerya.aop.AspectException;
import org.arefgard.icerya.aop.annotation.AfterAdvice;
import org.arefgard.icerya.aop.annotation.BeforeAdvice;
import org.arefgard.icerya.aop.annotation.DelegateAdvice;
import org.arefgard.icerya.aop.annotation.ThrowAdvice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectProxyFactory {
    private static final String FIELD_NAME = "_interceptorobject";
    private Class targetClass;
    Map<List<String>, Object> interceptors;
    Map<CtMethod, List<Method>> interceptMethods = new HashMap<CtMethod, List<Method>>();
    private Map<String, List<AdviceDef>> beforeAdvices = new HashMap<String, List<AdviceDef>>();
    private Map<String, List<AdviceDef>> afterAdvices = new HashMap<String, List<AdviceDef>>();
    private Map<String, List<AdviceDef>> throwAdvices = new HashMap<String, List<AdviceDef>>();
    private Map<String, List<AdviceDef>> delegateAdvices = new HashMap<String, List<AdviceDef>>();

    public AspectProxyFactory(Class targetClass) {
        this.interceptors = new HashMap<List<String>, Object>();
        this.targetClass = targetClass;
    }

    public void addInterceptor(List<String> patterns, Object interceptor) {
        this.interceptors.put(patterns, interceptor);
    }

    public Class getProxy() throws AspectException {
        Class proxyClass = null;
        ClassPool pool = ClassPool.getDefault();
        try {
            int n;
            int n2;
            CtMethod[] ctMethodArray;
            CtClass targetCtClass = pool.get(this.targetClass.getName());
            String targetPackageName = String.valueOf(targetCtClass.getPackageName()) + ".proxy.";
            String targetClassName = String.valueOf(targetCtClass.getSimpleName()) + "Proxy";
            CtClass ctClass = pool.makeClass(String.valueOf(targetPackageName) + targetClassName, targetCtClass);
            CtMethod[] ctMethods = targetCtClass.getDeclaredMethods();
            for (List<String> patterns : this.interceptors.keySet()) {
                Object interceptor = this.interceptors.get(patterns);
                ctMethodArray = ctMethods;
                n2 = ctMethods.length;
                n = 0;
                while (n < n2) {
                    CtMethod ctMethod = ctMethodArray[n];
                    if (this.match(patterns, ctMethod.getName())) {
                        Method[] methods;
                        Method[] methodArray = methods = interceptor.getClass().getDeclaredMethods();
                        int n3 = methods.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DelegateAdvice delegateAdvice;
                            ThrowAdvice throwAdvice;
                            AfterAdvice after;
                            int n5;
                            Method method = methodArray[n4];
                            BeforeAdvice before = method.getAnnotation(BeforeAdvice.class);
                            if (before != null) {
                                List<AdviceDef> list = null;
                                AdviceDef advice = new AdviceDef();
                                advice.setClassName(interceptor.getClass().getSimpleName());
                                advice.setMethodName(method.getName());
                                Class<?>[] argClasses = method.getParameterTypes();
                                String[] argStrs = new String[argClasses.length];
                                int i = 0;
                                while (i < argClasses.length) {
                                    argStrs[i] = argClasses[i].getName();
                                    ++i;
                                }
                                advice.setArgs(argStrs);
                                list = this.beforeAdvices.containsKey(ctMethod) ? this.beforeAdvices.get(ctMethod) : new ArrayList<AdviceDef>();
                                list.add(advice);
                                StringBuffer key = new StringBuffer();
                                key.append(ctMethod.getName());
                                CtClass[] ctClassArray = ctMethod.getParameterTypes();
                                n5 = ctClassArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    CtClass cls = ctClassArray[n6];
                                    key.append(cls.getName());
                                    ++n6;
                                }
                                this.beforeAdvices.put(key.toString(), list);
                            }
                            if ((after = method.getAnnotation(AfterAdvice.class)) != null) {
                                List<AdviceDef> list = null;
                                AdviceDef advice = new AdviceDef();
                                advice.setClassName(interceptor.getClass().getSimpleName());
                                advice.setMethodName(method.getName());
                                Class<?>[] argClasses = method.getParameterTypes();
                                String[] argStrs = new String[argClasses.length];
                                int i = 0;
                                while (i < argClasses.length) {
                                    argStrs[i] = argClasses[i].getName();
                                    ++i;
                                }
                                advice.setArgs(argStrs);
                                list = this.afterAdvices.containsKey(ctMethod) ? this.afterAdvices.get(ctMethod) : new ArrayList<AdviceDef>();
                                list.add(advice);
                                StringBuffer key = new StringBuffer();
                                key.append(ctMethod.getName());
                                CtClass[] ctClassArray = ctMethod.getParameterTypes();
                                int n7 = ctClassArray.length;
                                n5 = 0;
                                while (n5 < n7) {
                                    CtClass cls = ctClassArray[n5];
                                    key.append(cls.getName());
                                    ++n5;
                                }
                                this.afterAdvices.put(key.toString(), list);
                            }
                            if ((throwAdvice = method.getAnnotation(ThrowAdvice.class)) != null) {
                                List<Object> list = null;
                                AdviceDef advice = new AdviceDef();
                                advice.setClassName(interceptor.getClass().getSimpleName());
                                advice.setMethodName(method.getName());
                                Class<?>[] argClasses = method.getParameterTypes();
                                String[] argStrs = new String[argClasses.length];
                                int i = 0;
                                while (i < argClasses.length) {
                                    argStrs[i] = argClasses[i].getName();
                                    ++i;
                                }
                                advice.setArgs(argStrs);
                                list = this.throwAdvices.containsKey(ctMethod) ? this.throwAdvices.get(ctMethod) : new ArrayList();
                                advice.setValues(throwAdvice.value());
                                list.add(advice);
                                StringBuffer key = new StringBuffer();
                                key.append(ctMethod.getName());
                                CtClass[] ctClassArray = ctMethod.getParameterTypes();
                                int n8 = ctClassArray.length;
                                int n9 = 0;
                                while (n9 < n8) {
                                    CtClass cls = ctClassArray[n9];
                                    key.append(cls.getName());
                                    ++n9;
                                }
                                this.throwAdvices.put(key.toString(), list);
                            }
                            if ((delegateAdvice = method.getAnnotation(DelegateAdvice.class)) != null) {
                                List<AdviceDef> list = null;
                                AdviceDef advice = new AdviceDef();
                                advice.setClassName(interceptor.getClass().getSimpleName());
                                advice.setMethodName(method.getName());
                                Class<?>[] argClasses = method.getParameterTypes();
                                String[] argStrs = new String[argClasses.length];
                                int i = 0;
                                while (i < argClasses.length) {
                                    argStrs[i] = argClasses[i].getName();
                                    ++i;
                                }
                                advice.setArgs(argStrs);
                                list = this.delegateAdvices.containsKey(ctMethod) ? this.delegateAdvices.get(ctMethod) : new ArrayList<AdviceDef>();
                                list.add(advice);
                                StringBuffer key = new StringBuffer();
                                key.append(ctMethod.getName());
                                CtClass[] ctClassArray = ctMethod.getParameterTypes();
                                int n10 = ctClassArray.length;
                                int n11 = 0;
                                while (n11 < n10) {
                                    CtClass cls = ctClassArray[n11];
                                    key.append(cls.getName());
                                    ++n11;
                                }
                                this.delegateAdvices.put(key.toString(), list);
                            }
                            ++n4;
                        }
                        this.put(ctMethod, interceptor);
                    }
                    ++n;
                }
            }
            for (Object interceptor : this.interceptors.values()) {
                CtField field = CtField.make((String)(String.valueOf(interceptor.getClass().getName()) + " " + FIELD_NAME + interceptor.getClass().getSimpleName() + " = new " + interceptor.getClass().getName() + "();"), (CtClass)ctClass);
                ctClass.addField(field);
            }
            for (CtMethod method : this.interceptMethods.keySet()) {
                StringBuffer key = new StringBuffer();
                key.append(method.getName());
                ctMethodArray = method.getParameterTypes();
                n2 = ctMethodArray.length;
                n = 0;
                while (n < n2) {
                    CtMethod cls = ctMethodArray[n];
                    key.append(cls.getName());
                    ++n;
                }
                CtMethod newMethod = this.createCtMethod(ctClass, method, this.beforeAdvices.get(key.toString()), this.afterAdvices.get(key.toString()), this.throwAdvices.get(key.toString()), this.delegateAdvices.get(key.toString()));
                ctClass.addMethod(newMethod);
            }
            proxyClass = ctClass.toClass();
            return proxyClass;
        }
        catch (Exception e) {
            throw new AspectException(e);
        }
    }

    private CtMethod createCtMethod(CtClass ctClass, CtMethod ctMethod, List<AdviceDef> beforeAdvices, List<AdviceDef> afterAdvices, List<AdviceDef> throwAdvices, List<AdviceDef> delegateAdvices) throws Exception {
        int i;
        String[] methodArgs;
        StringBuffer buf = new StringBuffer();
        buf.append(Modifier.toString((int)ctMethod.getModifiers()));
        buf.append(" ");
        buf.append(ctMethod.getReturnType().getName());
        buf.append(" ");
        buf.append(ctMethod.getName());
        buf.append("(");
        CtClass[] args = ctMethod.getParameterTypes();
        int length = args.length;
        int i2 = 0;
        while (i2 < length) {
            buf.append(args[i2].getName());
            buf.append(" ");
            buf.append("arg" + i2);
            if (i2 != length - 1) {
                buf.append(",");
            }
            ++i2;
        }
        buf.append(") {");
        if (afterAdvices != null && afterAdvices.size() != 0 || throwAdvices != null && throwAdvices.size() != 0) {
            buf.append("try {");
        }
        for (AdviceDef method : beforeAdvices) {
            buf.append("this._interceptorobject" + method.getClassName() + "." + method.getMethodName());
            buf.append("(");
            methodArgs = method.getArgs();
            i = 0;
            while (i < methodArgs.length) {
                buf.append(methodArgs[i]);
                buf.append(" ");
                buf.append("arg" + i);
                if (i != length - 1) {
                    buf.append(",");
                }
                ++i;
            }
            buf.append(");");
        }
        if (delegateAdvices != null && delegateAdvices.size() != 0) {
            AdviceDef method = delegateAdvices.get(0);
            if (!ctMethod.getReturnType().getName().equals("void")) {
                buf.append("return ");
            }
            buf.append("this._interceptorobject" + method.getClassName() + "." + method.getMethodName());
            buf.append(ctMethod.getName());
            buf.append("(");
            int i3 = 0;
            while (i3 < length) {
                buf.append("arg" + i3);
                if (i3 != length - 1) {
                    buf.append(",");
                }
                ++i3;
            }
            buf.append(");");
        } else {
            if (!ctMethod.getReturnType().getName().equals("void")) {
                buf.append("return ");
            }
            buf.append("super.");
            buf.append(ctMethod.getName());
            buf.append("(");
            i = 0;
            while (i < length) {
                buf.append("arg" + i);
                if (i != length - 1) {
                    buf.append(",");
                }
                ++i;
            }
            buf.append(");");
        }
        if (afterAdvices != null && afterAdvices.size() != 0 || throwAdvices != null && throwAdvices.size() != 0) {
            buf.append("}");
        }
        if (throwAdvices != null) {
            for (AdviceDef method : throwAdvices) {
                String[] stringArray = method.getValues();
                int n = stringArray.length;
                i = 0;
                while (i < n) {
                    String ex = stringArray[i];
                    buf.append("catch(");
                    buf.append(ex);
                    buf.append(" e){");
                    buf.append("this._interceptorobject" + method.getClassName() + "." + method.getMethodName());
                    buf.append("(e);");
                    buf.append("}");
                    ++i;
                }
            }
        }
        if (afterAdvices != null && afterAdvices.size() != 0) {
            buf.append("finally {");
        }
        if (afterAdvices != null) {
            for (AdviceDef method : afterAdvices) {
                buf.append("this._interceptorobject" + method.getClassName() + "." + method.getMethodName());
                buf.append("(");
                methodArgs = method.getArgs();
                i = 0;
                while (i < methodArgs.length) {
                    buf.append(methodArgs[i]);
                    buf.append(" ");
                    buf.append("arg" + i);
                    if (i != length - 1) {
                        buf.append(",");
                    }
                    ++i;
                }
                buf.append(");");
            }
        }
        if (afterAdvices != null && afterAdvices.size() != 0) {
            buf.append("}");
        }
        buf.append("}");
        return CtMethod.make((String)buf.toString(), (CtClass)ctClass);
    }

    private boolean match(List<String> patterns, String name) {
        Perl5Util perl = new Perl5Util();
        for (String pattern : patterns) {
            if (!perl.match("/" + pattern + "/", name)) continue;
            return true;
        }
        return false;
    }

    private void put(CtMethod method, Object obj) {
        List<Object> list = null;
        list = this.interceptMethods.containsKey(method) ? this.interceptMethods.get(method) : new ArrayList<Object>();
        list.add(obj);
        this.interceptMethods.put(method, list);
    }
}

