/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.parse;

import java.util.List;
import java.util.Map;
import org.arefgard.icerya.container.ContainerFactory;
import org.arefgard.icerya.container.IceryaContainer;
import org.arefgard.icerya.container.cache.impl.NoneCacheStrategy;
import org.arefgard.icerya.container.cache.impl.SingletonCacheStrategy;
import org.arefgard.icerya.container.def.AspectDef;
import org.arefgard.icerya.container.def.BeanDef;
import org.arefgard.icerya.container.def.BeanResourceDef;
import org.arefgard.icerya.container.def.ConstructorArgDef;
import org.arefgard.icerya.container.def.ElementDef;
import org.arefgard.icerya.container.def.EntryDef;
import org.arefgard.icerya.container.def.PropertyDef;
import org.arefgard.icerya.container.def.ReferenceResourceDef;
import org.arefgard.icerya.container.def.ValueResourceDef;
import org.arefgard.icerya.container.injection.impl.ConstructorInjectionStrategy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BeanHandler
implements ContentHandler {
    private static final String NODE_CONTAINER = "container";
    private static final String NODE_META_DEFINITION = "meta-definition";
    private static final String NODE_ATTRIBUTE = "attribute";
    private static final String NODE_BEAN = "bean";
    private static final String NODE_PROPERTY = "property";
    private static final String NODE_CONSTRUCTOR_ARG = "constructor-arg";
    private static final String NODE_INCLUDE = "include";
    private static final String NODE_ELEMENT = "element";
    private static final String NODE_ENTRY = "entry";
    private static final String NODE_ASPECT = "aspect";
    private static final String ATTR_CONTEXT = "context";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CACHE = "cache";
    private static final String ATTR_INIT_METHOD = "init-method";
    private static final String ATTR_DESTROY_METHOD = "destroy-method";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_REF = "ref";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_POINTCUT = "pointcut";
    private static final String ATTR_ADVICE = "advice";
    private String context = null;
    private String nowBean;
    private String nowProperty;
    private BeanResourceDef nowPropertyBean;
    private ElementDef nowElementDef;
    private EntryDef nowEntryDef;
    private int nowConstructorArg = -1;
    private IceryaContainer container;

    public BeanHandler(IceryaContainer container) {
        this.container = container;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.endsWith(NODE_BEAN)) {
            if (this.nowPropertyBean != null) {
                this.nowPropertyBean = null;
            } else {
                this.nowBean = null;
                this.nowConstructorArg = -1;
            }
        } else if (qName.endsWith(NODE_PROPERTY)) {
            this.nowProperty = null;
        } else if (qName.endsWith(NODE_ELEMENT)) {
            BeanDef beanDef = this.container.getBeanDef(this.nowBean);
            beanDef.addElement(this.nowElementDef);
            this.nowElementDef = null;
        } else if (qName.endsWith(NODE_ENTRY)) {
            BeanDef beanDef = this.container.getBeanDef(this.nowBean);
            beanDef.addEntry(this.nowEntryDef);
            this.nowEntryDef = null;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.endsWith(NODE_CONTAINER)) {
            this.processContainerNode(atts);
        } else if (qName.endsWith(NODE_ATTRIBUTE)) {
            this.processMetaDefinitionNode(atts);
        } else if (qName.endsWith(NODE_BEAN)) {
            this.processBeanNode(atts);
        } else if (qName.endsWith(NODE_PROPERTY)) {
            this.processPropertyNode(atts);
        } else if (qName.endsWith(NODE_CONSTRUCTOR_ARG)) {
            this.processConstructorArgNode(atts);
        } else if (qName.endsWith(NODE_INCLUDE)) {
            this.processIncludeNode(atts);
        } else if (qName.endsWith(NODE_ELEMENT)) {
            this.processElementNode(atts);
        } else if (qName.endsWith(NODE_ENTRY)) {
            this.processEntryNode(atts);
        } else if (qName.endsWith(NODE_ASPECT)) {
            this.processAspectNode(atts);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void processContainerNode(Attributes atts) throws SAXException {
        this.context = atts.getValue(ATTR_CONTEXT);
        if (this.context == null || this.context.equals("")) {
            throw new SAXException("context attribute is required.");
        }
        this.container.setContext(this.context);
    }

    private void processMetaDefinitionNode(Attributes atts) {
        this.container.addMetaDefinition(atts.getValue(ATTR_NAME), atts.getValue(ATTR_VALUE));
    }

    private void processBeanNode(Attributes atts) throws SAXException {
        if (this.nowProperty != null) {
            BeanDef beanDef = this.container.getBeanDef(this.nowBean);
            PropertyDef propertyDef = beanDef.getProperty(this.nowProperty);
            this.nowPropertyBean = new BeanResourceDef();
            this.nowPropertyBean.setContainer(this.container);
            String clsStr = atts.getValue(ATTR_CLASS);
            if (clsStr == null || clsStr.equals("")) {
                throw new SAXException("bean tag's class attribute is required.");
            }
            this.nowPropertyBean.setBeanClass(clsStr);
            propertyDef.setResourceDef(this.nowPropertyBean);
        } else if (this.nowElementDef != null) {
            this.nowPropertyBean = new BeanResourceDef();
            this.nowPropertyBean.setContainer(this.container);
            String clsStr = atts.getValue(ATTR_CLASS);
            if (clsStr == null || clsStr.equals("")) {
                throw new SAXException("bean tag's class attribute is required.");
            }
            this.nowPropertyBean.setBeanClass(clsStr);
            this.nowElementDef.setResourceDef(this.nowPropertyBean);
        } else if (this.nowEntryDef != null) {
            this.nowPropertyBean = new BeanResourceDef();
            this.nowPropertyBean.setContainer(this.container);
            String clsStr = atts.getValue(ATTR_CLASS);
            if (clsStr == null || clsStr.equals("")) {
                throw new SAXException("bean tag's class attribute is required.");
            }
            this.nowPropertyBean.setBeanClass(clsStr);
            this.nowEntryDef.setResourceDef(this.nowPropertyBean);
        } else {
            BeanDef beanDef = new BeanDef();
            String id = atts.getValue(ATTR_ID);
            if (id == null || id.equals("")) {
                throw new SAXException("bean tag's id attribute is required.");
            }
            if (this.container.containsBean(id)) {
                throw new SAXException("bean tag's id attribute is duplicated.");
            }
            beanDef.setBeanId(id);
            String clsStr = atts.getValue(ATTR_CLASS);
            if (clsStr == null || clsStr.equals("")) {
                throw new SAXException("bean tag's class attribute is required.");
            }
            beanDef.setBeanClass(clsStr);
            String cacheStr = atts.getValue(ATTR_CACHE);
            if (cacheStr == null || cacheStr.equals("") || cacheStr.equals("none")) {
                beanDef.setCacheStrategy(new NoneCacheStrategy());
            } else if (cacheStr.equals("singleton")) {
                beanDef.setCacheStrategy(new SingletonCacheStrategy());
                String initMethod = atts.getValue(ATTR_INIT_METHOD);
                beanDef.setInitMethod(initMethod);
                String destroyMethod = atts.getValue(ATTR_DESTROY_METHOD);
                beanDef.setDestroyMethod(destroyMethod);
            } else {
                throw new SAXException(String.valueOf(cacheStr) + " is not supported.");
            }
            this.nowBean = beanDef.getBeanId();
            this.container.addBeanDef(beanDef);
        }
    }

    private boolean isListObject(Class cls) {
        Class<?>[] ifcs;
        Class<?>[] classArray = ifcs = cls.getInterfaces();
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = classArray[n2];
            if (ifc.equals(List.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isMapObject(Class cls) {
        Class<?>[] ifcs;
        Class<?>[] classArray = ifcs = cls.getInterfaces();
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = classArray[n2];
            if (ifc.equals(Map.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processPropertyNode(Attributes atts) throws SAXException {
        if (this.nowProperty != null && this.nowPropertyBean != null) {
            BeanDef beanDef = this.container.getBeanDef(this.nowBean);
            PropertyDef propDef = beanDef.getProperty(this.nowProperty);
            BeanResourceDef resourceDef = (BeanResourceDef)propDef.getResourceDef();
            String name = atts.getValue(ATTR_NAME);
            if (name == null || name.equals("")) {
                throw new SAXException("property tag's name attribute is required.");
            }
            String value = atts.getValue(ATTR_VALUE);
            PropertyDef propertyDef = new PropertyDef();
            propertyDef.setName(name);
            if (value == null || value.equals("")) {
                String ref = atts.getValue(ATTR_REF);
                propertyDef.setResourceDef(new ReferenceResourceDef(ref));
            } else {
                propertyDef.setResourceDef(new ValueResourceDef(value));
            }
            resourceDef.addProperty(name, propertyDef);
        } else if (this.nowElementDef != null && this.nowPropertyBean != null) {
            BeanResourceDef resourceDef = (BeanResourceDef)this.nowElementDef.getResourceDef();
            String name = atts.getValue(ATTR_NAME);
            if (name == null || name.equals("")) {
                throw new SAXException("property tag's name attribute is required.");
            }
            String value = atts.getValue(ATTR_VALUE);
            PropertyDef propertyDef = new PropertyDef();
            propertyDef.setName(name);
            if (value == null || value.equals("")) {
                String ref = atts.getValue(ATTR_REF);
                propertyDef.setResourceDef(new ReferenceResourceDef(ref));
            } else {
                propertyDef.setResourceDef(new ValueResourceDef(value));
            }
            resourceDef.addProperty(name, propertyDef);
        } else if (this.nowEntryDef != null && this.nowPropertyBean != null) {
            BeanResourceDef resourceDef = (BeanResourceDef)this.nowEntryDef.getResourceDef();
            String name = atts.getValue(ATTR_NAME);
            if (name == null || name.equals("")) {
                throw new SAXException("property tag's name attribute is required.");
            }
            String value = atts.getValue(ATTR_VALUE);
            PropertyDef propertyDef = new PropertyDef();
            propertyDef.setName(name);
            if (value == null || value.equals("")) {
                String ref = atts.getValue(ATTR_REF);
                propertyDef.setResourceDef(new ReferenceResourceDef(ref));
            } else {
                propertyDef.setResourceDef(new ValueResourceDef(value));
            }
            resourceDef.addProperty(name, propertyDef);
        } else {
            String name = atts.getValue(ATTR_NAME);
            if (name == null || name.equals("")) {
                throw new SAXException("property tag's name attribute is required.");
            }
            String value = atts.getValue(ATTR_VALUE);
            BeanDef beanDef = this.container.getBeanDef(this.nowBean);
            PropertyDef propertyDef = new PropertyDef();
            propertyDef.setName(name);
            if (value == null || value.equals("")) {
                String ref = atts.getValue(ATTR_REF);
                propertyDef.setResourceDef(new ReferenceResourceDef(ref));
            } else {
                propertyDef.setResourceDef(new ValueResourceDef(value));
            }
            beanDef.addProperty(name, propertyDef);
            this.nowProperty = name;
        }
    }

    private void processConstructorArgNode(Attributes atts) throws SAXException {
        String value = atts.getValue(ATTR_VALUE);
        String ref = atts.getValue(ATTR_REF);
        String type = atts.getValue(ATTR_TYPE);
        String index = atts.getValue(ATTR_INDEX);
        if ((value == null || value.equals("")) && (ref == null || ref.equals(""))) {
            throw new SAXException("constructor-arg tag's value attribute or ref attribute are required.");
        }
        if (value != null && !value.equals("") && ref != null && !ref.equals("")) {
            throw new SAXException("constructor-arg tag's value attribute or ref attribute are required.");
        }
        if (type == null || value.equals("")) {
            throw new SAXException("constructor-arg tag's type attribute is required.");
        }
        ConstructorArgDef constructorArgDef = new ConstructorArgDef();
        if (value != null && !value.equals("")) {
            constructorArgDef.setResourceDef(new ValueResourceDef(value));
        } else {
            constructorArgDef.setResourceDef(new ReferenceResourceDef(ref));
        }
        try {
            constructorArgDef.setType(Class.forName(type));
        }
        catch (Exception e) {
            throw new SAXException("");
        }
        BeanDef beanDef = this.container.getBeanDef(this.nowBean);
        beanDef.setInjectionStrategy(new ConstructorInjectionStrategy());
        if (index == null || index.equals("")) {
            beanDef.addConstructorArg(constructorArgDef);
        } else {
            beanDef.setConstructorArg(Integer.parseInt(index), constructorArgDef);
        }
    }

    private void processIncludeNode(Attributes atts) throws SAXException {
        String ref = atts.getValue(ATTR_REF);
        if (ref == null || ref.equals("")) {
            throw new SAXException("include tag's ref attribute is required.");
        }
        try {
            IceryaContainer includeContainer = ContainerFactory.create(ref);
            this.container.addContainer(includeContainer);
        }
        catch (Exception e) {
            throw new SAXException("error occurred while parsing " + ref, e);
        }
    }

    private void processElementNode(Attributes atts) throws SAXException {
        String ref;
        String value = atts.getValue(ATTR_VALUE);
        this.nowElementDef = value != null && !value.equals("") ? new ElementDef(new ValueResourceDef(value)) : ((ref = atts.getValue(ATTR_REF)) != null && !ref.equals("") ? new ElementDef(new ReferenceResourceDef(ref)) : new ElementDef());
    }

    private void processEntryNode(Attributes atts) throws SAXException {
        String key = atts.getValue(ATTR_KEY);
        this.nowEntryDef = new EntryDef();
        this.nowEntryDef.setKey(key);
        if (key == null || key.equals("")) {
            throw new SAXException("key attribute is required.");
        }
        String value = atts.getValue(ATTR_VALUE);
        BeanDef beanDef = this.container.getBeanDef(this.nowBean);
        if (value != null && !value.equals("")) {
            this.nowEntryDef.setResourceDef(new ValueResourceDef(value));
            beanDef.addEntry(this.nowEntryDef);
        } else {
            String ref = atts.getValue(ATTR_REF);
            if (ref != null && !ref.equals("")) {
                this.nowEntryDef.setResourceDef(new ReferenceResourceDef(ref));
                beanDef.addEntry(this.nowEntryDef);
            }
        }
    }

    private void processAspectNode(Attributes atts) throws SAXException {
        String pointcut = atts.getValue(ATTR_POINTCUT);
        String advice = atts.getValue(ATTR_ADVICE);
        BeanDef beanDef = this.container.getBeanDef(this.nowBean);
        beanDef.addAspect(new AspectDef(pointcut, advice));
    }
}

