package org.arefgard.icerya.container;

public class ApplicationContext {
	
	private IceryaContainer container = null;
	
	public ApplicationContext(String context) throws ContainerException {
		this.container = ContainerFactory.getContainer(context);
	}
	
	public Object getBean(String id) throws ContainerException {
		return this.container.getBean(id);
	}
	
	public <T> T getBean(String id, Class<T> cls) throws ContainerException {
		return (T)getBean(id);
	}
	
	public void injectDependency(String id, Object obj) throws ContainerException {
		this.container.injectDependency(id, obj);
	}
	
}
