package org.arefgard.icerya.container.def;

import java.util.List;
import java.util.Map;

import org.arefgard.icerya.container.IceryaContainer;
import org.arefgard.icerya.container.cache.CacheStrategy;
import org.arefgard.icerya.container.cache.impl.NoneCacheStrategy;
import org.arefgard.icerya.container.injection.InjectionStrategy;
import org.arefgard.icerya.container.injection.impl.SetterInjectionStrategy;

/**
 * Bean`t@Cp[XʓBean
 * ێGeBeBB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class BeanDef {
	/** Bean ID */
	private String beanId;
	/** BeañNX̊SC */
	private String beanClass;
	/** CX^X쐬Ɏs郁\bh */
	private String initMethod;
	/** DIReiIɎs郁\bh */
	private String destroyMethod;
	/** JNDI */
	private String jndiName;
	
	/** vpeB */
	private Map<String, PropertyDef> properties = new java.util.HashMap<String, PropertyDef>();
	/** RXgN^ */
	private List<ConstructorArgDef> constructorArgs = new java.util.ArrayList<ConstructorArgDef>();
	
	private List<ElementDef> elements = new java.util.ArrayList<ElementDef>();
	
	private List<EntryDef> entries = new java.util.ArrayList<EntryDef>();
	
	private List<AspectDef> aspects = new java.util.ArrayList<AspectDef>();
	
	/** ReLXg(Strinĝ) */
	private String context;
	/** BeanDefǗĂRei̎Q */
	private IceryaContainer container;
	
	/** ListIuWFNgł邩ǂ */
	private boolean listObject = false;
	/** MapIuWFNgł邩ǂ */
	private boolean mapObject = false;
	
	/** LbV헪 */
	private CacheStrategy cache;
	
	/** CWFNV헪 */
	private InjectionStrategy injection;
	
	public BeanDef() {
		this.cache = new NoneCacheStrategy();
		this.injection = new SetterInjectionStrategy();
	}
	
	/**
	 * Bean IDݒ肷B
	 * 
	 * @param beanId Bean ID
	 */
	public void setBeanId(String beanId) {
		this.beanId = beanId;
	}
	
	/**
	 * Bean ID擾B
	 * 
	 * @return Bean ID
	 */
	public String getBeanId() {
		return this.beanId;
	}
	
	/**
	 * BeañNXݒ肷B
	 * 
	 * @param beanClass BeañNX
	 */
	public void setBeanClass(String beanClass) {
		this.beanClass = beanClass;
	}
	
	/**
	 * BeañNX擾B
	 * 
	 * @return BeañNX
	 */
	public String getBeanClass() {
		return beanClass;
	}

	public String getDestroyMethod() {
		return destroyMethod;
	}

	public void setDestroyMethod(String destroyMethod) {
		this.destroyMethod = destroyMethod;
	}

	public String getInitMethod() {
		return initMethod;
	}

	public void setInitMethod(String initMethod) {
		this.initMethod = initMethod;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	/**
	 * vpeBǉB
	 * 
	 * @param name vpeB
	 * @param value l
	 */
	public void addProperty(String name, PropertyDef propertyDef) {
		this.properties.put(name, propertyDef);
	}
	
	/**
	 * vpeB擾B
	 * 
	 * @param name vpeB
	 * @return l
	 */
	public PropertyDef getProperty(String name) {
		return this.properties.get(name);
	}
	
	/**
	 * SvpeB̃}bv擾B
	 * 
	 * @return SvpeB̃}bv
	 */
	public Map<String, PropertyDef> getProperties() {
		return this.properties;
	}
	
	public void addConstructorArg(ConstructorArgDef constructorArgDef) {
		this.constructorArgs.add(constructorArgDef);
	}
	
	public void setConstructorArg(int index, ConstructorArgDef constructorArgDef) {
		this.constructorArgs.add(index, constructorArgDef);
	}
	
	public ConstructorArgDef getConstructorArg(int index) {
		return this.constructorArgs.get(index);
	}
	
	public List<ConstructorArgDef> getConstructorArgs() {
		return this.constructorArgs;
	}
	
	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public IceryaContainer getContainer() {
		return container;
	}

	public void setContainer(IceryaContainer container) {
		this.container = container;
	}

	public CacheStrategy getCacheStrategy() {
		return cache;
	}

	public void setCacheStrategy(CacheStrategy cache) {
		this.cache = cache;
	}

	public InjectionStrategy getInjectionStrategy() {
		return injection;
	}

	public void setInjectionStrategy(InjectionStrategy injection) {
		this.injection = injection;
	}

	public List<ElementDef> getElements() {
		return elements;
	}

	public void setElements(List<ElementDef> elements) {
		this.elements = elements;
	}

	public List<EntryDef> getEntries() {
		return entries;
	}

	public void setEntries(List<EntryDef> entries) {
		this.entries = entries;
	}
	
	public void addElement(ElementDef element) {
		this.elements.add(element);
	}
	
	public void addEntry(EntryDef entry) {
		this.entries.add(entry);
	}

	public boolean isListObject() {
		return listObject;
	}

	public void setListObject(boolean listObject) {
		this.listObject = listObject;
	}

	public boolean isMapObject() {
		return mapObject;
	}

	public void setMapObject(boolean mapObject) {
		this.mapObject = mapObject;
	}

	public List<AspectDef> getAspects() {
		return aspects;
	}

	public void setAspects(List<AspectDef> aspects) {
		this.aspects = aspects;
	}
	
	public void addAspect(AspectDef aspect) {
		this.aspects.add(aspect);
	}
	
	
}
