package org.arefgard.icerya.container.injection;

import org.arefgard.icerya.container.ContainerException;
import org.arefgard.icerya.container.def.BeanDef;

public abstract class InjectionStrategy {
	protected Object injectObject = null;
	
	public void inject(BeanDef beanDef) throws ContainerException {
		if(this.injectObject == null) {
			generate(beanDef);
		}
		injection(beanDef);
	}

	protected abstract void generate(BeanDef beanDef) throws ContainerException;
	
	protected abstract void injection(BeanDef beanDef) throws ContainerException;
	
	public Object getInjectObject() {
		return this.injectObject;
	}

	public void setInjectObject(Object injectObject) {
		this.injectObject = injectObject;
	}
	
	
	
}
