package org.arefgard.icerya.container;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.List;
import java.util.Map;

import org.junit.Test;

public class IceryaContainerTest {
	
	/**
	 * Bean`t@Cp[XāÃIuWFNg𐶐ł
	 * ƂmFB
	 */
	@Test
	public void getSimpleBean() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			String userId = (String)container.getBean("userId");
			assertNotNull(userId);
			assertEquals("", userId);
			
			// WFlbNgĂѕ
			userId = container.getBean("userId", String.class);
			assertNotNull(userId);
			assertEquals("", userId);
			
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			userId = (String)context.getBean("userId");
			assertNotNull(userId);
			assertEquals("", userId);
			
			// WFlbNgĂѕ
			userId = context.getBean("userId", String.class);
			assertNotNull(userId);
			assertEquals("", userId);
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAvpeBݒ肵IuWFNg
	 * ł邱ƂmFB
	 */
	@Test
	public void getBeanWithProperty01() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			TestObject01 obj = (TestObject01)container.getBean("testObject01");
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());
			
			// WFlbNgĂѕ
			obj = container.getBean("testObject01", TestObject01.class);
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			obj = (TestObject01)context.getBean("testObject01");
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());
			
			// WFlbNgĂѕ
			obj = context.getBean("testObject01", TestObject01.class);
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());
			
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAvpeBݒ肵IuWFNg
	 * ł邱ƂmFB
	 * 
	 * C^tF[XĂNX̏ꍇB
	 */
	@Test
	public void getBeanWithProperty02() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			TestObject02 obj = (TestObject02)container.getBean("testObject02");
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
			// WFlbNgĂѕ
			obj = container.getBean("testObject02", TestObject02.class);
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			obj = (TestObject02)context.getBean("testObject02");
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
			// WFlbNgĂѕ
			obj = context.getBean("testObject02", TestObject02.class);
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAvpeBݒ肵IuWFNg
	 * ł邱ƂmFB
	 * 
	 * ۃNXpĂNX̏ꍇB
	 */
	@Test
	public void getBeanWithProperty03() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			TestObject03 obj = (TestObject03)container.getBean("testObject03");
			assertEquals("ABC", obj.getField01());
			assertEquals("DEF", obj.getField02());
			assertEquals("GHI", obj.getField03());
			
			// WFlbNgĂѕ
			obj = container.getBean("testObject03", TestObject03.class);
			assertEquals("ABC", obj.getField01());
			assertEquals("DEF", obj.getField02());
			assertEquals("GHI", obj.getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			obj = (TestObject03)context.getBean("testObject03");
			assertEquals("ABC", obj.getField01());
			assertEquals("DEF", obj.getField02());
			assertEquals("GHI", obj.getField03());
			
			// WFlbNgĂѕ
			obj = context.getBean("testObject03", TestObject03.class);
			assertEquals("ABC", obj.getField01());
			assertEquals("DEF", obj.getField02());
			assertEquals("GHI", obj.getField03());
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAvpeBݒ肵IuWFNg
	 * ł邱ƂmFB
	 * 
	 * WFl[VMbvp^[̏ꍇB
	 */
	@Test
	public void getBeanWithProperty04() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			TestObject04 obj = (TestObject04)container.getBean("testObject04");
			assertEquals("987", obj.getField01());
			assertEquals("654", obj.getField02());
			assertEquals("321", obj.getField03());
			
			// WFlbNgĂѕ
			obj = container.getBean("testObject04", TestObject04.class);
			assertEquals("987", obj.getField01());
			assertEquals("654", obj.getField02());
			assertEquals("321", obj.getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			obj = (TestObject04)context.getBean("testObject04");
			assertEquals("987", obj.getField01());
			assertEquals("654", obj.getField02());
			assertEquals("321", obj.getField03());
			
			// WFlbNgĂѕ
			obj = context.getBean("testObject04", TestObject04.class);
			assertEquals("987", obj.getField01());
			assertEquals("654", obj.getField02());
			assertEquals("321", obj.getField03());
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAvpeBݒ肵IuWFNg
	 * ł邱ƂmFB
	 * 
	 * ̃IuWFNgQƂꍇB
	 */
	@Test
	public void getBeanWithRefProperty() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			TestObject05 obj = (TestObject05)container.getBean("testObject05");
			assertEquals("abc", obj.getField01().getField01());
			assertEquals("def", obj.getField01().getField02());
			assertEquals("ghi", obj.getField01().getField03());
			assertEquals("123", obj.getField02().getField01());
			assertEquals("456", obj.getField02().getField02());
			assertEquals("789", obj.getField02().getField03());
			assertEquals("ABC", obj.getField03().getField01());
			assertEquals("DEF", obj.getField03().getField02());
			assertEquals("GHI", obj.getField03().getField03());
			
			// WFlbNgĂѕ
			obj = container.getBean("testObject05", TestObject05.class);
			assertEquals("abc", obj.getField01().getField01());
			assertEquals("def", obj.getField01().getField02());
			assertEquals("ghi", obj.getField01().getField03());
			assertEquals("123", obj.getField02().getField01());
			assertEquals("456", obj.getField02().getField02());
			assertEquals("789", obj.getField02().getField03());
			assertEquals("ABC", obj.getField03().getField01());
			assertEquals("DEF", obj.getField03().getField02());
			assertEquals("GHI", obj.getField03().getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			obj = (TestObject05)context.getBean("testObject05");
			assertEquals("abc", obj.getField01().getField01());
			assertEquals("def", obj.getField01().getField02());
			assertEquals("ghi", obj.getField01().getField03());
			assertEquals("123", obj.getField02().getField01());
			assertEquals("456", obj.getField02().getField02());
			assertEquals("789", obj.getField02().getField03());
			assertEquals("ABC", obj.getField03().getField01());
			assertEquals("DEF", obj.getField03().getField02());
			assertEquals("GHI", obj.getField03().getField03());
			
			// WFlbNgĂѕ
			obj = context.getBean("testObject05", TestObject05.class);
			assertEquals("abc", obj.getField01().getField01());
			assertEquals("def", obj.getField01().getField02());
			assertEquals("ghi", obj.getField01().getField03());
			assertEquals("123", obj.getField02().getField01());
			assertEquals("456", obj.getField02().getField02());
			assertEquals("789", obj.getField02().getField03());
			assertEquals("ABC", obj.getField03().getField01());
			assertEquals("DEF", obj.getField03().getField02());
			assertEquals("GHI", obj.getField03().getField03());
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAXgIuWFNg𐶐ł邱Ƃ
	 * mFB
	 */
	@Test
	public void getList01() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			List list = (List)container.getBean("list1");
			assertNotNull(list);
			assertEquals("value1", list.get(0));
			assertEquals("value2", list.get(1));
			assertEquals(true, list.get(2) instanceof TestObject01);
			assertEquals(true, list.get(3) instanceof TestObject05);
			assertEquals(true, list.get(4) instanceof TestObject01);
			assertEquals(true, list.get(5) instanceof TestObject05);
			
			// WFlbNgĂѕ
			list = container.getBean("list1", List.class);
			assertNotNull(list);
			assertEquals("value1", list.get(0));
			assertEquals("value2", list.get(1));
			assertEquals(true, list.get(2) instanceof TestObject01);
			assertEquals(true, list.get(3) instanceof TestObject05);
			assertEquals(true, list.get(4) instanceof TestObject01);
			assertEquals(true, list.get(5) instanceof TestObject05);
			
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			list = (List)context.getBean("list1");
			assertNotNull(list);
			assertEquals("value1", list.get(0));
			assertEquals("value2", list.get(1));
			assertEquals(true, list.get(2) instanceof TestObject01);
			assertEquals(true, list.get(3) instanceof TestObject05);
			assertEquals(true, list.get(4) instanceof TestObject01);
			assertEquals(true, list.get(5) instanceof TestObject05);
			
			// WFlbNgĂѕ
			list = context.getBean("list1", List.class);
			assertNotNull(list);
			assertEquals("value1", list.get(0));
			assertEquals("value2", list.get(1));
			assertEquals(true, list.get(2) instanceof TestObject01);
			assertEquals(true, list.get(3) instanceof TestObject05);
			assertEquals(true, list.get(4) instanceof TestObject01);
			assertEquals(true, list.get(5) instanceof TestObject05);
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāA}bvIuWFNg𐶐ł邱Ƃ
	 * mFB
	 */
	@Test
	public void getMap01() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			// ]̌Ăѕ
			Map map = (Map)container.getBean("map1");
			assertNotNull(map);
			assertEquals("value1", map.get("key1"));
			assertEquals("value2", map.get("key2"));
			assertEquals(true, map.get("key3") instanceof TestObject01);
			assertEquals(true, map.get("key4") instanceof TestObject05);
			assertEquals(true, map.get("key5") instanceof TestObject01);
			assertEquals(true, map.get("key6") instanceof TestObject05);
			
			// WFlbNgĂѕ
			map = container.getBean("map1", Map.class);
			assertNotNull(map);
			assertEquals("value1", map.get("key1"));
			assertEquals("value2", map.get("key2"));
			assertEquals(true, map.get("key3") instanceof TestObject01);
			assertEquals(true, map.get("key4") instanceof TestObject05);
			assertEquals(true, map.get("key5") instanceof TestObject01);
			assertEquals(true, map.get("key6") instanceof TestObject05);
			
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			// ]̌Ăѕ
			map = (Map)context.getBean("map1");
			assertNotNull(map);
			assertEquals("value1", map.get("key1"));
			assertEquals("value2", map.get("key2"));
			assertEquals(true, map.get("key3") instanceof TestObject01);
			assertEquals(true, map.get("key4") instanceof TestObject05);
			assertEquals(true, map.get("key5") instanceof TestObject01);
			assertEquals(true, map.get("key6") instanceof TestObject05);
			
			// WFlbNgĂѕ
			map = context.getBean("map1", Map.class);
			assertNotNull(map);
			assertEquals("value1", map.get("key1"));
			assertEquals("value2", map.get("key2"));
			assertEquals(true, map.get("key3") instanceof TestObject01);
			assertEquals(true, map.get("key4") instanceof TestObject05);
			assertEquals(true, map.get("key5") instanceof TestObject01);
			assertEquals(true, map.get("key6") instanceof TestObject05);
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAAE^[CWFNVł邱Ƃ
	 * mFB
	 */
	@Test
	public void outerInjection() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			TestObject01 obj = new TestObject01();
			
			container.injectDependency("testObject01", obj);
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());
			
			// ApplicationContext𗘗p
			ApplicationContext context = new ApplicationContext("sample");
			
			obj = new TestObject01();
			
			context.injectDependency("testObject01", obj);
			assertEquals("abc", obj.getField01());
			assertEquals("def", obj.getField02());
			assertEquals("ghi", obj.getField03());	
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAAE^[CWFNVł邱Ƃ
	 * mFB
	 */
	@Test
	public void constructorArg() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			TestObject06 obj = (TestObject06)container.getBean("testObject06");
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	/**
	 * Bean`t@Cp[XāAAOPp\ȂƂmFB
	 */
	@Test
	public void aopInjection() {
		try {
			// IceryaContainer𒼐ڎgp
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			
			TestObject07 obj = (TestObject07)container.getBean("testObject07");
			assertEquals("123", obj.getField01());
			assertEquals("456", obj.getField02());
			assertEquals("789", obj.getField03());
			
		}catch(ContainerException e) {
			fail("error occurred." + e);
		}
	}
	
	
	
//	@Test
//	public void getBeanUsingInitMethodAndDestroyMethod() {
//		try {
//			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container05.xml");
//			Object01 obj = (Object01)container.getBean("obj01");
//			assertEquals("INIT", obj.getField01());
//		}catch(ContainerException e) {
//			e.printStackTrace();
//			fail("" + e);
//		}
//	}
//	
//	@Test
//	public void getBeanInIncludedContainer() {
//		try {
//			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container05.xml");
//			Object02 obj = (Object02)container.getBean("obj02");
//			assertEquals("hoge", obj.getField01());
//		}catch(ContainerException e) {
//			e.printStackTrace();
//			fail("" + e);
//		}
//	}
//	/*
//	@Test
//	public void getBeanUsingEJBInjection() {
//		try {
//			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container06.xml");
//			HelloStateless hello = (HelloStateless)container.getBean("hello");
//			assertEquals("Hello hoge!", hello.sayHello("hoge"));
//		}catch(Exception e) {
//			
//		}
//	}
//	*/
	
	/**
	 * IDnullw肵ꍇɁAO邱ƂmFB
	 */
	@Test
	public void setNullID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			container.getBean(null);
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("unexpected exception occurred." + e);
		}
	}
	
	/**
	 * IDɋ󕶎w肵ꍇɁAO邱ƂmFB
	 */
	@Test
	public void setEmptyID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			container.getBean("");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("unexpected exception occurred." + e);
		}
	}
	
	/**
	 * IDɑ݂ȂIDw肵ꍇɁAO邱ƂmFB
	 */
	@Test
	public void setNotExistsID() {
		try {
			IceryaContainer container = ContainerFactory.create("org/arefgard/icerya/container/container.xml");
			container.getBean("hoge");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("unexpected exception occurred." + e);
		}
	}
	
	/**
	 * ݂ȂpXw肵ꍇɁAO邱ƂmFB
	 */
	@Test
	public void setIllegalPath() {
		try {
			IceryaContainer container = ContainerFactory.create("notfound");
			fail("failed.");
		}catch(ContainerException e) {
			assertTrue(true);
			return;
		}catch(Exception e) {
			fail("unexpected exception occurred." + e);
		}
	}
	
}
