/*************************************************************************************************/
/*!
   	@file		Color.h
	@author 	Fanzo
 	@date 		2008/6/5
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"rgb" class 
**************************************************************************************************/
class rgb
{
// variable member
public:
	uint8		padding , r , g , b;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgb()
{
	r	= 255;
	g	= 255;
	b	= 255;
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgb
		(
		uint8	rr , 
		uint8	gg , 
		uint8	bb
		) : r( rr ) , g( gg ) , b( bb )
{
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator==
		(
		const rgb&	obj
		)const
{
	if( r != obj.r )
		return false;
	if( g != obj.g )
		return false;
	if( b != obj.b )
		return false;
	return true;
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator!=
		(
		const rgb&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
};
/**************************************************************************************************
"rgba" class 
**************************************************************************************************/
class rgba
{
// variable member
public:
	uint8	a , r , g , b;

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgba()
{
	r	= 255;
	g	= 255;
	b	= 255;
	a	= 255;
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgba
		(
		uint8	rr , 
		uint8	gg , 
		uint8	bb
		)
{
	 r	= rr;
	 g	= gg;
	 b	= bb;
	 a	= 255;
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgba
		(
		uint8	rr , 
		uint8	gg , 
		uint8	bb , 
		uint8	aa
		)
{
	 r	= rr;
	 g	= gg;
	 b	= bb;
	 a	= aa;
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
rgba
		(
		const rgb&	c
		)
{
	 r	= c.r;
	 g	= c.g;
	 b	= c.b;
	 a	= 255;
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator==
		(
		const rgba&	obj
		)const
{
	if( r != obj.r )
		return false;
	if( g != obj.g )
		return false;
	if( b != obj.b )
		return false;
	if( a != obj.a )
		return false;
	return true;
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator!=
		(
		const rgba&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
//!	MulAlpha
//!	@retval			---
//-------------------------------------------------------------------------------------------------
rgba MulAlpha
		(
		uint8	alpha
		)const
{
	return rgba( r , g , b , ( uint8 )( ( uint32 )a * ( uint32 )alpha / 255 ) );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
