/*************************************************************************************************/
/*!
   	@file		capround.h
	@author 	Fanzo
 	@date 		2008/3/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"PathArc.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"CapRound" class 
**************************************************************************************************/
class CapRound : 
	virtual public object_base , 
	public ICap
{
// query
	query_begin();
	iface_hook( ICap , ICap_IID )
	query_end( object_base );
	
// variable member
private:
	PathSegmentSamplerPaint	m_sampler;
	instance<PathArc>	m_arc_ps;
		
// "ICap" interface functions
public:
//=================================================================================================
//!	insert cap
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* cb_call InsertCap
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		vec , 
		const fvector2&		w0 ,
		const fvector2&		w1 , 
		float				samplescale
		)
{
	if( w0 == w1 )
		return node;
	if( node == 0 )
		return node;

	m_arc_ps->InitializeHalfCircle( w0 , w1 , vec , faffine() );
	node = m_sampler.Sampling( outline , node , (iPathSegment)m_arc_ps , 0.0f , 1.0f , samplescale );
	return node;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
CapRound()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
