/*************************************************************************************************/
/*!
   	@file		TreeView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable

///////////////////////////////////////////////////////////////////////////////////////////////////
// class defined

/**************************************************************************************************
"TreeViewItem" class 
**************************************************************************************************/
function TreeViewItem
		(
		root , 
		handle , 
		cursor
		)
{
	this.m_handle		= handle;
	this.m_cursor		= cursor;
	this.m_root			= root;
	this.m_view			= null;
	this.m_folder		= true;
	this.m_open			= false;
	this.m_children		= new Array( 0 );

	var		m_self		= this;
	var		m_id		= "TreeViewItem_" + CreateUniqueId();
	var		m_tab_num	= 0;
	var		m_treeview	= null;
	
// private functions define
//=================================================================================================
function AppendTD_img
		(
		parent , 
		img_path , 
		cursor
		)
{
	var	td 	= parent.appendChild( document.createElement( "td" ) );
	td.cellSpacing	= 0;
	td.cellPadding	= 0;
	var	img = td.appendChild( document.createElement( "img" ) );
	{
		if( cursor != null )
			img.style.cursor	= cursor;
		img.setAttribute( "src" , img_path );
	}
	return img;
}
//=================================================================================================
function AddItemDOM_items
		(
		parent ,  
		tab_num ,  			//!< [in] タブ数
		treeview 
		)
{
	var	dom	= parent.appendChild( document.createElement( "span" ) );
	dom.setAttribute( "id" , m_id );

	// save params
	m_tab_num	= tab_num;
	m_treeview	= treeview;

	if( m_self.m_root == false )
	{
		// table
		var	table	= dom.appendChild( document.createElement( "table" ) );
		table.cellSpacing	= 0;
		table.cellPadding	= 0;

		// tbody
		var tbody	= table.appendChild( document.createElement( "tbody" ) );
		
		// tr
		var	tr = tbody.appendChild( document.createElement( "tr" ) );
		tr.cellSpacing	= 0;
		tr.cellPadding	= 0;

		// add empty tab
		var	tab_off;
		for( tab_off = 0 ; tab_off < tab_num ; tab_off++ )
		{
			AppendTD_img( tr , m_treeview.m_empty_img , null );
		}
		// add handle
		if( m_self.m_handle == true )
		{
			if( m_self.m_children.length == 0 )
			{
				AppendTD_img( tr , m_treeview.m_empty_img , null );
			}
			else
			{
				var img = AppendTD_img( tr , m_self.m_open == true ? m_treeview.m_open_handle_img : m_treeview.m_close_handle_img , m_self.m_cursor );
				img.onclick = new CallbackAdapt( m_self.OnHandleClick ).exec;
			}
		}
		// add icon
		if( m_self.m_folder == false )
			AppendTD_img( tr , m_treeview.m_file_img , null );
		else
		{
			var	img = AppendTD_img( tr , m_self.m_open == true ? m_treeview.m_open_folder_img : m_treeview.m_close_folder_img , m_self.m_cursor );
			img.onclick = new CallbackAdapt( m_self.OnHandleClick ).exec;
		}
		// add view
		var	td = tr.appendChild( document.createElement( "td" ) );
		td.cellSpacing			= 0;
		td.cellPadding			= 0;
		td.style.paddingLeft	= 3;
		td.style.paddingRight	= 3;
		td.style.whiteSpace		= "nowrap"
		if( m_self.m_view != null )
		{
			td.appendChild( m_self.m_view.CreateDOM() );
		}
	}
	// add child
	if( m_self.m_open == true || m_self.m_root == true )
	{
		var		c_off , c_num = m_self.m_children.length;
		for( c_off = 0 ; c_off < c_num ; c_off++ )
		{
			m_self.m_children[ c_off ].AddItemDOM( dom , m_self.m_root == true ? tab_num : tab_num + 1 , m_treeview );
		}
	}
}
// event functions define
//=================================================================================================
this.OnHandleClick = function
		(
		args
		)
{
	m_self.m_open 	= m_self.m_open == true ? false : true;
	var	dom			= document.getElementById( m_id );
	if( dom == null )
		return;
	RemoveAllChild( dom );
	AddItemDOM_items( dom , m_tab_num , m_treeview ); 
}
// public functions define
//=================================================================================================
this.AddItemDOM = function 
		(
		parent ,
		tab_num ,
		treeview
		)
{
	var	dom	= parent.appendChild( document.createElement( "span" ) );
	dom.setAttribute( "id" , m_id );
	AddItemDOM_items( dom , tab_num , treeview );
}
}
/**************************************************************************************************
"TreeView" class 
**************************************************************************************************/
function TreeView
		(
		open_handle_img , 		//!< [in] ハンドルが開いている画像のパス
		close_handle_img , 		//!< [in] ハンドルが閉じている画像のパス
		open_folder_img , 		//!< [in] フォルダが開いている画像のパス
		close_folder_img , 		//!< [in] フォルダが閉じている画像のパス
		file_img , 				//!< [in] ファイル画像のパス
		empty_img , 			//!< [in] 空画像のパス
		handle , 
		cursor
		)
{
	// public variable
	this.m_open_handle_img		= open_handle_img;
	this.m_close_handle_img		= close_handle_img;
	this.m_open_folder_img		= open_folder_img;
	this.m_close_folder_img		= close_folder_img;
	this.m_file_img				= file_img;
	this.m_empty_img			= empty_img;
	this.m_handle				= handle;
	this.m_cursor				= cursor;
	
	// private variable;	
	var		m_self		= this;
	var 	m_root 		= new TreeViewItem( true , m_self.m_handle , m_self.m_cursor );
	var 	m_id		= "TreeView_" + CreateUniqueId();

// private function define
//=================================================================================================
function SetItem
		(
		tgt_item , 
		src_item
		)
{
	if( src_item.length < 1 )
		return false;

	tgt_item.m_view 	= src_item[ 0 ];
	tgt_item.m_folder	= src_item.length >= 2 ? src_item[ 1 ] : false;
	tgt_item.m_open		= src_item.length >= 3 ? src_item[ 2 ] : false;

	if( src_item.length >= 4 )
	{
		var		c_off , c_num = src_item[ 3 ].length;
		tgt_item.m_children	= new Array( c_num );
		for( c_off = 0 ; c_off < c_num ; c_off++ )
		{
			var	it = new TreeViewItem( false , m_self.m_handle , m_self.m_cursor );
			tgt_item.m_children[ c_off ] = it;
			
			if( src_item[ 3 ][ c_off ] != null )
			{
				if( false == SetItem( it  , src_item[ 3 ][ c_off ] ) )
					return false;
			}
		}
	}
	return true;
}

// public functions define
//=================================================================================================
this.SetTreeItems = function
		(
		itemtree			//!< [in] 設定するアイテムツリー
		)
{
	if( false == SetItem( m_root , itemtree ) )
		return false;
	return true;
}	
//=================================================================================================
this.CreateDOM = function()
{
	var	dom	= document.createElement( "span" );
	dom.setAttribute( "id" , m_id );
	if( m_root == null )
		return dom;
	m_root.AddItemDOM( dom , 0 , m_self );
	return dom;
}
}

