/*************************************************************************************************/
/*!
   	@file		main.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<windows.h>
#include	<math.h>

using namespace icubic;
using namespace shared;


///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define create_item( obj_name , title_obj_name , title , view_height )																								\
	title_obj_name->SetString( title );																																\
	title_obj_name->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( m_es , y ) , isize( p->m_rect.Width() - m_es * 2 , m_ts ) ) );			\
	y += title_obj_name->GetRect().Height();																														\
	obj_name->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( m_es , y ) , isize( p->m_rect.Width() - m_es * 2 , view_height ) ) );		\
	obj_name->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );																						\
	y += obj_name->GetRect().Size().height;

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"Control1View" class 
**************************************************************************************************/
class Control1View : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
public:
	instance<SeparateView>			m_processor_t;
	instance<ProcessorCfgView>		m_processor;

	instance<SeparateView>			m_svgfile_t;
	instance<SVGFileCfgView>		m_svgfile;

private:
	rControlMsg						m_msg;
	int								m_id;
	
	const int						m_es;
	const int						m_ts;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = m_es;
	create_item( m_processor , m_processor_t , L"processor" , 20 );
	create_item( m_svgfile , m_svgfile_t , L"svgfile" , 300 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawConfigBack( (iSurfaceDest)p->m_surface , GetRect().Size() );
}

// public functions
public:
//=================================================================================================
Control1View() : m_id( 0 ) , m_es( 5 ) , m_ts( 11 )
{
}
//=================================================================================================
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
};
/**************************************************************************************************
"MainView" class 
**************************************************************************************************/
class MainView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( Size , OnSize )
	msg_view_map_end( View )

// variable member
private:
	instance<Control1View>			m_control1;
	instance<TimeCfgView>			m_time;
	rgba							m_bc;
	instance<GraphicsCmdsPlayer>	m_player;
	
// msg functions
private:
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
// convert
private:

// msg functions
private:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_time->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 135 , 0 ) , isize( 300 , 16 ) ) );
	m_time->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );

	m_control1->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( p->m_rect.xmax - 130 - 1 , 1 ) , isize( 130 , 400 ) ) );
	m_control1->SetMsgCallback( ( rControlMsg )( reference )this_object() , 100 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	ColorBlt( (iSurfaceDest)p->m_surface , p->m_rect , m_bc , Onezero_BltBlendType );

	iGraphicsCmds	cmds = m_control1->m_svgfile->GetValue();
	if( cmds == false )
		return;

	faffine	vtod	= faffine::GetMove( fvector2( 0.0f , 0.0f ) );
	fsize	view	= fsize( (float)p->m_rect.Width() , (float)p->m_rect.Height() );

	m_time->BeginMeasure();
	m_player->ExecuteCmds( (iSurfaceDest)p->m_surface , vtod , p->m_surface->GetDestDPI() , view , cmds );
	m_time->EndMeasure();
}
//=================================================================================================
void OnSize
		(
		Size_ViewPM*	p
		)
{
	m_control1->Move( irect( ivector2( p->m_rect.xmax - 130 - 1 , 1 ) , isize( 130 , 400 ) ) );
}

// public functions
public:
//=================================================================================================
MainView() : 
		m_bc( 255 , 255 , 255 )
{
}
//=================================================================================================
bool Initialize
		(
		const wstring&	folder
		)
{
	wstring		material;
	if( 0xFFFFFFFF == GetFileAttributesW( ( folder + L"../../../../material" ).c_str() ) )
		material = folder + L"material/";
	else
		material = folder + L"../../../../material/";

	m_control1->m_svgfile->AddSVGFile( material + L"svg_0.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_1.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_2.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_3.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_4.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_5.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_6.svg" , material );
	m_control1->m_svgfile->AddSVGFile( material + L"svg_7.svg" , material );
	return true;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define





