/*************************************************************************************************/
/*!
   	@file		DispOutlineCfgView.h
	@author 	Fanzo
 	@date 		2008/5/30
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"DispOutlineCfgView" class 
**************************************************************************************************/
class DispOutlineCfgView : public CheckCfgView
{
// variable member
private:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
DispOutlineCfgView()
{
	SetCheckNum( 3 );
	SetString( 0 , L"disp sample" );
	SetString( 1 , L"disp outline" );
	SetString( 2 , L"disp handle" );
	SetValue( 1 , false );
}
//=================================================================================================
//!	set sample state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetSampleState
		(
		bool	ck
		)
{
	SetValue( 0 , ck );
}
//=================================================================================================
//!	set outline state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetOutlineState
		(
		bool	ck
		)
{
	SetValue( 1 , ck );
}
//=================================================================================================
//!	set handle state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetHandleState
		(
		bool	ck
		)
{
	SetValue( 2 , ck );
}
//=================================================================================================
//!	get sample state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetSampleState()
{
	return GetValue( 0 );
}
//=================================================================================================
//!	get outline state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetOutlineState()
{
	return GetValue( 1 );
}
//=================================================================================================
//!	get handle state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetHandleState()
{
	return GetValue( 2 );
}
};


/**************************************************************************************************
"DispPolygonCfgView" class 
**************************************************************************************************/
class DispPolygonCfgView : public CheckCfgView
{
// variable member
private:
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
DispPolygonCfgView()
{
	SetCheckNum( 2 );
	SetString( 0 , L"disp polygon" );
	SetString( 1 , L"disp handle" );
	SetValue( 0 , false );
}
//=================================================================================================
//!	get polygon state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetPolygonState()
{
	return GetValue( 0 );
}
//=================================================================================================
//!	get handle state
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool GetHandleState()
{
	return GetValue( 1 );
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace DispOutlineCfgView;		

#pragma pack( pop )			//release align
