/*************************************************************************************************/
/*!
   	@fileaccess		fileaccess.h
	@author 	Fanzo
 	@date 		2008/3/26
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include file
#include	"iFace/iFileAccess.h"
#include	<string>

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace std;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

//=======================================================================
//!	convert Endian
//!	@retval			---
//-----------------------------------------------------------------------
cb_inline
void EndianChange
		(
		void	*pmem ,		//!< [mod] pointer which is point to the data to convert.
		int32	size		//!< [in] data size.
		)
{
	uint8	*ptgt	= ( uint8* )pmem + size - 1;
	uint8	*psrc	= ( uint8* )pmem;
	
	int		off, num = size / 2;
	for( off = 0 ; off < num ; off++ )
	{
		uint8	temp	= *psrc;
		*psrc	= *ptgt;
		*ptgt	= temp;
		
		psrc++;
		ptgt--;
	}
}
//=======================================================================
//!	convert Endian.
//!	@retval			---
//-----------------------------------------------------------------------
cb_inline
void EndianChange
		(
		void	*pmem ,		//!< [mod] pointer which is point to the data to convert.
		int32	e_size ,	//!< [in] size of element.
		int32	e_num		//!< [in] num of element.
		)
{
	uint8	*psrc	= ( uint8* )pmem;
	int	e_off;
	for( e_off = 0 ; e_off < e_num ; e_off++ )
	{
		EndianChange( psrc , e_size );
		psrc	+= e_size;
	}
	
}

/**************************************************************************************************
"FileReader" class 
**************************************************************************************************/
class FileReader : 
	virtual public object_base , 
	public IFileReader
{
// query
	query_begin();
	iface_hook( IStreamRead , IStreamRead_IID )
	iface_hook( IFileStreamRead , IFileStreamRead_IID )
	iface_hook( IFileReader , IFileReader_IID )
	query_end( object_base );

// variable member
private:
	FILE*	m_file;
	
// "IStreamRead" interface functions
public:
//=================================================================================================
//!	get position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
uint64 cb_call GetPosition()const
{
	if( m_file == NULL )
		return 0;
	return ::_ftelli64( m_file );
}
//=================================================================================================
//!	Read
//!	@retval			actually writed element num
//-------------------------------------------------------------------------------------------------
int32 cb_call Read
		(
		void		*pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		)
{
	if( m_file == NULL )
		return 0;

	int32	ac_element_num = fread( pbuf , element_size , element_num , m_file );

#if defined( cb_little_endian ) 
	if( element_size != 1 && endian == Big_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )ac_element_num );
#elif defined( cb_big_endian )	
	if( element_size != 1 && endian == Little_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )ac_element_num );
#else
	#error	unknown endian.
#endif

	return ac_element_num;
}
// "IStreamFileRead" interface functions
public:
//=================================================================================================
//!	get size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
uint64 cb_call GetSize()
{
	if( m_file == NULL )
		return 0;

	//store.
	uint64		pos = GetPosition();
	
	//move pos to end.
	cb_verify( true == Seek( 0 , End_SeekOrigin ) );
	uint64		size	= GetPosition();
	
	//restore.
	cb_verify( true == Seek( pos ) );

    return	size;
}
//=================================================================================================
//!	seek
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		)
{
	if( m_file == NULL )
		return false;
	if( 0 != _fseeki64
			( 
			m_file , 
			offset , 
			( origin == Begin_SeekOrigin ) ? SEEK_SET : ( ( origin == Current_SeekOrigin ) ? SEEK_CUR : SEEK_END ) 
			) )
		return false;
	return true;
}

// "IFileReader" interface functions
public:
//=================================================================================================
//!	open
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Open
		(
		const wchar_t*	t_path
		)
{
	Close();
	
	wstring	path = t_path;
	int		pos = 0;
	if( true == MatchString( path , &pos , L"file:[/]+" , 0 ) )
		path.erase( 0 , pos );
	
	if( 0 != _wfopen_s( &m_file , path.c_str() , L"rb" ) )
		return false;
	return true;
}
//=================================================================================================
//!	close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Close()
{
	if( m_file != NULL )
		fclose( m_file );
	m_file = NULL;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FileReader() : m_file( NULL )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~FileReader()
{
	Close();
}
};
/**************************************************************************************************
"FileWriter" class 
**************************************************************************************************/
class FileWriter : 
	virtual public object_base , 
	public IFileWriter
{
// query
	query_begin();
	iface_hook( IStreamWrite , IStreamWrite_IID )
	iface_hook( IFileStreamWrite , IFileStreamWrite_IID )
	iface_hook( IFileWriter , IFileWriter_IID )
	query_end( object_base );

// variable member
private:
	FILE*			m_file;
	Array<uint8>	m_buffer;
	
// "IStreamWrite" interface functions
public:
//=================================================================================================
//!	get position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
uint64 cb_call GetPosition()const
{
	if( m_file == NULL )
		return 0;
	return ::_ftelli64( m_file );
}
//=================================================================================================
//!	Read
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Write
		(
		const void*	pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		)
{
	if( m_file == NULL )
		return false;

#if defined( cb_little_endian )
	if( endian == Little_EndianType || element_size == 1 )
	{
		if( element_num != fwrite( pbuf , element_size , element_num , m_file ) )
			return false;
	}
	else
	{
		const uint8*	src = ( const uint8* )pbuf;
		m_buffer.Resize( element_size );
		int		e_off;
		for( e_off = 0 ; e_off < element_num ; e_off++ )
		{
			MemoryCopy( m_buffer.GetPtr() , src , element_size );
			EndianChange( m_buffer.GetPtr() , element_size );
			if( 1 != fwrite( m_buffer.GetPtr() , element_size , 1 , m_file ) )
				return false;
			src += element_size;
		}
	}
#elif defined( cb_big_endian )	
	if( endian == Big_EndianType || element_size == 1  )
	{
		if( element_num != fwrite( pbuf , element_size , element_num , m_file ) )
			return false;
	}
	else
	{
		const uint8*	src = ( const uint8* )pbuf;
		m_buffer.Resize( element_size );
		int		e_off;
		for( e_off = 0 ; e_off < element_num ; e_off++ )
		{
			MemoryCopy( m_buffer.GetPtr() , src , element_size );
			EndianChange( m_buffer.GetPtr() , element_size );
			if( 1 != fwrite( m_buffer.GetPtr() , element_size , 1 , m_file ) )
				return false;
			src += element_size;
		}
	}
#else
	#error	unknown endian.
#endif
	return true;
}
// "IStreamFileRead" interface functions
public:
//=================================================================================================
//!	seek
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		)
{
	if( m_file == NULL )
		return false;
	if( 0 != _fseeki64
			( 
			m_file , 
			offset , 
			( origin == Begin_SeekOrigin ) ? SEEK_SET : ( ( origin == Current_SeekOrigin ) ? SEEK_CUR : SEEK_END ) 
			) )
		return false;
	return true;
}

// "IFileReader" interface functions
public:
//=================================================================================================
//!	open
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Open
		(
		const wchar_t*	t_path
		)
{
	Close();

	wstring	path = t_path;
	int		pos = 0;
	if( true == MatchString( path , &pos , L"file:[/]+" , 0 ) )
		path.erase( 0 , pos );

	if( 0 != _wfopen_s( &m_file , path.c_str() , L"wb" ) )
		return false;
	return true;
}
//=================================================================================================
//!	close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call Close()
{
	if( m_file != NULL )
		fclose( m_file );
	m_file = NULL;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FileWriter() : 
		m_file( NULL ) , 
		m_buffer( Expand_ArrayCashType , 64 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~FileWriter()
{
	Close();
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
