/*************************************************************************************************/
/*!
   	@file		iFont.h
	@author 	Fanzo
 	@date 		2008/4/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFontManager.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
/**************************************************************************************************
 "IFont" interface 
***************************************************************************************************/
cb_guid_define( IFont_IID , 0x7070C46C , 0x5C904b46 , 0xBE86CD4B , 0x8C475BC7 );
class IFont;
typedef icubic::iface_object< IFont , IFont_IID >	iFont;
typedef icubic::iface_reference< IFont , IFont_IID >	rFont;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFont
{
#ifdef cb_windows
public:
	enum FontQuarity
	{
		Default , 
		iCubic , 
		Antialias , 
		Alias , 
		ClearType , 
	};
#endif
public:
//=================================================================================================
//!	create font
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Create
		(
		const fsize&		size , 
		const wstring&		facename , 
		FontCharsetType		charset , 
		int					weight	= 400 , 
		bool				italic	= false , 
		FontQuarity			quality	= IFont::Default
		) = 0;
//=================================================================================================
//!	set font size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetFontSize
		(
		const fsize&	size
		) = 0;
//=================================================================================================
//!	ascent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
float cb_call GetAscent() = 0;
//=================================================================================================
//!	descent
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
float cb_call GetDescent() = 0;
//=================================================================================================
//!	char width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
float cb_call GetCharWidthAve() = 0;
//=================================================================================================
//!	char width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
float cb_call GetCharWidthAve
		(
		float	height
		) = 0;
//=================================================================================================
//!	char width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetCharWidth
		(
		const wchar_t*	str , 
		int32			len , 
		float*			w		//!< [in] it need allocate len
		) = 0;
//=================================================================================================
//!	char height
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
float cb_call GetCharHeight() = 0;
//=================================================================================================
//!	kerning pair
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GetKerningPair
		(
		const wchar_t*	str , 
		int32			len , 
		float*			kerning		//!< [in] it need allocate len - 1
		) = 0;
//=================================================================================================
//!	draw string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call DrawString
		(
		iSurfaceDest&		surface , 
		const wchar_t*		str , 
		int					length , 
		const fvector2&		pos , 
		const rgba&			color , 
		const frect*		cp
		) = 0;
//=================================================================================================
//!	string size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fsize cb_call GetStringSize
		(
		iSurfaceDest&		surface , 
		const wchar_t*		str , 
		int					length
		) = 0;
//=================================================================================================
//!	font path
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call CreateCharPath
		(
		iPath&			path , 
		wchar_t			ch , 
		const faffine&	transform
		) = 0;
//=================================================================================================
//!	create string path
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call CreateStringPath
		(
		iPath&			path , 
		const wchar_t*	str , 
		int				length , 
		const faffine&	transform
		) = 0;
};

#ifdef cb_windows
/**************************************************************************************************
 "IFont_win" interface 
***************************************************************************************************/
cb_guid_define( IFont_win_IID , 0xB96DD77E , 0xA0A54695 , 0xB7848CD4 , 0xA6636674 );
class IFont_win;
typedef icubic::iface_object< IFont_win , IFont_win_IID >	iFont_win;
typedef icubic::iface_reference< IFont_win , IFont_win_IID >	rFont_win;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFont_win : public IFont
{
public:
//=================================================================================================
//!	set font style
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Create
		(
		const LOGFONTW&	logfont
		) = 0;
//=================================================================================================
//!	get logfont
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
LOGFONTW cb_call GetLOGFONT() = 0;
//=================================================================================================
//!	get hfont
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
HFONT cb_call GetHFONT() = 0;
};
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
