/*************************************************************************************************/
/*!
   	@file		main.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<windows.h>
#include	<math.h>
#include	<gdiplus.h>

using namespace Gdiplus;
#pragma comment(lib, "gdiplus")

using namespace icubic;
using namespace shared;


///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define create_item( obj_name , title_obj_name , title , view_height )																								\
	title_obj_name->SetString( title );																																\
	title_obj_name->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( m_es , y ) , isize( p->m_rect.Width() - m_es * 2 , m_ts ) ) );			\
	y += title_obj_name->GetRect().Height();																														\
	obj_name->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( m_es , y ) , isize( p->m_rect.Width() - m_es * 2 , view_height ) ) );		\
	obj_name->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );																						\
	y += obj_name->GetRect().Size().height;

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ControlView" class 
**************************************************************************************************/
class ControlView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
public:
	instance<SeparateView>		m_processor_t;
	instance<ProcessorCfgView>	m_processor;
	instance<SeparateView>		m_text_t;
	instance<TextSampleCfgView>	m_text;

private:
	rControlMsg						m_msg;
	int								m_id;
	
	const int						m_es;
	const int						m_ts;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = m_es;
	create_item( m_processor , m_processor_t , L"processor" , 20 );
	create_item( m_text , m_text_t , L"text" , 40 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawConfigBack( (iSurfaceDest)p->m_surface , GetRect().Size() );
}

// public functions
public:
//=================================================================================================
ControlView() : m_id( 0 ) , m_es( 5 ) , m_ts( 11 )
{
}
//=================================================================================================
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
};

/**************************************************************************************************
"FontView" class 
**************************************************************************************************/
class FontView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
public:
	instance<SeparateView>		m_font_t;
	instance<FontCfgView>		m_font;

private:
	rControlMsg						m_msg;
	int								m_id;
	
	const int						m_es;
	const int						m_ts;
	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = m_es;
	create_item( m_font , m_font_t , L"font cfg" , p->m_rect.Height() - m_es * 2 - m_ts );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawConfigBack( (iSurfaceDest)p->m_surface , GetRect().Size() );
}

// public functions
public:
//=================================================================================================
FontView() : m_id( 0 ) , m_es( 5 ) , m_ts( 15 )
{
}
//=================================================================================================
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
};
/**************************************************************************************************
"MainView" class 
**************************************************************************************************/
class MainView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )
	query_end( View )

	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_hook( Size , OnSize )
	msg_view_hook( LDragStart , OnLDragStart )
	msg_view_hook( LDrag , OnLDrag )
	msg_view_hook( LDragEnd , OnLDragEnd )
	msg_view_hook( LDragCancel , OnLDragCancel )
	msg_view_map_end( View )

// variable member
private:
	instance<ControlView>			m_control;
	instance<FontView>				m_font;
	instance<TimeCfgView>			m_time;

	ivector2							m_start;
	fvector2							m_mov;
	const rgb							m_bc;
	
// msg functions
private:
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
// control
private:

// msg functions
private:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_time->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 10 , 0 ) , isize( 300 , 16 ) ) );
	m_time->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
	
	m_control->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( 1 , p->m_rect.Height() - 1 - 150 ) , isize( 90 , 150 ) ) );
	m_control->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );

	m_font->Create( ( rViewParentCtrl )( reference )this_object() , irect( ivector2( p->m_rect.Width() - 1 - 550 , p->m_rect.Height() - 1 - 150 ) , isize( 550 , 150 ) ) );
	m_font->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	ColorBlt( (iSurfaceDest)p->m_surface , p->m_rect , m_bc , Onezero_BltBlendType );	
	
	m_time->BeginMeasure();
	frect	cp( 10.0f , 20.0f , (float)(p->m_rect.Width() - 10) , (float)(p->m_rect.Height() - 150 - 10) );
	iFont		font = m_font->m_font->GetValue();
	fvector2	d = m_mov;
	d.y += font->GetAscent();
	
	wstring		text	= m_control->m_text->GetValue();
	unsigned int start	= 0;
	bool	f = false;
	do
	{
		unsigned int end = text.find( L"\n" , start );
		if( end == string::npos )
		{
			end = text.length();
			f	= true;
		}
		wstring		str = text.substr( start , end - start );		
		font->DrawString( (iSurfaceDest)p->m_surface , str.c_str() , str.length() , fvector2( 10.0f , 20.0f ) + d , m_font->m_font->GetColor() , &cp );
		
		start	= end + 1;
		d.y += font->GetAscent() + font->GetDescent();
	}while( f == false );
	m_time->EndMeasure();
	DrawRectStroke( (iSurfaceDest)p->m_surface , cp , 1.0f , rgb( 200 , 100 , 200 ) );
}
//=================================================================================================
void OnSize
		(
		Size_ViewPM*	p
		)
{
	m_control->Move( irect( ivector2( 1 , p->m_rect.Height() - 1 - 150 ) , isize( 90 , 150 ) ) );
	m_font->Move( irect( ivector2( p->m_rect.Width() - 1 - m_font->GetRect().Width() , p->m_rect.Height() - 1 - m_font->GetRect().Height() ) , m_font->GetRect().Size() ) );
}
//=================================================================================================
void OnLDragStart
		(
		LDragStart_ViewPM*	p
		)
{
	m_start	= p->m_pos;
}
//=================================================================================================
void OnLDrag
		(
		LDrag_ViewPM*	p
		)
{
	ivector2	d = p->m_pos - m_start;
	m_mov	+= fvector2(d) * 0.1f;
	m_start	= p->m_pos;
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
void OnLDragEnd
		(
		LDragEnd_ViewPM*	p
		)
{
}
//=================================================================================================
void OnLDragCancel
		(
		LDragCancel_ViewPM*	p
		)
{
}
// public functions
public:
//=================================================================================================
MainView() : 
		m_bc( 255 , 255 , 255 )
{
}
//=================================================================================================
bool Initialize()
{
	return true;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define





