/*************************************************************************************************/
/*!
   	@file		ProcessorCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ProcessorCfgView" class 
**************************************************************************************************/
class ProcessorCfgView : public RadioGroupView , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )
	query_end( RadioGroupView )

// variable member
private:
	rControlMsg							m_msg;
	int									m_id;
	
// "IControlMsg" interface functions
private:
//=================================================================================================
//!	change value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	int		s = GetSelect();
	if( s == 0 )
		pp_get_processor( cpu_pp_processor );
	else
		pp_get_processor( sse_pp_processor );
	
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// public functions
public:
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ProcessorCfgView() : m_id( 0 )
{
	SetRadioNum( 2 );
	SetString( 0 , L"cpu" );
	SetString( 1 , L"sse" );
	SetAlign( Horz_RadioAlign );
	pp_processor	pp = pp_get_processor();
	if( pp == cpu_pp_processor )
		SetSelect( 0 );
	else
		SetSelect( 1 );
	RadioGroupView::SetMsgCallback( ( rControlMsg )this_object() , 0 );
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace ProcessorCfgView;		

#pragma pack( pop )			//release align
