### /filter/blend.py

import wx
from gui.imageimport import *

from obj.objImage  import objImage
from obj.objFilter import objFilter
from obj.objGrid   import grid
from gui.colorPanel import *

from getInput import *
from setOutput import *
### properties
### ["blend",ratio,s(for swap)]

# dataoutput's size is obj.datainput[0]'s. 

d = 96

def blend(obj):
	# swap
	p = get_properties_blend(obj)
	
	if len(obj.datainput) == 2:
		if p.s == 1:
			obj.datainput[0],obj.datainput[1] = \
				obj.datainput[1],obj.datainput[0]
		blendconv(obj)
	else:
		obj.dataoutput = None

def blendconv(obj):
	p = get_properties_blend(obj)
	w = obj.datainput[0].size[0]
	h = obj.datainput[0].size[1]
	obj2 = obj.datainput[1].copy().resize((w,h))
	obj.dataoutput =\
		Image.blend(obj.datainput[0], obj2, p.ratio / 100.0)

class get_properties_blend:
	def __init__(self,obj):
		if len(obj.properties) == 3:
			self.ratio    = obj.properties[1]
			self.s        = obj.properties[2]
		else:
			self.ratio    = 50
			self.s        = 0

class blendUI:
	def __init__(self, panel, obj):
		self.obj = obj
		self.panel = panel
		self.p = get_properties_blend(obj)
		
		# get datainput
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 2:
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def makeFromToImage(self):
		#   fromImage 
		if   isinstance(self.obj.datainput[0], Image.Image):
			self.fromImage = self.obj.datainput[0].copy().resize((d,d))
		elif isinstance(self.obj.datainput[0], grid):
			self.fromImage = self.obj.datainput[0].pil.copy().resize((d,d))
		self.fromImage.thumbnail((d,d),Image.ANTIALIAS)
		
		if   isinstance(self.obj.datainput[1], Image.Image):
			self.toImage = self.obj.datainput[1].copy().resize((d,d))
		elif isinstance(self.obj.datainput[1], grid):
			self.toImage = self.obj.datainput[1].pil.copy().resize((d,d))
		self.toImage.thumbnail((d,d),Image.ANTIALIAS)

	def gui(self):		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage 
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		#   canvasImage
		if self.obj.dataoutput <> None:
			if   isinstance(self.obj.dataoutput, Image.Image):
				self.canvasImage = self.obj.dataoutput
			elif isinstance(self.obj.dataoutput, grid):
				self.canvasImage = self.obj.dataoutput.pil
			else:
				self.canvasImage = Image.new('RGB',(d*2+13,d*2+13),"white")
		else:
			self.canvasImage = Image.new('RGB',(d*2+13,d*2+13),"white")
		
		pcanvasImage = self.canvasImage.copy()
		pcanvasImage.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
		self.wxcanvasImage = wx.EmptyImage( \
			pcanvasImage.size[0], pcanvasImage.size[1])
		self.wxcanvasImage.SetData(pcanvasImage.convert('RGB').tostring())
		
		### gui
		self.panel.frame.SetSize((352,373))
		
		##  TopSize
		TopSize = wx.BoxSizer()
		TopLeftSize = wx.BoxSizer(wx.VERTICAL)
		TopRightSize = wx.BoxSizer(wx.VERTICAL)
		
		#   TopLeftSize
		
		self.LabelFrom = wx.StaticText(self.panel, -1,"From :")
		self.wxgfromImage = wx.StaticBitmap \
			(self.panel, -1, self.wxfromImage.ConvertToBitmap(),	\
			(self.wxfromImage.GetWidth(), self.wxfromImage.GetHeight()))
			
		self.LabelTo = wx.StaticText(self.panel, -1,"To :")
		self.wxgtoImage = wx.StaticBitmap \
			(self.panel, -1, self.wxtoImage.ConvertToBitmap(), \
			(self.wxtoImage.GetWidth(), self.wxtoImage.GetHeight()))
		
		TopLeftSize.Add(self.LabelFrom,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgfromImage,0,wx.EXPAND | wx.BOTTOM, 0)
		#TopLeftSize.Add((-1,d),1,wx.EXPAND | wx.BOTTOM, 10)
		TopLeftSize.Add(self.LabelTo,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgtoImage,0,wx.EXPAND | wx.ALIGN_RIGHT| wx.BOTTOM, 0)
		
		#   TopRightSize
		self.LabelCanvas = wx.StaticText(self.panel, -1,"Canvas :")
		self.wxgcanvasImage = wx.StaticBitmap \
			(self.panel, -1, self.wxcanvasImage.ConvertToBitmap(),	\
			(self.wxcanvasImage.GetWidth(), self.wxcanvasImage.GetHeight()))
		TopRightSize.Add(self.LabelCanvas,0,wx.ALL, 0)			
		TopRightSize.Add(self.wxgcanvasImage,0,wx.EXPAND | wx.Top, 10)
		
		#   Labels:
		self.SetLabel()
		
		#   TopSize
		TopSize.Add(TopLeftSize,0,wx.FIXED_MINSIZE | wx.RIGHT, 13)
		TopSize.Add(TopRightSize,1,wx.EXPAND,0)
		
		##  Middle - Slider
		self.slider = wx.Slider(
			self.panel, 3,0,0,100,(0,0),(-1,-1), \
			wx.SL_HORIZONTAL | wx.SL_AUTOTICKS | wx.SL_LABELS
			)
		self.slider.SetTickFreq(10,1)
		
		##  BottomSize
		BottomSize           = wx.BoxSizer()
		
		ButtonMake = wx.Button(self.panel, -1, "Make")
		self.panel.Bind(wx.EVT_BUTTON, self.OnMake, ButtonMake)
		ButtonSwap = wx.Button(self.panel, -1, "Swap")
		self.panel.Bind(wx.EVT_BUTTON, self.swap, ButtonSwap)
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonMake, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonSwap, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonClose,0,wx.EXPAND | wx.ALL, 0)

		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(self.slider, 0, wx.EXPAND | wx.ALL, 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.ALL, 10)
		
		self.panel.SetSizer(MainSize)
		
		self.SetValueUI()
	
	def SetValueUI(self):
		self.slider.SetValue(self.p.ratio)
	def SetValueObj(self):
		self.obj.properties = \
			['blend', \
			 self.p.ratio, \
			 self.p.s]
	def OnMake(self, e):
		
		self.p.ratio = self.slider.GetValue()
		self.SetValueObj()
		
		if isinstance(self.obj.datainput[0], grid) or \
			isinstance(self.obj.datainput[1], grid):
			pass
		else:
			blendconv(self.obj)
			self.canvasImage = self.obj.dataoutput
			
			self.canvasImageth = self.canvasImage.copy().resize((d*2+13,d*2+13))
			
			self.canvasImageth.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
			
			self.wxcanvasImage = wx.EmptyImage( \
				self.canvasImageth.size[0], self.canvasImageth.size[1])
			self.wxcanvasImage.SetData(self.canvasImageth.convert('RGB').tostring())
			self.wxgcanvasImage.SetBitmap(self.wxcanvasImage.ConvertToBitmap())
			self.SetLabel()
			
	def swap(self,e):
		if self.p.s == 1:
			self.p.s = 0
		else:
			self.p.s = 1
		self.obj.datainput[0],self.obj.datainput[1] = \
			self.obj.datainput[1],self.obj.datainput[0]
		self.ImageRefresh()
	def SetLabel(self):
		if isinstance(self.obj.datainput[0],Image.Image):
			self.LabelFrom.SetLabel("Fr: Image %dx%d" % \
				(self.obj.datainput[0].size[0], \
				 self.obj.datainput[0].size[1]))
		elif isinstance(self.obj.datainput[0],grid):
			self.LabelFrom.SetLabel("Fr: Grid  %dx%d" % \
				(self.obj.datainput[0].w, \
				 self.obj.datainput[0].h))
		else:
			self.LabelFrom.SetLabel("Fr: ")
			
		if isinstance(self.obj.datainput[1],Image.Image):
			self.LabelTo.SetLabel("To: Image %dx%d" % \
				(self.obj.datainput[1].size[0], \
				 self.obj.datainput[1].size[1]))
		elif isinstance(self.obj.datainput[1],grid):
			self.LabelTo.SetLabel("To: Grid  %dx%d" % \
				(self.obj.datainput[1].w, \
				 self.obj.datainput[1].h))
		else:
			self.LabelTo.SetLabel("To: ")
			
		if isinstance(self.obj.dataoutput,Image.Image):
			self.LabelCanvas.SetLabel("Canvas: Image %dx%d" % \
				(self.canvasImage.size[0],self.canvasImage.size[1]))
		elif isinstance(self.obj.dataoutput,grid):
			self.LabelCanvas.SetLabel("Canvas: Grid  %dx%d" % \
				(self.obj.dataoutput.w,self.obj.dataoutput.h))
		else:
			self.LabelCanvas.SetLabel("Canvas: ")
	def ImageRefresh(self):
		d = 96
		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		self.wxgfromImage.SetBitmap(self.wxfromImage.ConvertToBitmap())
		self.wxgtoImage.SetBitmap(self.wxtoImage.ConvertToBitmap())
		
		#   Label
		self.SetLabel()

	def OnCloseMe(self,e):
		# dismiss
		self.SetValueObj
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		self.panel.frame.Close(True)
		