
### /filter/filter.py

import wx
from gui.imageimport import *


from obj.objImage  import objImage
from obj.objFilter import objFilter
from obj.objGrid   import grid

from anchor        import *
from blend         import *
from copy          import *
from crop          import *
from dc            import *
from i2g           import *
from mask          import *
from replace       import *
from resize        import *
from rotate        import *
from score         import *
from desaturate    import *

def make(obj):
	# properties[0] is a filter function name
	filterName = obj.properties[0]
	
	# because this item is updated when it makes, we can set the function
	if   filterName == "rotate":
		# set method
		obj.function = rotate
		# set degree in properties[1]
		obj.getcount = 1
		obj.properties = [filterName,0]
	elif filterName == "i2g":
		obj.function = i2g
		obj.getcount = 2	# but can be running only one data input
	elif filterName == "copy":
		obj.function = copy
		obj.getcount = 2
	elif filterName == "blend":
		obj.function = blend
		obj.getcount = 2
	elif filterName == "anchor":
		obj.function = anchor
		obj.getcount = 1
	elif filterName == "desaturate":
		obj.function = desaturate
		obj.getcount = 1
	elif filterName == "score":
		obj.function = lambda obj: obj
		obj.getcount = 16	# midi channel
	elif filterName == "mask":
		obj.function = mask
		obj.getcount = 2
	elif filterName == "resize":
		obj.function = resize
		obj.getcount = 1
	elif filterName == "replace":
		obj.function = replace
		obj.getcount = 1
	elif filterName == "crop":
		obj.function = crop
		obj.getcount = 1
	else:
		pass

class filterPanel(wx.Panel):
	def __init__(self,parent,obj):
		# prepare panel
		wx.Panel.__init__(self, parent, -1)
		self.frame = parent
		# prepare using object
		self.obj = obj
		
		filterName = self.obj.properties[0]
		
		if   filterName == "rotate":
			rotateUI(self, self.obj)
		elif filterName == "copy":
			copyUI(self,self.obj)
		elif filterName == "desaturate":
			desaturateUI(self, self.obj)
		elif filterName == "i2g":
			i2gUI(self,self.obj)
		elif filterName == "score":
			scoreUI(self, self.obj)
		elif filterName == "resize":
			resizeUI(self, self.obj)
		elif filterName == "replace":
			replaceUI(self, self.obj)
		elif filterName == "crop":
			cropUI(self, self.obj)
		elif filterName == "blend":
			blendUI(self, self.obj)
		elif filterName == "anchor":
			anchorUI(self, self.obj)
		elif filterName == "mask":
			maskUI(self, self.obj)
		else:
			pass
	