### /filter/mask.py

import wx
from gui.imageimport import *

from obj.objImage  import objImage
from obj.objFilter import objFilter
from obj.objGrid   import grid
from gui.colorPanel import *

from getInput import *
from setOutput import *

### properties
### ["mask", ColorDis(discrimination), ColorChange, ColorInvert, s(swap)]

###  maskImage(only PIL Image): obj.datainput[0]
### pasteImage(only PIL Image): obj.datainput[1]

d = 96

	
def mask(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 

	# swap
	p = get_properties_mask(obj)
	
	if len(obj.datainput) > 1:
		if p.s == 1:
			obj.datainput[0],obj.datainput[1] = \
				obj.datainput[1],obj.datainput[0]
		maskconv(obj)
	else:
		obj.dataoutput = None

def maskconv(obj):
	p = get_properties_mask(obj)
	maskImage = obj.datainput[0].copy()
	w, h = maskImage.size[0], maskImage.size[1]
	pasteImage = obj.datainput[1].copy().resize((w,h))
	
	if p.ColorInvert == False:
		for i in range(w):
			for j in range(h):
				if dis(maskImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
					maskImage.putpixel((i,j), pasteImage.getpixel((i,j)))
	else:
		for i in range(w):
			for j in range(h):
				if not dis(maskImage.getpixel((i,j)), p.ColorDis, p.ColorChange / 100.0):
					maskImage.putpixel((i,j), pasteImage.getpixel((i,j)))

	obj.dataoutput = maskImage.copy()
	
class get_properties_mask:
	def __init__(self,obj):
		if len(obj.properties) == 5:
			self.ColorDis     = obj.properties[1]
			self.ColorChange  = obj.properties[2]
			self.ColorInvert  = obj.properties[3]
			self.s            = obj.properties[4]
		else:
			self.ColorDis     = (0,0,0)
			self.ColorChange  = 0
			self.ColorInvert  = False
			self.s            = 0

class maskUI:
	def __init__(self, panel, obj):
		self.obj = obj
		self.panel = panel
		self.p = get_properties_mask(obj)
		
		# get datainput
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 2:
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def makeFromToImage(self):
		#   fromImage 
		if   isinstance(self.obj.datainput[0], Image.Image):
			self.fromImage = self.obj.datainput[0].copy().resize((d,d),Image.ANTIALIAS)
		elif isinstance(self.obj.datainput[0], grid):
			self.fromImage = self.obj.datainput[0].pil.copy().resize((d,d),Image.ANTIALIAS)
		self.fromImage.thumbnail((d,d),Image.ANTIALIAS)
		
		if   isinstance(self.obj.datainput[1], Image.Image):
			self.toImage = self.obj.datainput[1].copy().resize((d,d),Image.ANTIALIAS)
		elif isinstance(self.obj.datainput[1], grid):
			self.toImage = self.obj.datainput[1].pil.copy().resize((d,d),Image.ANTIALIAS)
		self.toImage.thumbnail((d,d),Image.ANTIALIAS)

	def gui(self):		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage 
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		#   canvasImage
		if self.obj.dataoutput <> None:
			if   isinstance(self.obj.dataoutput, Image.Image):
				self.canvasImage = self.obj.dataoutput
			elif isinstance(self.obj.dataoutput, grid):
				self.canvasImage = self.obj.dataoutput.pil
			else:
				self.canvasImage = Image.new('RGB',(d*2+13,d*2+13),"white")
		else:
			self.canvasImage = Image.new('RGB',(d*2+13,d*2+13),"white")
		
		pcanvasImage = self.canvasImage.copy()
		pcanvasImage.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
		self.wxcanvasImage = wx.EmptyImage( \
			pcanvasImage.size[0], pcanvasImage.size[1])
		self.wxcanvasImage.SetData(pcanvasImage.convert('RGB').tostring())
		
		### gui
		self.panel.frame.SetSize((352,348))
		
		##  TopSize
		TopSize = wx.BoxSizer()
		TopLeftSize = wx.BoxSizer(wx.VERTICAL)
		TopRightSize = wx.BoxSizer(wx.VERTICAL)
		
		#   TopLeftSize
		
		self.LabelFrom = wx.StaticText(self.panel, -1,"Mk:")
		self.wxgfromImage = wx.StaticBitmap \
			(self.panel, -1, self.wxfromImage.ConvertToBitmap(),	\
			(self.wxfromImage.GetWidth(), self.wxfromImage.GetHeight()))
			
		self.LabelTo = wx.StaticText(self.panel, -1,"Pt:")
		self.wxgtoImage = wx.StaticBitmap \
			(self.panel, -1, self.wxtoImage.ConvertToBitmap(), \
			(self.wxtoImage.GetWidth(), self.wxtoImage.GetHeight()))
		
		TopLeftSize.Add(self.LabelFrom,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgfromImage,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.LabelTo,0,wx.EXPAND | wx.BOTTOM, 0)
		TopLeftSize.Add(self.wxgtoImage,0,wx.EXPAND | wx.ALIGN_RIGHT| wx.BOTTOM, 0)
		
		#   TopRightSize
		self.LabelCanvas = wx.StaticText(self.panel, -1,"Canvas:")
		self.wxgcanvasImage = wx.StaticBitmap \
			(self.panel, -1, self.wxcanvasImage.ConvertToBitmap(),	\
			(self.wxcanvasImage.GetWidth(), self.wxcanvasImage.GetHeight()))
		TopRightSize.Add(self.LabelCanvas,0,wx.ALL, 0)			
		TopRightSize.Add(self.wxgcanvasImage,0,wx.EXPAND | wx.Top, 10)
		
		#   Labels:
		self.SetLabel()
		
		#   TopSize
		TopSize.Add(TopLeftSize,0,wx.FIXED_MINSIZE | wx.RIGHT, 13)
		TopSize.Add(TopRightSize,1,wx.EXPAND,0)
		
		##  MiddleSize
		MiddleSize = wx.BoxSizer()
		self.ButtonColorDis  = ColorPanel(self.panel)
		self.panel.Bind(EVT_CHANGE_COLOR, self.OnChangeColorDis, \
			id = self.ButtonColorDis.GetId())
		self.LabelPM = wx.StaticText(self.panel, -1," +- ")
		self.TextPer = wx.TextCtrl(self.panel, -1, "1", size = wx.DefaultSize)
		self.panel.Bind(wx.EVT_TEXT, self.OnTextPer, self.TextPer)
		self.LabelPer = wx.StaticText(self.panel, -1," %")
		self.CheckColorInvert = wx.CheckBox(self.panel,-1,"Invert")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnColorInvert, self.CheckColorInvert)
		
		MiddleSize.Add(self.ButtonColorDis, 0,wx.EXPAND | wx.LEFT | wx.RIGHT, 10)
		MiddleSize.Add(self.LabelPM, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 3)
		MiddleSize.Add(self.TextPer, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 3)
		MiddleSize.Add(self.LabelPer, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 3)
		MiddleSize.Add(wx.DefaultSize,1,wx.EXPAND)
		MiddleSize.Add(self.CheckColorInvert, 0,wx.EXPAND | wx.RIGHT, 10)
		
		##  BottomSize
		BottomSize = wx.BoxSizer()
		
		ButtonMake = wx.Button(self.panel, -1, "Make")
		self.panel.Bind(wx.EVT_BUTTON, self.OnMake, ButtonMake)
		ButtonSwap = wx.Button(self.panel, -1, "Swap")
		self.panel.Bind(wx.EVT_BUTTON, self.swap, ButtonSwap)
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(ButtonMake, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonSwap, 0,wx.EXPAND | wx.RIGHT | wx.LEFT | wx.TOP, 0)
		BottomSize.Add(ButtonClose,0,wx.EXPAND | wx.ALL, 0)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(MiddleSize, 0, wx.EXPAND | wx.ALL, 0)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.ALL, 10)
		
		self.panel.SetSizer(MainSize)
		
		self.SetValueUI()
	def OnColorInvert(self, e):
		self.p.ColorInvert = self.CheckColorInvert.IsChecked()
	def OnChangeColorDis(self, e):
		self.p.ColorDis = e.GetColor()
	def OnTextPer(self, e):
		if self.TextPer.GetValue()!="":
			i = int(self.TextPer.GetValue())
			if not (0 <= i <= 100):
				self.TextPer.SetValue('0')
				i = 0
			self.p.ColorChange = i
	def SetValueUI(self):
		self.ButtonColorDis.SetColor(self.p.ColorDis)
		self.TextPer.SetValue(str(self.p.ColorChange))
		self.CheckColorInvert.SetValue(self.p.ColorInvert)
	def SetValueObj(self):
		self.obj.properties = \
			['mask', \
			 self.p.ColorDis, \
			 self.p.ColorChange, \
			 self.p.ColorInvert, \
			 self.p.s]
	def OnMake(self, e):
		
		self.SetValueObj()
		
		if isinstance(self.obj.datainput[0], grid) or \
			isinstance(self.obj.datainput[1], grid):
			pass
		else:
			maskconv(self.obj)
			self.canvasImage = self.obj.dataoutput
			
			self.canvasImageth = self.canvasImage.copy()
			self.canvasImageth.thumbnail((d*2+13,d*2+13),Image.ANTIALIAS)
			
			self.wxcanvasImage = wx.EmptyImage( \
				self.canvasImageth.size[0], self.canvasImageth.size[1])
			self.wxcanvasImage.SetData(self.canvasImageth.convert('RGB').tostring())
			self.wxgcanvasImage.SetBitmap(self.wxcanvasImage.ConvertToBitmap())
			self.SetLabel()
			
	def swap(self,e):
		if self.p.s == 1:
			self.p.s = 0
		else:
			self.p.s = 1
		self.obj.datainput[0],self.obj.datainput[1] = \
			self.obj.datainput[1],self.obj.datainput[0]
		self.ImageRefresh()
	def SetLabel(self):
		if isinstance(self.obj.datainput[0],Image.Image):
			self.LabelFrom.SetLabel("Mk: Image %dx%d" % \
				(self.obj.datainput[0].size[0], \
				 self.obj.datainput[0].size[1]))
		elif isinstance(self.obj.datainput[0],grid):
			self.LabelFrom.SetLabel("Mk: Grid  %dx%d" % \
				(self.obj.datainput[0].w, \
				 self.obj.datainput[0].h))
		else:
			self.LabelFrom.SetLabel("Mk: ")
			
		if isinstance(self.obj.datainput[1],Image.Image):
			self.LabelTo.SetLabel("Pt: Image %dx%d" % \
				(self.obj.datainput[1].size[0], \
				 self.obj.datainput[1].size[1]))
		elif isinstance(self.obj.datainput[1],grid):
			self.LabelTo.SetLabel("Pt: Grid  %dx%d" % \
				(self.obj.datainput[1].w, \
				 self.obj.datainput[1].h))
		else:
			self.LabelTo.SetLabel("Pt: ")
			
		if isinstance(self.obj.dataoutput,Image.Image):
			self.LabelCanvas.SetLabel("Canvas: Image %dx%d" % \
				(self.canvasImage.size[0],self.canvasImage.size[1]))
		elif isinstance(self.obj.dataoutput,grid):
			self.LabelCanvas.SetLabel("Canvas: Grid  %dx%d" % \
				(self.obj.dataoutput.w,self.obj.dataoutput.h))
		else:
			self.LabelCanvas.SetLabel("Canvas: ")
	def ImageRefresh(self):
		d = 96
		### make thumbnail and wxinput
		self.makeFromToImage()
		#   fromImage 
		self.wxfromImage = wx.EmptyImage( \
			self.fromImage.size[0], self.fromImage.size[1])
		self.wxfromImage.SetData(self.fromImage.convert('RGB').tostring())
		
		#   toImage
		self.wxtoImage = wx.EmptyImage( \
			self.toImage.size[0], self.toImage.size[1])
		self.wxtoImage.SetData(self.toImage.convert('RGB').tostring())
		
		self.wxgfromImage.SetBitmap(self.wxfromImage.ConvertToBitmap())
		self.wxgtoImage.SetBitmap(self.wxtoImage.ConvertToBitmap())
		
		#   Label
		self.SetLabel()

	def OnCloseMe(self,e):
		# dismiss
		self.SetValueObj()
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		self.panel.frame.Close(True)
		