### /conv/abc.py

from object import *

def n(str):
	return str + "\n"


import Image
import string
import os

def pil2card(pilImage, filename,tempo):
	out = ""
	
	image = pilImage.convert("L")
	
	j1, j2 = 0,0
	count = 0
	while j2 < image.size[1]:
		j1  = j2
		j2 += 84
		if j2 > image.size[1]: j2 = image.size[1]
		
		count += 1
		out += "V:" + str(count) + " % " + str(j1) + "-" + str(j2) + "\n"
		
		for i in range(image.size[0]):
			line = []
			for j in range(j1,j2):
				l = 7 - int(image.getpixel((i,j)) / 32)
				p = num2abc((j % 84),l)
				if p <> None: line.append(p)
				
			if line == []:
				out += "z\n"
			else:
				pline = "["
				for c in line:
					pline += ("%s " % c)
				pline += "]"
				out += pline + "\n"
	filename = os.getcwd() +"/" +  filename
	out = "X: 1\nT: " + filename + "\nC: hoge\nM: C\nL: 1/8\nQ: " + str(tempo) + "\nK: C\n" + out
	
	fw = open(filename, 'w')
	fw.write(out)
	fw.close()
def num2abc(number,dynamic):
	p,q,d = int(number / 12), number % 12, dynamic
	pc,qc = '',''
	
	if   (q == 0):  qc = '=C'
	elif (q == 1):  qc = '^C'
	elif (q == 2):  qc = '=D'
	elif (q == 3):  qc = '_E'
	elif (q == 4):  qc = '=E'
	elif (q == 5):  qc = '=F'
	elif (q == 6):  qc = '^F'
	elif (q == 7):  qc = '=G'
	elif (q == 8):  qc = '^G'
	elif (q == 9):  qc = '=A'
	elif (q == 10): qc = '_B'
	elif (q == 11): qc = '=B'
	
	if   (p == 0):  pc = qc + ",,,"
	elif (p == 1):  pc = qc + ",,"
	elif (p == 2):  pc = qc + ","
	elif (p == 3):  pc = qc
	elif (p == 4):  pc = string.lower(qc)
	elif (p == 5):  pc = string.lower(qc) + "\'"
	elif (p == 6):  pc = string.lower(qc) + "\'\'"
	elif (p == 7):  pc = string.lower(qc) + "\'\'\'"
	
	if   (d == 0):	pc = None
	elif (d == 1):	pc = "!ppp!" + pc
	elif (d == 2):	pc = "!pp!"  + pc
	elif (d == 3):	pc = "!p!"   + pc
	elif (d == 4):	pc = "!mf!"  + pc
	elif (d == 5):	pc = "!f!"   + pc
	elif (d == 6):	pc = "!ff!"  + pc
	elif (d == 7):	pc = "!fff!" + pc
	
	return pc