### /gui/validator.py

import wx

digits = '0123456789-.'

class MyValidator(wx.PyValidator):
	def __init__(self):
		wx.PyValidator.__init__(self)
		self.Bind(wx.EVT_CHAR, self.OnChar)
	def Clone(self):
		return MyValidator()
	def Validate(self, win):
		tc = self.GetWindow()
		val = tc.GetValue()
		
		for x in val:
			if x not in digits:
				return False
			
		return False
	def OnChar(self, event):
		key = event.KeyCode()
		if key < wx.WXK_SPACE or key == wx.WXK_DELETE or key > 255:
			event.Skip()
			return
		
		if chr(key) in digits:
			event.Skip()
			return
		return
		