### /obj/objFilter.py

import wx
import wx.lib.ogl as ogl
from gui.imageimport import *

from objGrid import grid

def colorInv(color):
	# unique color maker
	d = []
	color = list(color)
	p = color.index(max(color[0], color[1], color[2]))
	for i in range(3):
		if i <> p:
			color[i] = 255 - color[i]
			break
	for c in color:
		if 0 <= c <= 127:
			d.append('ff')
		else:
			d.append('00')
	return '#' + d[0] + d[1] + d[2]

class objFilter(ogl.BitmapShape):
	def __init__(self,x,y,shapew,shapeh, \
				 text,input=[],output=[],properties=[], \
				 editcount = 0,getcount = 1,name = ""):
		ogl.BitmapShape.__init__(self)
		self.SetX(x)
		self.SetY(y)
		
		self.name = ""
		
		self.edit_text(text)
		
		self.input = input
		self.output = output
		self.datainput = []
		self.dataoutput = None
		
		self.voice = None
		
		self.shapew = shapew
		self.shapeh = shapeh
		
		self.properties  = properties
		self.preferences = []
		self.editcount   = editcount
		
		self.getcount = getcount
		
		self.flgdialog = 0	# 0 -> Off, 1 -> On
	def edit_text(self,text):
		
		self.ClearText()
		self.text = text
		self.AddText(text)
	def PreviewBitmap(self):
		if self.dataoutput <> None:
			if   isinstance(self.dataoutput,Image.Image):
				pilbmp = self.dataoutput.copy()
			elif isinstance(self.dataoutput,grid):
				if self.dataoutput.pil <> None:
					pilbmp = self.dataoutput.pil.copy()
				else:
					pilbmp = Image.new('RGB', (self.shapew, self.shapeh), '#999999')
		else:
			pilbmp = Image.new('RGB', (self.shapew, self.shapeh), '#999999')
		
		pilbmp.thumbnail((self.shapew,self.shapeh),Image.ANTIALIAS)
		
		if pilbmp.size[0] < self.shapew:
			if pilbmp.size[1] < self.shapeh:
				if pilbmp.size[0] > pilbmp.size[1]:
					ratio = (pilbmp.size[1] + 0.0) / pilbmp.size[0]	# float
					pilbmp = pilbmp.resize((self.shapew,int(self.shapeh * ratio)))
				else:
					ratio = (pilbmp.size[0] + 0.0) / pilbmp.size[1]	# float
					pilbmp = pilbmp.resize((int(self.shapew * ratio),self.shapeh))
			else:
				pilbmp.thumbnail((self.shapew,self.shapeh),Image.ANTIALIAS)
		else:
			pilbmp.thumbnail((self.shapew,self.shapeh),Image.ANTIALIAS)
			
		wxbmp = wx.EmptyImage(pilbmp.size[0], pilbmp.size[1])
		wxbmp.SetData(pilbmp.convert('RGB').tostring())
		#self.edit_text('')
		self.SetBitmap(wxbmp.ConvertToBitmap())
		
		
		# set obj's color
		# -- resize image to get an average color
		c = pilbmp.resize((1,1), Image.ANTIALIAS).convert('RGB').getpixel((0,0))
		self.SetTextColour(colorInv(c))