### /filter/invert.py

import wx
from gui.imageimport import *
import ImageChops

from obj.objImage  import objImage
from obj.objFilter import objFilter

from getInput import *
from setOutput import *

### properties
### ["invert"]

def invert(obj):
	if len(obj.datainput) < 1:
		obj.dataoutput = None
		return 

	if isinstance(obj.datainput[0],Image.Image):
		obj.dataoutput = ImageChops.invert(obj.datainput[0])
	else:
		obj.dataoutput = None

class invertUI:
	def __init__(self,panel,obj):
		# take properties
		self.obj = obj
		
		self.panel = panel
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		elif not isinstance(obj.datainput[0],Image.Image):
			self.panel.frame.Close(True)
		else:
			# make gui
			self.gui()
	def gui(self):	# make panel
		
		d = 160
		# make pil_input_thumbnail picture and wxinput
		self.datainputh = self.obj.datainput[0].copy()
		self.datainputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxinput = wx.EmptyImage(self.datainputh.size[0], self.datainputh.size[1])
		self.wxinput.SetData(self.datainputh.convert('RGB').tostring())
		
		# make pil_output_thumbnail picture and wxoutput
		self.dataoutputh = self.obj.dataoutput.copy()
		self.dataoutputh.thumbnail((d,d),Image.ANTIALIAS)
		
		self.wxoutput = wx.EmptyImage(self.dataoutputh.size[0], self.dataoutputh.size[1])
		self.wxoutput.SetData(self.dataoutputh.convert('RGB').tostring())
		
		# make gui
		self.panel.frame.SetSize((386,255))
		
		TopSize = wx.BoxSizer()
		self.wxginput = wx.StaticBitmap(self.panel, -1, self.wxinput.ConvertToBitmap(),	\
					   (self.wxinput.GetWidth(), self.wxinput.GetHeight()))
		self.wxgoutput = wx.StaticBitmap(self.panel, -1, self.wxoutput.ConvertToBitmap(), \
					   (self.wxoutput.GetWidth(), self.wxoutput.GetHeight()))
		TopSize.Add(self.wxginput,0,wx.FIXED_MINSIZE | wx.BOTTOM, 10)
		TopSize.Add(wx.DefaultSize,1,wx.EXPAND)
		TopSize.Add(self.wxgoutput,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		BottomSize = wx.BoxSizer()
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(wx.DefaultSize, 1, wx.EXPAND)
		BottomSize.Add(ButtonClose,0,wx.FIXED_MINSIZE | wx.ALIGN_RIGHT, 10)
		
		MainSize = wx.BoxSizer(wx.VERTICAL)
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.BOTTOM , 10)
		
		self.panel.SetSizer(MainSize)
	def OnCloseMe(self,e):	
		self.obj.properties = ["invert"]
			
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		
		# dismiss
		self.panel.frame.Close(True)
