### /filter/score.py

import wx
from gui.imageimport import *

from obj.objImage   import objImage
from obj.objFilter  import objFilter
from obj.objGrid    import grid
from gui.colorPanel import *
from gui.viewPanel  import *
from getInput       import *
from setOutput      import *

from conv.score     import *
from conv.ly		import *

Clist = ['w', 'b']

class get_properties_score:
	### properties
	### ["score", selectObj, filename, tempo, times, selectConv]
	def __init__(self,obj):
		if len(obj.properties) == 6:
			self.selectObj  = obj.properties[1]
			self.filename   = obj.properties[2]
			self.tempo      = obj.properties[3]
			self.length     = obj.properties[4]
			self.selectConv = obj.properties[5]
		else:
			self.selectObj  = None
			self.filename   = "hoge"
			self.tempo      = 42
			self.length     = 1
			self.selectConv = [1]
### preferences
### [times, pitch, midi, noteNumber, [note's properties]]

class get_obj_preferences:
	def __init__(self, obj=None):
		if obj <> None:
			if len(obj.preferences) == 5:
				self.times     = obj.preferences[0]
				self.pitch      = obj.preferences[1]
				self.midi       = obj.preferences[2]
				self.noteppt    = obj.preferences[4]
			else:
				self.times      = [4, 4]
				self.pitch      = [0, 127]
				self.midi       = 0
				self.noteppt    = []
		else:
			self.times          = [4, 4]
			self.pitch          = [0, 127]
			self.midi           = 0
			self.noteppt        = []
			
class objPreferences(wx.StaticBoxSizer):
	def __init__(self, box, panel, vpanel):
		wx.StaticBoxSizer.__init__(self, box)
		self.panel = panel
		self.vpanel = vpanel
		self.obj = None
		self.r = get_obj_preferences()
		self.gui()
	def SetLength(self, length):
		self.length = length
	def gui(self):
		LeftSize = wx.BoxSizer(wx.VERTICAL)
		FGSize = wx.FlexGridSizer(3,2,0,0)
		self.LabelTimes     = wx.StaticText(self.panel, -1,"times: ")
		self.TextTimeA      = wx.TextCtrl(self.panel, -1, "4",   size = (35,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextTimeA, self.TextTimeA)
		self.LabelTimeSlash = wx.StaticText(self.panel, -1," / ")
		self.TextTimeB      = wx.TextCtrl(self.panel, -1, "4", size = (35,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextTimeB, self.TextTimeB)
		TimesSize = wx.BoxSizer()
		TimesSize.Add(self.TextTimeA,       0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		TimesSize.Add(self.LabelTimeSlash,   0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		TimesSize.Add(self.TextTimeB,       0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		
		self.LabelPitch      = wx.StaticText(self.panel, -1,"pitch: ")
		self.TextPitch1      = wx.TextCtrl(self.panel, -1, "0",   size = (35,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextPitch1, self.TextPitch1)
		self.LabelPitchSlash = wx.StaticText(self.panel, -1," / ")
		self.TextPitch2      = wx.TextCtrl(self.panel, -1, "127", size = (35,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextPitch2, self.TextPitch2)
		PitchSize = wx.BoxSizer()
		PitchSize.Add(self.TextPitch1,      0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		PitchSize.Add(self.LabelPitchSlash, 0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		PitchSize.Add(self.TextPitch2,      0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 0)
		
		self.LabelMidi     = wx.StaticText(self.panel, -1,"midi: ")
		self.ChoiceMidi = wx.Choice(self.panel, -1, \
			choices = midiInstrument, size=(80,23))
		self.panel.Bind(wx.EVT_CHOICE, self.OnChoiceMidi, self.ChoiceMidi)
		
		FGSize.Add(self.LabelTimes,  0, wx.FIXED_MINSIZE)
		FGSize.Add(TimesSize,        0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPitch,  0, wx.FIXED_MINSIZE)
		FGSize.Add(PitchSize,        0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelMidi,   0, wx.FIXED_MINSIZE)
		FGSize.Add(self.ChoiceMidi,  0, wx.FIXED_MINSIZE)
		
		ButtonRefresh = wx.Button(self.panel, -1, "Refresh")
		self.panel.Bind(wx.EVT_BUTTON, self.OnRefresh, ButtonRefresh)
		
		LeftSize.Add(FGSize,1,wx.EXPAND | wx.ALL, 5)
		LeftSize.Add(ButtonRefresh,0,wx.EXPAND | wx.RIGHT | wx.BOTTOM | wx.LEFT, 5)
		
		self.Add(LeftSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		self.note = objConv(self.panel)
		self.Add(self.note, 1, wx.EXPAND | wx.RIGHT | wx.BOTTOM | wx.TOP , 5)

	def OnRefresh(self, e = None):
		if self.obj <> None:
			self.SetObj(self.obj)
			# make new voice by obj's preferences -> conv.score.py
			makeObjVoice(self.obj, self.length)
			self.ImageRefresh()
	def OnTextTimeA(self, e):
		if self.TextTimeA.GetValue()!="":
			i = int(self.TextTimeA.GetValue())
			self.r.times[0] = i
	def OnTextTimeB(self, e):
		if self.TextTimeB.GetValue()!="":
			i = int(self.TextTimeB.GetValue())
			self.r.times[1] = i
	def OnTextPitch1(self, e):
		if self.TextPitch1.GetValue()!="":
			i = int(self.TextPitch1.GetValue())
			if i > 127: i = 127
			if i < 0:   i = 0
			self.r.pitch[0] = i
	def OnTextPitch2(self, e):
		if self.TextPitch2.GetValue()!="":
			i = int(self.TextPitch2.GetValue())
			if i > 127: i = 127
			if i < 0:   i = 0
			self.r.pitch[1] = i
	def OnChoiceMidi(self, e):
		self.r.midi = self.ChoiceMidi.GetSelection()
	def SetValueObj(self, obj):
		### [length, pitch, midi, noteNumber, [note's properties]]
		if len(self.obj.preferences) < 5:
			while len(self.obj.preferences) < 5:
				self.obj.preferences.append(None)
		self.obj.preferences[0] = self.r.times
		self.obj.preferences[1] = self.r.pitch
		self.obj.preferences[2] = self.r.midi
	def SetObj(self, obj):
		if self.obj <> None:
			self.SetValueObj(self.obj)
		self.obj = obj
		# 
		self.InitObj()
		self.r = get_obj_preferences(self.obj)
		self.SetUI()
		self.note.SetObj(obj)
		self.ImageRefresh()
	def ImageRefresh(self):
		if self.obj <> None:
			if self.obj.voice == None:
				if   isinstance(self.obj, objImage):
					self.vpanel.SetObj(self.obj.image)
				elif isinstance(self.obj, objFilter):
					self.vpanel.SetObj(self.obj.dataoutput)
			else:
				self.vpanel.SetObj(self.obj.voice.grid)
	def SetUI(self):
		self.TextTimeA.SetValue(str(self.r.times[0]))
		self.TextTimeB.SetValue(str(self.r.times[1]))
		self.TextPitch1.SetValue(str(self.r.pitch[0]))
		self.TextPitch2.SetValue(str(self.r.pitch[1]))
		self.ChoiceMidi.SetSelection(self.r.midi)
	def InitObj(self):	# objPreferences is base
		if len(self.obj.preferences) < 5:
			while len(self.obj.preferences) < 5:
				self.obj.preferences.append(0)
			tmp_r = get_obj_preferences()
			self.obj.preferences[0] = tmp_r.times
			self.obj.preferences[1] = tmp_r.pitch
			self.obj.preferences[2] = tmp_r.midi
			self.obj.preferences[3] = 0
			self.obj.preferences[4] = tmp_r.noteppt
		
class PanelRGBColor(wx.Panel):
	def __init__(self, parent):
		wx.Panel.__init__(self, parent, -1)
		self.gui()
		self.obj = None
	def gui(self):
		FGSize = wx.FlexGridSizer(3,11,0,0)
		TopSize = wx.BoxSizer(wx.VERTICAL)
		
		CSize = wx.BoxSizer()
		self.LabelC  = wx.StaticText(self, -1,"c = ")
		self.ChoiceC = wx.Choice(self, -1, choices = Clist)
		self.ChoiceC.Enable(False)
		CSize.Add(self.LabelC,  0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 0)
		CSize.Add(self.ChoiceC, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 0)
		self.Bind(wx.EVT_CHOICE, self.OnChoiceC, self.ChoiceC)
		
		self.LabelT  = wx.StaticText(self, -1,"t = ")
		self.TextTX   = wx.TextCtrl(self, -1, "1",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTX, self.TextTX)
		self.LabelTX  = wx.StaticText(self, -1,"x + ")
		self.TextTY   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTY, self.TextTY)
		self.LabelTY  = wx.StaticText(self, -1,"y + ")
		self.TextTR   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTR, self.TextTR)
		self.LabelTR  = wx.StaticText(self, -1,"r + ")
		self.TextTG   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTG, self.TextTG)
		self.LabelTG  = wx.StaticText(self, -1,"g + ")
		self.TextTB   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTB, self.TextTB)
		self.LabelTB  = wx.StaticText(self, -1,"b")
		
		self.LabelP  = wx.StaticText(self, -1,"p = ")
		self.TextPX   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPX, self.TextPX)
		self.LabelPX  = wx.StaticText(self, -1,"x + ")
		self.TextPY   = wx.TextCtrl(self, -1, "1",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPY, self.TextPY)
		self.LabelPY  = wx.StaticText(self, -1,"y + ")
		self.TextPR   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPR, self.TextPR)
		self.LabelPR  = wx.StaticText(self, -1,"r + ")
		self.TextPG   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPG, self.TextPG)
		self.LabelPG  = wx.StaticText(self, -1,"g + ")
		self.TextPB   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPB, self.TextPB)
		self.LabelPB  = wx.StaticText(self, -1,"b")
		
		self.LabelD  = wx.StaticText(self, -1,"d = ")
		self.TextDX   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDX, self.TextDX)
		self.LabelDX  = wx.StaticText(self, -1,"x + ")
		self.TextDY   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDY, self.TextDY)
		self.LabelDY  = wx.StaticText(self, -1,"y + ")
		self.TextDR   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDR, self.TextDR)
		self.LabelDR  = wx.StaticText(self, -1,"r + ")
		self.TextDG   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDG, self.TextDG)
		self.LabelDG  = wx.StaticText(self, -1,"g + ")
		self.TextDB   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDB, self.TextDB)
		self.LabelDB  = wx.StaticText(self, -1,"b")

		FGSize.Add(self.LabelT,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTR,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTR,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTG,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTB,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTB,    0, wx.FIXED_MINSIZE)

		FGSize.Add(self.LabelP,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPR,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPR,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPG,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPB,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPB,    0, wx.FIXED_MINSIZE)
		
		FGSize.Add(self.LabelD,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDR,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDR,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDG,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDB,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDB,    0, wx.FIXED_MINSIZE)
				
		TopSize.Add(CSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		TopSize.Add(FGSize,0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		
		self.SetSizer(TopSize)
	def OnTextTX(self, e):
		if self.TextTX.GetValue()!="":
			i = float(self.TextTX.GetValue())
			self.obj.preferences[4][1] = i
	def OnTextTY(self, e):
		if self.TextTY.GetValue()!="":
			i = float(self.TextTY.GetValue())
			self.obj.preferences[4][2] = i
	def OnTextTR(self, e):
		if self.TextTR.GetValue()!="":
			i = float(self.TextTR.GetValue())
			self.obj.preferences[4][3] = i
	def OnTextTG(self, e):
		if self.TextTG.GetValue()!="":
			i = float(self.TextTG.GetValue())
			self.obj.preferences[4][4] = i
	def OnTextTB(self, e):
		if self.TextTB.GetValue()!="":
			i = float(self.TextTB.GetValue())
			self.obj.preferences[4][5] = i
	def OnTextPX(self, e):
		if self.TextPX.GetValue()!="":
			i = float(self.TextPX.GetValue())
			self.obj.preferences[4][6] = i
	def OnTextPY(self, e):
		if self.TextPY.GetValue()!="":
			i = float(self.TextPY.GetValue())
			self.obj.preferences[4][7] = i
	def OnTextPR(self, e):
		if self.TextPR.GetValue()!="":
			i = float(self.TextPR.GetValue())
			self.obj.preferences[4][8] = i
	def OnTextPG(self, e):
		if self.TextPG.GetValue()!="":
			i = float(self.TextPG.GetValue())
			self.obj.preferences[4][9] = i
	def OnTextPB(self, e):
		if self.TextPB.GetValue()!="":
			i = float(self.TextPB.GetValue())
			self.obj.preferences[4][10] = i
	def OnTextDX(self, e):
		if self.TextDX.GetValue()!="":
			i = float(self.TextDX.GetValue())
			if len(self.obj.preferences[4]) == 16:
				self.obj.preferences[4][11] = i
			else:
				self.obj.preferences[4][0] = i
	def OnTextDY(self, e):
		if self.TextDY.GetValue()!="":
			i = float(self.TextDY.GetValue())
			if len(self.obj.preferences[4]) == 16:
				self.obj.preferences[4][12] = i
			else:
				self.obj.preferences[4][1] = i
	def OnTextDR(self, e):
		if self.TextDR.GetValue()!="":
			i = float(self.TextDR.GetValue())
			if len(self.obj.preferences[4]) == 16:
				self.obj.preferences[4][13] = i
			else:
				self.obj.preferences[4][2] = i
	def OnTextDG(self, e):
		if self.TextDG.GetValue()!="":
			i = float(self.TextDG.GetValue())
			if len(self.obj.preferences[4]) == 16:
				self.obj.preferences[4][14] = i
			else:
				self.obj.preferences[4][3] = i
	def OnTextDB(self, e):
		if self.TextDB.GetValue()!="":
			i = float(self.TextDB.GetValue())
			if len(self.obj.preferences[4]) == 16:
				self.obj.preferences[4][15] = i
			else:
				self.obj.preferences[4][4] = i
	def OnChoiceC(self, e):
		self.obj.preferences[4][0] = self.ChoiceC.GetSelection()
	def SetObj(self, obj):
		def lens(obj, count):
			if len(obj.preferences[4]) <> count:
				obj.preferences[4] = []
				for i in range(count):
					obj.preferences[4].append(0)
		
		self.obj = obj
		if isinstance(self.obj, objImage):
			lens(self.obj, 16)			# rgb-image : 16
			self.obj.preferences[4][1] = 1.0
			self.obj.preferences[4][7] = 1.0
			self.obj.preferences[4][13] = 0.33
			self.obj.preferences[4][14] = 0.33
			self.obj.preferences[4][15] = 0.33
		else:	
			if isinstance(self.obj.dataoutput, Image.Image):
				lens(self.obj, 16)		# rgb-image : 16
				self.obj.preferences[4][1] = 1.0
				self.obj.preferences[4][7] = 1.0
				self.obj.preferences[4][13] = 0.33
				self.obj.preferences[4][14] = 0.33
				self.obj.preferences[4][15] = 0.33
			else:
				lens(self.obj, 5)		# rgb-grid  : 5
				self.obj.preferences[4][2] = 0.33
				self.obj.preferences[4][3] = 0.33
				self.obj.preferences[4][4] = 0.33				
		self.SetUI()
	def SetUI(self):	# RGB
		if   len(self.obj.preferences[4]) == 16:
			self.ChoiceC.Enable(True)
			self.ChoiceC.SetSelection(self.obj.preferences[4][0])
			self.TextTX.Enable(True)
			self.TextTY.Enable(True)
			self.TextTR.Enable(True)
			self.TextTG.Enable(True)
			self.TextTB.Enable(True)
			self.TextPX.Enable(True)
			self.TextPY.Enable(True)
			self.TextPR.Enable(True)
			self.TextPG.Enable(True)
			self.TextPB.Enable(True)
			self.TextTX.SetValue(str(self.obj.preferences[4][1]))
			self.TextTY.SetValue(str(self.obj.preferences[4][2]))
			self.TextTR.SetValue(str(self.obj.preferences[4][3]))
			self.TextTG.SetValue(str(self.obj.preferences[4][4]))
			self.TextTB.SetValue(str(self.obj.preferences[4][5]))
			self.TextPX.SetValue(str(self.obj.preferences[4][6]))
			self.TextPY.SetValue(str(self.obj.preferences[4][7]))
			self.TextPR.SetValue(str(self.obj.preferences[4][8]))
			self.TextPG.SetValue(str(self.obj.preferences[4][9]))
			self.TextPB.SetValue(str(self.obj.preferences[4][10]))
			self.TextDX.SetValue(str(self.obj.preferences[4][11]))
			self.TextDY.SetValue(str(self.obj.preferences[4][12]))
			self.TextDR.SetValue(str(self.obj.preferences[4][13]))
			self.TextDG.SetValue(str(self.obj.preferences[4][14]))
			self.TextDB.SetValue(str(self.obj.preferences[4][15]))
		elif len(self.obj.preferences[4]) == 5:
			self.ChoiceC.Enable(False)
			self.TextTX.Enable(False)
			self.TextTY.Enable(False)
			self.TextTR.Enable(False)
			self.TextTG.Enable(False)
			self.TextTB.Enable(False)
			self.TextPX.Enable(False)
			self.TextPY.Enable(False)
			self.TextPR.Enable(False)
			self.TextPG.Enable(False)
			self.TextPB.Enable(False)
			self.TextDX.SetValue(str(self.obj.preferences[4][0]))
			self.TextDY.SetValue(str(self.obj.preferences[4][1]))
			self.TextDR.SetValue(str(self.obj.preferences[4][2]))
			self.TextDG.SetValue(str(self.obj.preferences[4][3]))
			self.TextDB.SetValue(str(self.obj.preferences[4][4]))
		
class PanelGreyColor(wx.Panel):
	def __init__(self, parent):
		wx.Panel.__init__(self, parent, -1)
		self.gui()
	def gui(self):
		FGSize = wx.FlexGridSizer(3,7,0,0)
		TopSize = wx.BoxSizer(wx.VERTICAL)
		
		CSize = wx.BoxSizer()
		self.LabelC  = wx.StaticText(self, -1,"c = ")
		self.ChoiceC = wx.Choice(self, -1, choices = Clist)
		self.ChoiceC.Enable(False)
		CSize.Add(self.LabelC,  0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 0)
		CSize.Add(self.ChoiceC, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 0)
		self.Bind(wx.EVT_CHOICE, self.OnChoiceC, self.ChoiceC)
		
		self.LabelT  = wx.StaticText(self, -1,"t = ")
		self.TextTX   = wx.TextCtrl(self, -1, "1",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTX, self.TextTX)
		self.LabelTX  = wx.StaticText(self, -1,"x + ")
		self.TextTY   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTY, self.TextTY)
		self.LabelTY  = wx.StaticText(self, -1,"y + ")
		self.TextTG   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextTG, self.TextTG)
		self.LabelTG  = wx.StaticText(self, -1,"g")
		
		self.LabelP  = wx.StaticText(self, -1,"p = ")
		self.TextPX   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPX, self.TextPX)
		self.LabelPX  = wx.StaticText(self, -1,"x + ")
		self.TextPY   = wx.TextCtrl(self, -1, "1",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPY, self.TextPY)
		self.LabelPY  = wx.StaticText(self, -1,"y + ")
		self.TextPG   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextPG, self.TextPG)
		self.LabelPG  = wx.StaticText(self, -1,"g")
		
		self.LabelD  = wx.StaticText(self, -1,"d = ")
		self.TextDX   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDX, self.TextDX)
		self.LabelDX  = wx.StaticText(self, -1,"x + ")
		self.TextDY   = wx.TextCtrl(self, -1, "0",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDY, self.TextDY)
		self.LabelDY  = wx.StaticText(self, -1,"y + ")
		self.TextDG   = wx.TextCtrl(self, -1, "1",   size = (35,23))
		self.Bind(wx.EVT_TEXT, self.OnTextDG, self.TextDG)
		self.LabelDG  = wx.StaticText(self, -1,"g")
		
		FGSize.Add(self.LabelT,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextTG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelTG,    0, wx.FIXED_MINSIZE)

		FGSize.Add(self.LabelP,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextPG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelPG,    0, wx.FIXED_MINSIZE)
		
		FGSize.Add(self.LabelD,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDX,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDX,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDY,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDY,    0, wx.FIXED_MINSIZE)
		FGSize.Add(self.TextDG,     0, wx.FIXED_MINSIZE)
		FGSize.Add(self.LabelDG,    0, wx.FIXED_MINSIZE)
				
		TopSize.Add(CSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		TopSize.Add(FGSize,0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		
		self.SetSizer(TopSize)	
	def OnTextTX(self, e):
		if self.TextTX.GetValue()!="":
			i = float(self.TextTX.GetValue())
			self.obj.preferences[4][1] = i
	def OnTextTY(self, e):
		if self.TextTY.GetValue()!="":
			i = float(self.TextTY.GetValue())
			self.obj.preferences[4][2] = i
	def OnTextTG(self, e):
		if self.TextTG.GetValue()!="":
			i = float(self.TextTG.GetValue())
			self.obj.preferences[4][3] = i
	def OnTextPX(self, e):
		if self.TextPX.GetValue()!="":
			i = float(self.TextPX.GetValue())
			self.obj.preferences[4][4] = i
	def OnTextPY(self, e):
		if self.TextPY.GetValue()!="":
			i = float(self.TextPY.GetValue())
			self.obj.preferences[4][5] = i
	def OnTextPG(self, e):
		if self.TextPG.GetValue()!="":
			i = float(self.TextPG.GetValue())
			self.obj.preferences[4][6] = i
	def OnTextDX(self, e):
		if self.TextDX.GetValue()!="":
			i = float(self.TextDX.GetValue())
			if len(self.obj.preferences[4]) == 10:
				self.obj.preferences[4][7] = i
			else:
				self.obj.preferences[4][0] = i
	def OnTextDY(self, e):
		if self.TextDY.GetValue()!="":
			i = float(self.TextDY.GetValue())
			if len(self.obj.preferences[4]) == 10:
				self.obj.preferences[4][8] = i
			else:
				self.obj.preferences[4][1] = i
	def OnTextDG(self, e):
		if self.TextDG.GetValue()!="":
			i = float(self.TextDG.GetValue())
			if len(self.obj.preferences[4]) == 10:
				self.obj.preferences[4][9] = i
			else:
				self.obj.preferences[4][2] = i
	def OnChoiceC(self, e):
		self.obj.preferences[4][0] = self.ChoiceC.GetSelection()
	def SetObj(self, obj):
		def lens(obj, count):
			if len(obj.preferences[4]) <> count:
				obj.preferences[4] = []
				for i in range(count):
					obj.preferences[4].append(0)
		
		self.obj = obj
		if isinstance(self.obj, objImage):
			lens(self.obj, 10)			# grey-image : 10
			self.obj.preferences[4][1] = 1.0
			self.obj.preferences[4][5] = 1.0
			self.obj.preferences[4][9] = 1.0
		else:	
			if isinstance(self.obj.dataoutput, Image.Image):
				lens(self.obj, 10)		# grey-image : 10
				self.obj.preferences[4][1] = 1.0
				self.obj.preferences[4][5] = 1.0
				self.obj.preferences[4][9] = 1.0
			else:
				lens(self.obj, 3)		# grey-grid  : 3
				self.obj.preferences[4][2] = 1.0
		self.SetUI()
	def SetUI(self):	# RGB
		if   len(self.obj.preferences[4]) == 10:
			self.ChoiceC.Enable(True)
			self.ChoiceC.SetSelection(self.obj.preferences[4][0])
			self.TextTX.Enable(True)
			self.TextTY.Enable(True)
			self.TextTG.Enable(True)
			self.TextPX.Enable(True)
			self.TextPY.Enable(True)
			self.TextPG.Enable(True)
			self.TextTX.SetValue(str(self.obj.preferences[4][1]))
			self.TextTY.SetValue(str(self.obj.preferences[4][2]))
			self.TextTG.SetValue(str(self.obj.preferences[4][3]))
			self.TextPX.SetValue(str(self.obj.preferences[4][4]))
			self.TextPY.SetValue(str(self.obj.preferences[4][5]))
			self.TextPG.SetValue(str(self.obj.preferences[4][6]))
			self.TextDX.SetValue(str(self.obj.preferences[4][7]))
			self.TextDY.SetValue(str(self.obj.preferences[4][8]))
			self.TextDG.SetValue(str(self.obj.preferences[4][9]))
		elif len(self.obj.preferences[4]) == 3:
			self.ChoiceC.Enable(False)
			self.TextTX.Enable(False)
			self.TextTY.Enable(False)
			self.TextTG.Enable(False)
			self.TextPX.Enable(False)
			self.TextPY.Enable(False)
			self.TextPG.Enable(False)
			self.TextDX.SetValue(str(self.obj.preferences[4][0]))
			self.TextDY.SetValue(str(self.obj.preferences[4][1]))
			self.TextDG.SetValue(str(self.obj.preferences[4][2]))
		
class objConv(wx.Choicebook):
	def __init__(self, parent):
		wx.Choicebook.__init__(self, parent, -1)
		self.parent = parent
		
		self.pGC = PanelGreyColor(self)
		self.AddPage(self.pGC, 'Grey Color')
		self.pRC = PanelRGBColor(self)
		self.AddPage(self.pRC, 'RGB Color')
		
		self.obj = None
		
		self.Bind(wx.EVT_CHOICEBOOK_PAGE_CHANGED, self.OnPageChanged)
	def OnPageChanged(self, e):
		self.SetObj(self.obj)
		
	def SetObj(self, obj):
		if self.obj <> None:
			self.obj.preferences[3] = self.GetSelection()
		if obj <> None:
			self.obj = obj
			if len(self.obj.preferences) == 5:
				self.SetSelection(self.obj.preferences[3])
			else:
				self.SetSelection(0)
			if self.GetSelection() == 0:
				self.pGC.SetObj(self.obj)
			else:
				self.pRC.SetObj(self.obj)
			
		
class scoreUI:
	def __init__(self,panel,obj):
		self.panel = panel
		self.obj = obj
		
		self.score = score()
		
		# UI's variables
		self.p = get_properties_score(self.obj)
		
		getInput(self.obj,self.panel.frame)
		
		if len(self.obj.datainput) < 1:
			self.panel.frame.Close(True)
		else:
			self.getObj()
			self.gui()
			
	def getObj(self):
		self.listObj = []
		l = len(self.obj.datainput)
		for i in range(1,l + 1):
			self.listObj.append(str(i))
	def gui(self):	# make panel
		self.panel.frame.SetSize((600,380))
		
		# Top
		TopSize = wx.BoxSizer()
		
		# -- Top1 (ListBox)
		self.List      = wx.ListBox(self.panel, 100, (100,50),(90,20), self.listObj, wx.LB_SINGLE)
		self.panel.Bind(wx.EVT_LISTBOX, self.OnList, self.List)
		
		# Middle (ViewPanel)
		self.vpanel = ViewPanel(self.panel)

		# -- Top2 (Preferences)
		box1           = wx.StaticBox(self.panel,-1, "Preferences")
		self.pref      = objPreferences(box1, self.panel, self.vpanel)
		self.pref.SetLength(self.p.length)

		TopSize.Add(self.List,    0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		TopSize.Add(self.pref, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		
		
		# Bottom
		BottomSize = wx.BoxSizer()
		
		self.LabelLength   = wx.StaticText(self.panel, -1," Length: ")
		self.TextLength    = wx.TextCtrl(self.panel, -1, "42", size = (34,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextLength, self.TextLength)
		self.LabelTempo   = wx.StaticText(self.panel, -1," Tempo: ")
		self.TextTempo    = wx.TextCtrl(self.panel, -1, "42", size = (34,23))
		self.panel.Bind(wx.EVT_TEXT, self.OnTextTempo, self.TextTempo)
		
		self.CheckMidi = wx.CheckBox(self.panel,-1,"Midi")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckMidi, self.CheckMidi)
		self.CheckLayout = wx.CheckBox(self.panel,-1,"Layout")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckLayout, self.CheckLayout)
		self.CheckAbc = wx.CheckBox(self.panel,-1,"abc")
		self.panel.Bind(wx.EVT_CHECKBOX, self.OnCheckAbc, self.CheckAbc)
		self.CheckAbc.Enable(False)
		ButtonScore = wx.Button(self.panel, -1, "Write score")
		self.panel.Bind(wx.EVT_BUTTON, self.OnWriteScore, ButtonScore)
		ButtonClose = wx.Button(self.panel, -1, "Close")
		self.panel.Bind(wx.EVT_BUTTON, self.OnCloseMe, ButtonClose)
		
		BottomSize.Add(self.LabelLength,   0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 5)
		BottomSize.Add(self.TextLength,    0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 5)
		BottomSize.Add(self.LabelTempo,    0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 5)
		BottomSize.Add(self.TextTempo,     0,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 5)
		BottomSize.Add(wx.DefaultSize,     1,wx.FIXED_MINSIZE | wx.LEFT | wx.TOP, 5)
		
		BottomSize.Add(self.CheckMidi, 0, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		BottomSize.Add(self.CheckLayout, 0, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		BottomSize.Add(self.CheckAbc, 0, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		BottomSize.Add(wx.DefaultSize, 1, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		BottomSize.Add(ButtonScore, 0, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		BottomSize.Add(ButtonClose, 0, wx.FIXED_MINSIZE | wx.LEFT | wx.RIGHT | wx.TOP , 5)
		
		# Main
		MainSize = wx.BoxSizer(wx.VERTICAL)
		
		MainSize.Add(TopSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 5)
		MainSize.Add(self.vpanel, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 10)
		MainSize.Add(BottomSize, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.BOTTOM, 5)
		
		self.panel.SetSizer(MainSize)
		self.panel.SetAutoLayout(True)
		
		# Set UI's Value
		self.SetValueUI()
		
	def OnCheckLayout(self, e):
		if self.CheckLayout.IsChecked() == True:
			if self.p.selectConv.count(0) == 0:
				self.p.selectConv.append(0)
		else:
			if self.p.selectConv.count(0) == 1:
				self.p.selectConv.remove(0)
	def OnCheckMidi(self, e):
		if self.CheckMidi.IsChecked() == True:
			if self.p.selectConv.count(1) == 0:
				self.p.selectConv.append(1)
		else:
			if self.p.selectConv.count(1) == 1:
				self.p.selectConv.remove(1)
	def OnCheckAbc(self, e):
		if self.CheckAbc.IsChecked() == True:
			if self.p.selectConv.count(2) == 0:
				self.p.selectConv.append(2)
		else:
			if self.p.selectConv.count(2) == 1:
				self.p.selectConv.remove(2)
		
	def OnList(self, e):
		self.p.selectObj = self.List.GetSelection()
		self.pref.SetObj(self.obj.input[self.p.selectObj])
	def OnTextLength(self, e):
		if self.TextLength.GetValue()!="":
			i = int(self.TextLength.GetValue())
			self.p.length = i
			self.pref.SetLength(self.p.length)
	def OnTextTempo(self, e):
		if self.TextTempo.GetValue()!="":
			i = int(self.TextTempo.GetValue())
			self.p.tempo = i
	def OnWriteScore(self, e):
		# make score - set objs' voice 
		self.score = score()
		for i in range(len(self.obj.input)):
			self.List.SetSelection(i)
			self.OnList(None)
			if i == 0: 
				maintimes = self.obj.input[0].preferences[0]
				self.p.length = \
					maintimes[0] * (int(self.p.length / maintimes[0]))
			makeObjVoice(self.obj.input[i], self.p.length, maintimes)
			self.score.AppendVoice(self.obj.input[i].voice)	
		self.score.SetLength(self.p.length)
		self.score.SetTempo(self.p.tempo)
		self.score.SetConv(self.p.selectConv)
		
		# save dialog 
		dlg = wx.FileDialog( 
			self.panel.frame, message="Save file as ...", defaultDir=os.getcwd(),
			defaultFile = "output.ly", 
			wildcard = "LilyPond file (*.ly)|*.ly", style=wx.SAVE)
		if dlg.ShowModal() == wx.ID_OK:
			self.score.SetFileN(dlg.GetPath())
		
		convert_score(self.score)
		if not(self.p.selectObj == None or len(self.obj.input) < 1):
			self.pref.SetObj(self.obj.input[self.p.selectObj])
	def SetValueUI(self):
		if not(self.p.selectObj == None or len(self.obj.input) < 1):
			self.List.SetSelection(self.p.selectObj)
			self.OnList(None)
		self.TextTempo.SetValue(str(self.p.tempo))
		self.TextLength.SetValue(str(self.p.length))
		
		if self.p.selectConv.count(0) == 1:
			self.CheckLayout.SetValue(True)
		if self.p.selectConv.count(1) == 1:
			self.CheckMidi.SetValue(True)
		if self.p.selectConv.count(2) == 1:
			self.CheckAbc.SetValue(True)
			self.CheckAbc.Enable(False)
	def SetValueObj(self):		
		self.obj.properties = \
			['score', \
			 self.p.selectObj, \
			 self.p.filename, \
			 self.p.tempo, \
			 self.p.length,
			 self.p.selectConv]
		if not(self.p.selectObj == None or len(self.obj.input) < 1):
			self.pref.SetObj(self.obj.input[self.p.selectObj])
	def OnCloseMe(self,e):
		# make shape's bitmap
		self.SetValueObj()
		self.obj.PreviewBitmap()
		setOutput(self.obj,self.panel.frame)
		# dismiss
		self.panel.frame.Close(True)