### /obj/objImage.py

import wx
import wx.lib.ogl as ogl
from gui.imageimport import *

class objImage(ogl.BitmapShape):
	def __init__(self,x=0,y=0,shapew=0,shapeh=0,text="", \
				 image=None,output=[],properties=[],editcount = 0,name = ""):
		ogl.BitmapShape.__init__(self)
		self.SetX(x)
		self.SetY(y)
		
		self.name = name
		
		self.edit_text(text)
		
		self.voice = None
		
		self.image = image
		self.output = output
		
		# make image if none
		if image==None:
			bmp = wx.EmptyBitmap(96,96) #self.shapesize)
			bmpDC = wx.MemoryDC()
			bmpDC.SelectObject(bmp)
			bmpDC.Clear()
			image = bmp.ConvertToImage()
			self.image = Image.new('RGB',(image.GetWidth(),image.GetHeight()))
			self.image.fromstring(image.GetData())
			self.edit_text('image')
		
		self.w = self.image.size[0]
		self.h = self.image.size[1]
		self.shapew = shapew
		self.shapeh = shapeh
		
		self.properties  = properties
		self.preferences = []
		
		self.flgdialog = 0	# 0 -> Off, 1 -> On
		
		self.PreviewBitmap()
	def edit_image(self,image):
		self.image = image
		self.w = self.image.size[0]
		self.h = self.image.size[1]
		self.PreviewBitmap()
	def edit_text(self,text):
		self.ClearText()
		self.text = text
		self.AddText(text)
	def PreviewBitmap(self):
		# draw shape bitmap
		self.edit_text('')
		pilbmp = self.image.copy()
		if pilbmp.size[0] < self.shapew:
			if pilbmp.size[1] < self.shapeh:
				if pilbmp.size[0] > pilbmp.size[1]:
					ratio = (pilbmp.size[1] + 0.0) / pilbmp.size[0]	# float
					pilbmp = pilbmp.resize((self.shapew,int(self.shapeh * ratio)))
				else:
					ratio = (pilbmp.size[0] + 0.0) / pilbmp.size[1]	# float
					pilbmp = pilbmp.resize((int(self.shapew * ratio),self.shapeh))
			else:
				pilbmp.thumbnail((self.shapew,self.shapeh),Image.ANTIALIAS)
		else:
			pilbmp.thumbnail((self.shapew,self.shapeh),Image.ANTIALIAS)
			
		wxbmp = wx.EmptyImage(pilbmp.size[0], pilbmp.size[1])
		wxbmp.SetData(pilbmp.convert('RGB').tostring())
		
		self.SetBitmap(wxbmp.ConvertToBitmap())
		