/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class FileMappedOutputStream {
    private final MappedByteBuffer mbb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMappedOutputStream(String string, int n) throws IOException {
        new File(string).delete();
        FileChannel fileChannel = new RandomAccessFile(string, "rw").getChannel();
        try {
            this.mbb = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
            this.mbb.order(ByteOrder.nativeOrder());
        }
        finally {
            fileChannel.close();
        }
    }

    public void putInt(int n) throws IOException {
        this.mbb.putInt(n);
    }

    public void putShort(short s) throws IOException {
        this.mbb.putShort(s);
    }

    public void putChar(char c) throws IOException {
        this.mbb.putChar(c);
    }

    public void putString(String string) throws IOException {
        this.mbb.asCharBuffer().put(string);
        this.mbb.position(this.mbb.position() + string.length() * 2);
    }

    public void close() {
        this.mbb.force();
    }
}

