/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.bin;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.reduls.igo.dictionary.CharCategory;
import net.reduls.igo.dictionary.Matrix;
import net.reduls.igo.dictionary.WordDic;

public final class BuildDic {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: java net.reduls.igo.bin.BuildDic <output directory> <input directory> <encoding>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        new File(string).mkdirs();
        try {
            System.err.println("### Build word trie");
            WordDic.genWordIdMap(string2, string, string3);
            System.err.println("### Build word dictionary");
            WordDic.genWordInfo(string2, string, string3);
            System.err.println("### Build matrix");
            Matrix.build(string2, string);
            System.err.println("### Build char-category dictionary");
            CharCategory.build(string2, string, string3);
            System.err.println("DONE");
        }
        catch (ParseException parseException) {
            System.err.println("[PARSE ERROR] " + parseException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("[ERROR] " + iOException.getMessage());
            System.exit(1);
        }
    }
}

