<?php
// $Id: class_import.php 10215 2006-11-27 13:57:17Z pcool $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Bart Mollet, Hogeschool Gent

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*   This     tool allows platform admins to add classes by uploading a CSV file
* @todo Add some langvars to DLTT
*	@package iilearn.admin
==============================================================================
*/
// name of the language file that needs to be included 
$language_file = array ('admin', 'registration');

// resetting the course id
$cidReset = true;

// including some necessary dokeos files
include ('../inc/global.inc.php');
require_once (api_get_path(LIBRARY_PATH).'fileManage.lib.php');
require_once (api_get_path(LIBRARY_PATH).'classmanager.lib.php');
require_once (api_get_path(LIBRARY_PATH).'import.lib.php');
require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');

api_protect_admin_script();

/**
 * Validate the imported data
 */
function validate_data($classes)
{
	$errors = array();
	foreach($classes as $index => $class)
	{
		//1. Check if ClassName is available
		if(!isset($class['ClassName']) || strlen(trim($class['ClassName'])) == 0)
		{
			$class['line'] = $index+2;
			$class['error'] = get_lang('MissingClassName');
			$errors[] = $class;
		}	
		//2. Check if class doesn't exist yet
		else
		{
			if(ClassManager::class_name_exists($class['ClassName']))
			{
				$class['line'] = $index+2;
				$class['error'] = get_lang('ClassNameExists');
				$errors[] = $class;					
			}	
		}
	}
	return $errors;
}
/**
 * Save imported class data to database
 */
function save_data($classes)
{
	$number_of_added_classes = 0;
	foreach($classes as $index => $class)
	{
		if(ClassManager::create_class($class['ClassName']))
		{
			$number_of_added_classes++;	
		}	
	}
	return $number_of_added_classes;
}

/**
 * Read the CSV-file
 * @param string $file Path to the CSV-file
 * @return array All course-information read from the file
 */
function parse_csv_data($file)
{
	$classes = Import :: csv_to_array($file);
	foreach ($classes as $index => $class)
	{
		$class['ClassName'] = mb_convert_encoding($class['ClassName'], SYSTEM_CHARSET, $_POST['import_encoding']);

		$classes[$index] = $class;
	}

	return $classes;
}

function doAction()
{
	if ($_FILES['import_file']['size'] !== 0)
	{
		set_time_limit(0);

		$file_type = $_POST['file_type'];
		if ($file_type == 'csv')
		{
			$classes = parse_csv_data($_FILES['import_file']['tmp_name']);
		}
		my_delete($_FILES['import_file']['tmp_name']);

		$errors = validate_data($classes);
		if (count($errors) == 0)
		{
			save_data($classes);
			header('Location: class_list.php?action=show_message&message='.urlencode(get_lang('FileImported')));
			exit ();
		}
		
		return $errors;
	}
}

$form = new FormValidator('import_classes');

$form->addElement('header', 'header', get_lang('ImportClassListCSV'));

$form->addElement('file','import_file',get_lang('ImportFileLocation'),  array('size'=>'45'));
$form->addRule('import_file', get_lang('ThisFieldIsRequired'), 'required');
$allowed_file_types = array ('csv');
$form->addRule('import_file', get_lang('InvalidExtension').' ('.implode(',', $allowed_file_types).')', 'filetype', $allowed_file_types);

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$form->addGroup($group,'file_type',get_lang('FileType'),null,false);

$encodings = get_encodings();
$form->addElement('select', 'import_encoding', get_lang('ImportEncoding'), $encodings);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$defaults['import_encoding'] = get_default_encoding();
$defaults['file_type'] = 'csv';
$form->setDefaults($defaults);

if( $form->validate())
{
	$errors = doAction();
}

$this_section = SECTION_PLATFORM_ADMIN;
$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));
$tool_name = get_lang('ImportClassListCSV');
$htmlHeadXtra[] =
"<script type='text/javascript'>
function display_example(id)
{
	if (id == 'cvs')
	{
		document.getElementById('cvs').style.display = 'block';
	}
}
</script>";

Display :: display_header($tool_name);

if (count($errors) != 0)
{
	//$error_message = get_lang('ErrorsWhenImportingFile');
	$error_message = '<ul>';
	foreach ($errors as $index => $error_class)
	{
		$error_message .= '<li>' . get_lang('Line') . ' ' . $error_class['line'] . ' : <b>' . $error_class['error'] . '</b>';
		$error_message .= '</li>';
	}
	$error_message .= '</ul>';
	//$error_message .= get_lang('NoClassesHaveBeenCreated');
	Display :: display_error_message($error_message, false);
}

Display::setTemplateBorder($form, '60%');
$form->display();

echo "<br>";

$temp = 'storage/examples/import_files/example_class_' . strtolower(get_default_encoding()) . '.csv';
if (is_file(api_get_path(SYS_PATH).$temp))
{
	$url_csv = api_get_path(WEB_PATH) . $temp;
}
else 
{
	$url_csv = api_get_path(WEB_PATH) . 'storage/examples/import_files/example_class.csv';
}
$html = "<a href='#' onclick=\"display_example('cvs');\">" . get_lang('ExampleCSVFile') . "</a>&nbsp;(<a href='" . $url_csv . "' target='_blank'>" . get_lang('Download') . "</a>)&nbsp;&nbsp;&nbsp;&nbsp;";

?>

<table align="center" width="60%">
<tr><td><?php echo $html; ?><br><br></td></tr>
<tr><td>
<div id="cvs" style="display:none">
<p><?php echo get_lang('CSVMustLookLike').' ('.get_lang('MandatoryFields').')'; ?> :</p>
<blockquote>
 <pre>
  <b>ClassName</b>
  <b>1A</b>
 </pre>
</blockquote>
</div>
</td></tr>
</table>

<?php
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>