<?php
// $Id: class_list.php 10926 2007-01-26 14:34:47Z elixir_julian $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.admin
==============================================================================
*/

// name of the language file that needs to be included 
$language_file = 'admin';
$cidReset = true;
require ('../inc/global.inc.php');
$this_section = SECTION_PLATFORM_ADMIN;

/**
 * Gets the total number of classes
 */
function get_number_of_classes()
{
	$tbl_class = Database :: get_main_table(TABLE_MAIN_CLASS);
	$sql = "SELECT COUNT(*) AS number_of_classes FROM $tbl_class";
	if (isset ($_GET['keyword']))
	{
		$sql .= " WHERE (name LIKE '%".Database::escape_string(trim($_GET['keyword']))."%')";
	}
	$res = api_sql_query($sql, __FILE__, __LINE__);
	$obj = mysql_fetch_object($res);
	return $obj->number_of_classes;
}
/**
 * Gets the information about some classes
 * @param int $from
 * @param int $number_of_items
 * @param string $direction
 */
function get_class_data($from, $number_of_items, $column, $direction)
{
	$tbl_class_user = Database :: get_main_table(TABLE_MAIN_CLASS_USER);
	$tbl_class_course = Database :: get_main_table(TABLE_MAIN_COURSE_CLASS);
	$tbl_class = Database :: get_main_table(TABLE_MAIN_CLASS);
/*	
	$sql = "SELECT 	id AS col0,
							name AS col1,
							COUNT(user_id) AS col2,
							COUNT(course_code) AS col3,
							id AS col4 
						FROM $tbl_class 
					LEFT JOIN $tbl_class_user ON id=$tbl_class_user.class_id 
					LEFT JOIN $tbl_class_course ON id=$tbl_class_course.class_id ";
*/
	$sql = "SELECT 	c.id AS col0, c.name AS col1,
					(SELECT COUNT(user_id) FROM $tbl_class_user cu WHERE cu.class_id=c.id) AS col2,
					(SELECT COUNT(course_code) FROM $tbl_class_course cc WHERE cc.class_id=c.id) AS col3,
					id AS col4 
					FROM $tbl_class c ";
	if (isset ($_GET['keyword']))
	{
		$sql .= " WHERE (name LIKE '%".Database::escape_string(trim($_GET['keyword']))."%')";
	}
	//$sql .= "GROUP BY id,name ORDER BY col$column $direction LIMIT $from,$number_of_items";
	$sql .= " ORDER BY col$column $direction LIMIT $from,$number_of_items";
	$res = api_sql_query($sql, __FILE__, __LINE__);
	$classes = array ();
	while ($class = mysql_fetch_row($res))
	{
		$classes[] = $class;
	}
	return $classes;
}
/**
 * Filter for sortable table to display edit icons for class
 */
function modify_filter($class_id)
{
	$result = '<a href="class_information.php?id=' . $class_id . '">' . Display::return_icon('synthese_view.gif', get_lang('Info'), array('style'=>'vertical-align: middle;')) . '</a>&nbsp;';
	$result .= '<a href="subscribe_user2class.php?idclass=' . $class_id . '">' . Display::return_icon('add_multiple_users.gif', get_lang('AddUsersToAClass'), array('style'=>'vertical-align: middle;')) . '</a>&nbsp;';
	$result .= '<a href="subscribe_course2class.php?idclass=' . $class_id . '">' . Display::return_icon('enroll.gif', get_lang('AddCoursesToClass'), array('style'=>'vertical-align: middle;')) . '</a>';
	$result .= '<a href="class_edit.php?idclass=' . $class_id . '">' . Display::return_icon('edit.gif', get_lang('Edit'), array('style'=>'vertical-align: middle;')) . '</a>&nbsp;';
	$result .= '<a href="class_list.php?action=delete_class&amp;class_id=' . $class_id . '" onclick="javascript:if(!confirm(' . "'" . addslashes(htmlentities(get_lang("ConfirmYourChoice"), ENT_NOQUOTES, SYSTEM_CHARSET)) . "'" . ')) return false;">' . Display::return_icon('delete.gif', get_lang('Delete'), array('style'=>'vertical-align: middle;')) . '</a>&nbsp;';
	return $result;
}

api_protect_admin_script();
require (api_get_path(LIBRARY_PATH).'fileManage.lib.php');
require (api_get_path(LIBRARY_PATH).'classmanager.lib.php');
require_once (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');
$tool_name = get_lang('ClassList');
$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));
$htmlHeadXtra[] = get_table_style_ie6();

Display :: display_header($tool_name);

if (isset ($_POST['action']))
{
	switch ($_POST['action'])
	{
		// Delete selected classes
		case 'delete_classes' :
			$classes = $_POST['class'];
			if (count($classes) > 0)
			{
				foreach ($classes as $index => $class_id)
				{
					ClassManager :: delete_class($class_id);
				}
				Display :: display_normal_message(get_lang('ClassesDeleted'));
			}
			break;
	}
}
if (isset ($_GET['action']))
{
	switch ($_GET['action'])
	{
		case 'delete_class' :
			ClassManager :: delete_class($_GET['class_id']);
			Display :: display_normal_message(get_lang('ClassDeleted'));
			break;
		case 'show_message' :
			Display :: display_normal_message(stripslashes($_GET['message']));
			break;
	}
}
// Create a search-box
$form = new FormValidator('search_simple','get','','',null,false);
$renderer = $form->defaultRenderer();
$renderer->setElementTemplate('<span>{element}</span> ');
$form->addElement('text','keyword',get_lang('keyword'));
$form->addElement('submit','submit',get_lang('Search'),'class="inputSubmit"');
$form->display();

// Create the sortable table with class information
$table = new SortableTable('classes', 'get_number_of_classes', 'get_class_data', 1, NUMBER_PAGE);
$table->set_additional_parameters(array('keyword'=>$_GET['keyword']));
$table->set_header(0, '', false);
$table->set_header(1, get_lang('ClassName'));
$table->set_header(2, get_lang('NumberOfUsers'));
$table->set_header(3, get_lang('NumberOfCourses'));
$table->set_header(4, '', false);
$table->set_column_filter(4, 'modify_filter');
$table->set_form_actions(array ('delete_classes' => get_lang('DeleteSelectedClasses')),'class');
$table->display();

/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>