<?php

// $Id: class_user_import.php 9018 2006-06-28 15:11:16Z evie_em $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2005 Bart Mollet <bart.mollet@hogent.be>

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
* This tool allows platform admins to update class-user relations by uploading a
* CSVfile
* @package iilearn.admin
==============================================================================
*/
// name of the language file that needs to be included 
$language_file = array ('admin', 'registration');

$cidReset = true;

include('../inc/global.inc.php');
require_once(api_get_path(LIBRARY_PATH).'fileManage.lib.php');
require_once(api_get_path(LIBRARY_PATH).'import.lib.php');
require_once(api_get_path(LIBRARY_PATH).'usermanager.lib.php');
require_once(api_get_path(LIBRARY_PATH).'classmanager.lib.php');
require_once(api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');

api_protect_admin_script();

/**
 * validate the imported data
 */
function validate_data($user_classes)
{
	$errors = array ();
	$classcodes = array ();
	foreach ($user_classes as $index => $user_class)
	{
		$user_class['line'] = $index +1;
		//1. check if mandatory fields are set
		$mandatory_fields = array ('UserName', 'ClassName');
		foreach ($mandatory_fields as $key => $field)
		{
			if (!isset ($user_class[$field]) || strlen($user_class[$field]) == 0)
			{
				$user_class['error'] = get_lang($field.'Mandatory');
				$errors[] = $user_class;
			}
		}
		//2. check if classcode exists
		if (isset ($user_class['ClassName']) && strlen($user_class['ClassName']) != 0)
		{
			//2.1 check if code allready used in this CVS-file
			if (!isset ($classcodes[$user_class['ClassName']]))
			{
				//2.1.1 check if code exists in DB
				$class_table = Database :: get_main_table(TABLE_MAIN_CLASS);
				$sql = "SELECT * FROM $class_table WHERE name = '".Database::escape_string($user_class['ClassName'])."'";
				$res = api_sql_query($sql, __FILE__, __LINE__);
				if (mysql_num_rows($res) == 0)
				{
					$user_class['error'] = get_lang('CodeDoesNotExists');
					$errors[] = $user_class;
				}
				else
				{
					$classcodes[$user_class['CourseCode']] = 1;
				}
			}
		}
		//3. check if username exists
		if (isset ($user_class['UserName']) && strlen($user_class['UserName']) != 0)
		{
			if (UserManager :: is_username_available($user_class['UserName']))
			{
				$user_class['error'] = get_lang('UnknownUser');
				$errors[] = $user_class;
			}
		}
	}
	return $errors;
}

/**
 * Save the imported data
 */
function save_data($users_classes)
{
	$user_table 		= Database :: get_main_table(TABLE_MAIN_USER);
	$class_user_table 	= Database :: get_main_table(TABLE_MAIN_CLASS_USER);
	$class_table 		= Database :: get_main_table(TABLE_MAIN_CLASS);
	
	$csv_data = array ();
	foreach ($users_classes as $index => $user_class)
	{
		$sql = "SELECT * FROM $class_table WHERE name = '".Database::escape_string($user_class['ClassName'])."'";
		$res = api_sql_query($sql, __FILE__, __LINE__);
		$obj = mysql_fetch_object($res);
		$csv_data[$user_class['UserName']][$obj->id] = 1;
	}
	foreach ($csv_data as $username => $csv_subscriptions)
	{
		$user_id = 0;
		$sql = "SELECT * FROM $user_table u WHERE u.username = '".Database::escape_string($username)."'";
		$res = api_sql_query($sql, __FILE__, __LINE__);
		$obj = mysql_fetch_object($res);
		$user_id = $obj->user_id;
		$sql = "SELECT * FROM $class_user_table cu WHERE cu.user_id = $user_id";
		$res = api_sql_query($sql, __FILE__, __LINE__);
		$db_subscriptions = array ();
		while ($obj = mysql_fetch_object($res))
		{
			$db_subscriptions[$obj->class_id] = 1;
		}
		$to_subscribe = array_diff(array_keys($csv_subscriptions), array_keys($db_subscriptions));
		$to_unsubscribe = array_diff(array_keys($db_subscriptions), array_keys($csv_subscriptions));
		
		foreach ($to_subscribe as $index => $class_id)
		{
			ClassManager :: add_user($user_id, $class_id);
		}
		
		/*
		if ($_POST['subscribe'])
		{
			foreach ($to_subscribe as $index => $class_id)
			{
				ClassManager :: add_user($user_id, $class_id);
			}
		}
		if ($_POST['unsubscribe'])
		{
			foreach ($to_unsubscribe as $index => $class_id)
			{
				ClassManager :: unsubscribe_user($user_id, $class_id);
			}
		}
		*/
	}
}
/**
 * Read the CSV-file
 * @param string $file Path to the CSV-file
 * @return array All course-information read from the file
 */
function parse_csv_data($file)
{
	$courses = Import :: csv_to_array($file);
	foreach ($courses as $index => $course)
	{
		$course['ClassName'] = mb_convert_encoding($course['ClassName'], SYSTEM_CHARSET, $_POST['import_encoding']);

		$courses[$index] = $course;
	}

	return $courses;
}

function doAction()
{
	if ($_FILES['import_file']['size'] !== 0)
	{
		set_time_limit(0);

		$file_type = $_POST['file_type'];
		if ($file_type == 'csv')
		{
			$users_classes = parse_csv_data($_FILES['import_file']['tmp_name']);
		}
		my_delete($_FILES['import_file']['tmp_name']);

		$errors = validate_data($users_classes);
		if (count($errors) == 0)
		{
			save_data($users_classes);
			header('Location: class_list.php?action=show_message&message='.urlencode(get_lang('FileImported')));
			exit ();
		}
		
		return $errors;
	}
}

$form = new FormValidator('class_user_import');

$form->addElement('header', 'header', get_lang('ImportUsersToAClass'));
$form->addElement('file', 'import_file', get_lang('ImportFileLocation'),  array('size'=>'45'));
$form->addRule('import_file', get_lang('ThisFieldIsRequired'), 'required');
$allowed_file_types = array ('csv');
$form->addRule('import_file', get_lang('InvalidExtension').' ('.implode(',', $allowed_file_types).')', 'filetype', $allowed_file_types);

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$form->addGroup($group,'file_type',get_lang('FileType'),null,false);

//$form->addElement('checkbox', 'unsubscribe', get_lang('Unreg'), get_lang('UnsubscribeUserIfSubscriptionIsNotInFile'));

$encodings = get_encodings();
$form->addElement('select', 'import_encoding', get_lang('ImportEncoding'), $encodings);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;');

$defaults['import_encoding'] = get_default_encoding();
$defaults['file_type'] = 'csv';
$form->setDefaults($defaults);

if ($form->validate())
{
	$errors = doAction();
}

$this_section = SECTION_PLATFORM_ADMIN;
$tool_name = get_lang('ImportUsersToAClass');
$interbreadcrumb[] = array ('url' => 'index.php', 'name' => get_lang('PlatformAdmin'));
$htmlHeadXtra[] =
"<script type='text/javascript'>
function display_example(id)
{
	if (id == 'cvs')
	{
		document.getElementById('cvs').style.display = 'block';
	}
}
</script>";

Display :: display_header($tool_name);

if (count($errors) != 0)
{
	$error_message = '<ul>';
	foreach ($errors as $index => $error_class_user)
	{
		$error_message .= '<li>' . get_lang('Line') . ' ' . $error_class_user['line'] . ' : <b>' . $error_class_user['error'] . '</b>';
		$error_message .= '</li>';
	}
	$error_message .= '</ul>';
	Display :: display_error_message($error_message, false);
}

Display::setTemplateBorder($form, '60%');
$form->display();

echo "<br>";

$temp = 'storage/examples/import_files/example_class_user_' . strtolower(get_default_encoding()) . '.csv';
if (is_file(api_get_path(SYS_PATH).$temp))
{
	$url_csv = api_get_path(WEB_PATH) . $temp;
}
else 
{
	$url_csv = api_get_path(WEB_PATH) . 'storage/examples/import_files/example_class_user.csv';
}
$html = "<a href='#' onclick=\"display_example('cvs');\">" . get_lang('ExampleCSVFile') . "</a>&nbsp;(<a href='" . $url_csv . "' target='_blank'>" . get_lang('Download') . "</a>)&nbsp;&nbsp;&nbsp;&nbsp;";

?>

<table align="center" width="60%">
<tr><td><?php echo $html; ?><br><br></td></tr>
<tr><td>
<div id="cvs" style="display:none">
<p><?php echo get_lang('CSVMustLookLike').' ('.get_lang('MandatoryFields').')'; ?> :</p>
<blockquote>
<pre>
<b>UserName</b>;<b>ClassName</b>
jdoe;class01
</pre>
</blockquote>
</div>
</td></tr>
</table>

<?php
/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>