<?php

// $Id: subscribe_class2course.php 10811 2007-01-22 08:26:40Z elixir_julian $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
============================================================================== 
*	@package iilearn.admin
============================================================================== 
*/
// name of the language file that needs to be included
$language_file = 'admin';

$cidReset = true;

require ('../inc/global.inc.php');

require_once (api_get_path(LIBRARY_PATH).'course.lib.php');
require_once (api_get_path(LIBRARY_PATH).'classmanager.lib.php');

api_protect_admin_script();

$classes = $_GET['classes'];
$form_sent = 0;
$error_message = '';
$first_letter_class = '';
$first_letter_course = '';
$courses = array ();
$classes = array();

$tbl_course = Database :: get_main_table(TABLE_MAIN_COURSE);
$tbl_class = Database :: get_main_table(TABLE_MAIN_CLASS);

$this_section=SECTION_PLATFORM_ADMIN;
$tool_name = get_lang('AddClassesToACourse');
$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));
$htmlHeadXtra[] =
"<script type='text/javascript'>
function sendForm(formSent)
{
	document.formulaire.formSent.value='2';
	if (formSent)
	{
		 document.formulaire.submit();
	} 
}
</script>";

Display :: display_header($tool_name);

if ($_POST['formSent'])
{
	$form_sent = $_POST['formSent'];
	$classes = is_array($_POST['ClassList']) ? $_POST['ClassList'] : array();
	$courses = is_array($_POST['CourseList']) ? $_POST['CourseList'] : array();
	$first_letter_class = $_POST['firstLetterClass'];
	$first_letter_course = $_POST['firstLetterCourse'];
	$addCourse = empty ($_POST['addCourse']) ? 0 : 1;
	$removeCourse = empty ($_POST['removeCourse']) ? 0 : 1;

	if ($form_sent == 1)
	{
		if (count($classes) == 0 || count($courses) == 0)
		{
			Display::display_error_message(get_lang('AtLeastOneClassAndOneCourse'));
		}
		elseif ($addCourse)
		{
			foreach ($courses as $course_code)
			{
				foreach ($classes as $class_id)
				{
					ClassManager :: subscribe_to_course($class_id, $course_code);
				}
			}
			Display::display_normal_message(get_lang('ClassesSubscribed'));
		}
		else if ($removeCourse)// remove classes from courses
		{
			foreach ($courses as $course_code)
			{
				foreach ($classes as $class_id)
				{
					ClassManager :: unsubscribe_from_course($class_id, $course_code);
				}
			}
			Display::display_normal_message(get_lang('ClassesUnsubscribed'));
		}
		
		$first_letter_class = '';
		$first_letter_course = '';
	}
}

$sql = "SELECT id,name FROM $tbl_class WHERE name LIKE '%".$first_letter_class."%' ORDER BY ". (count($classes) > 0 ? "(id IN('".implode("','", $classes)."')) DESC," : "")." name";
$result = api_sql_query($sql, __FILE__, __LINE__);
$db_classes = api_store_result($result);
//$sql = "SELECT code,visual_code,title FROM $tbl_course WHERE visual_code LIKE '%".$first_letter_course."%' ORDER BY ". (count($courses) > 0 ? "(code IN('".implode("','", $courses)."')) DESC," : "")." visual_code";
$sql = "SELECT code,visual_code,title FROM $tbl_course WHERE title LIKE '%".$first_letter_course."%' ORDER BY ". (count($courses) > 0 ? "(code IN('".implode("','", $courses)."')) DESC," : "")." title";
$result = api_sql_query($sql, __FILE__, __LINE__);
$db_courses = api_store_result($result);
if (!empty ($error_message))
{
	Display :: display_normal_message($error_message); 
}
?>
<form name="formulaire" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" style="margin:0px;">
 <input type="hidden" name="formSent" value="1"/>
 <table border="0" align="center" cellpadding="5" cellspacing="0">
  <tr>
   <td>
    <b><?php echo get_lang('ClassList'); ?></b>&nbsp;&nbsp;
	<input type="text" name="firstLetterClass" size="15" value="<?php echo $first_letter_class; ?>" onkeydown="sendForm(false);"/>
	<input  type="button" class="inputSubmit" name="searchLeft" value="<?php echo get_lang('Search'); ?>" onclick="sendForm(true);"/> 
   </td>
   <td width="20">&nbsp;</td>
   <td>
    <b><?php echo get_lang('CourseList'); ?></b>&nbsp;&nbsp;
	<input type="text" name="firstLetterCourse" size="15" value="<?php echo $first_letter_course; ?>" onkeydown="sendForm(false);"/>
	<input  type="button" class="inputSubmit" name="searchRight" value="<?php echo get_lang('Search'); ?>" onclick="sendForm(true);"/> 
    </select>
   </td>
  </tr>
  <tr>
   <td align="center">
    <select name="ClassList[]" multiple="multiple" size="20" style="width:300px;">
<?php
foreach ($db_classes as $class)
{
?>
	<option value="<?php echo $class['id']; ?>" <?php if(in_array($class['id'],$classes)) echo 'selected="selected"'; ?>><?php echo $class['name']; ?></option>
<?php
}
?>
    </select>
   </td>
   <td valign="middle" align="center">
    <input type="submit" name="addCourse" class="inputSubmitShort" value="&gt;&gt;"/>
    <br/><br>
    <input type="submit" name="removeCourse" class="inputSubmitShort" value="&lt;&lt;"/>
   </td>
   <td align="center">
    <select name="CourseList[]" multiple="multiple" size="20" style="width:300px;">
<?php
foreach ($db_courses as $course)
{
?>
	<option value="<?php echo $course['code']; ?>" <?php if(in_array($course['code'],$courses)) echo 'selected="selected"'; ?>><?php echo '('.$course['visual_code'].') '.$course['title']; ?></option>
<?php
}
?>
    </select>
   </td>
  </tr>
 </table>
 <br>
</form>
<?php
/*
==============================================================================
		FOOTER 
==============================================================================
*/
Display :: display_footer();
?>